/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintInfo;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintInfoInferrer;
import org.eclipse.viatra.query.runtime.localsearch.planner.PlanState;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.OperationCostComparator;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PApply;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PStart;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

public class LocalSearchRuntimeBasedStrategy {
    public SubPlan plan(PBody pBody, Set<PVariable> initialBoundVariables, IQueryBackendContext context, LocalSearchHints configuration) {
        final ICostFunction costFunction = configuration.getCostFunction();
        PConstraintInfoInferrer pConstraintInfoInferrer = new PConstraintInfoInferrer(configuration.isUseBase(), context, new Function<IConstraintEvaluationContext, Double>(){

            public Double apply(IConstraintEvaluationContext input) {
                return costFunction.apply(input);
            }
        });
        SubPlanFactory subPlanFactory = new SubPlanFactory(pBody);
        SubPlan plan = subPlanFactory.createSubPlan((POperation)new PStart(initialBoundVariables), new SubPlan[0]);
        Set constraintSet = pBody.getConstraints();
        List<PConstraintInfo> constraintInfos = pConstraintInfoInferrer.createPConstraintInfos(constraintSet);
        List<Set<PVariable>> reachableBoundVariableSets = this.reachabilityAnalysis(pBody, constraintInfos);
        int k = configuration.getRowCount();
        PlanState searchPlan = this.calculateSearchPlan(pBody, initialBoundVariables, k, reachableBoundVariableSets, constraintInfos);
        List<PConstraintInfo> operations = searchPlan.getOperations();
        for (PConstraintInfo pConstraintPlanInfo : operations) {
            PConstraint pConstraint = pConstraintPlanInfo.getConstraint();
            plan = subPlanFactory.createSubPlan((POperation)new PApply(pConstraint), new SubPlan[]{plan});
        }
        return subPlanFactory.createSubPlan((POperation)new PProject(pBody.getSymbolicParameterVariables()), new SubPlan[]{plan});
    }

    private PlanState calculateSearchPlan(PBody pBody, Set<PVariable> initialBoundVariables, int k, List<Set<PVariable>> reachableBoundVariableSets, List<PConstraintInfo> allMaskInfos) {
        Set<PVariable> boundVariables = initialBoundVariables;
        Sets.SetView freeVariables = Sets.difference((Set)pBody.getUniqueVariables(), initialBoundVariables);
        int n = freeVariables.size();
        List<List<PlanState>> stateTable = this.initializeStateTable(k, n);
        PlanState initialState = new PlanState(pBody, Lists.newArrayList(), boundVariables);
        OperationCostComparator infoComparator = new OperationCostComparator();
        Collections.sort(allMaskInfos, infoComparator);
        initialState.updateOperations(allMaskInfos, allMaskInfos);
        stateTable.get(n).add(0, initialState);
        int i = n;
        while (i > 0) {
            int j = 0;
            while (j < k && j < stateTable.get(i).size()) {
                PlanState currentState = stateTable.get(i).get(j);
                for (PConstraintInfo constraintInfo : currentState.getPresentExtends()) {
                    PlanState newState = this.calculateNextState(currentState, constraintInfo);
                    int i2 = Sets.difference((Set)pBody.getUniqueVariables(), newState.getBoundVariables()).size();
                    if (currentState.getBoundVariables().size() == newState.getBoundVariables().size()) continue;
                    List<Integer> newIndices = this.determineIndices(stateTable, i2, newState, k);
                    int a = newIndices.get(0);
                    int c = newIndices.get(1);
                    if (!this.checkInsertCondition(stateTable.get(i2), newState, reachableBoundVariableSets, a, c, k)) continue;
                    this.updateOperations(newState, currentState, constraintInfo);
                    this.insert(stateTable, i2, newState, a, c, k);
                }
                ++j;
            }
            --i;
        }
        return stateTable.get(0).get(0);
    }

    private List<List<PlanState>> initializeStateTable(int k, int n) {
        ArrayList stateTable = Lists.newArrayList();
        int i = 0;
        while (i <= n) {
            stateTable.add(Lists.newArrayList());
            ++i;
        }
        return stateTable;
    }

    private void insert(List<List<PlanState>> stateTable, int idx, PlanState newState, int a, int c, int k) {
        stateTable.get(idx).add(c, newState);
        while (stateTable.get(idx).size() > k) {
            stateTable.set(idx, stateTable.get(idx).subList(0, k));
        }
    }

    private void updateOperations(PlanState newState, PlanState currentState, PConstraintInfo constraintInfo) {
        List<PConstraintInfo> presentExtends = currentState.getPresentExtends();
        List<PConstraintInfo> futureExtends = currentState.getFutureExtends();
        List<PConstraintInfo> extendz = this.merge(presentExtends, futureExtends);
        newState.updateOperations(extendz, currentState.getFutureChecks());
    }

    private List<PConstraintInfo> merge(List<PConstraintInfo> presentExtensionsForState, List<PConstraintInfo> futureExtensionsForState) {
        int presentExtensionsIndex = 0;
        int futureExtensionsIndex = 0;
        int extensionIndex = 0;
        ArrayList extensions = Lists.newArrayList();
        while (presentExtensionsIndex < presentExtensionsForState.size() || futureExtensionsIndex < futureExtensionsForState.size()) {
            if (futureExtensionsIndex >= futureExtensionsForState.size() || presentExtensionsIndex < presentExtensionsForState.size() && presentExtensionsForState.get(presentExtensionsIndex).getCost() < futureExtensionsForState.get(futureExtensionsIndex).getCost()) {
                extensions.add(extensionIndex, presentExtensionsForState.get(presentExtensionsIndex));
                ++presentExtensionsIndex;
            } else {
                extensions.add(extensionIndex, futureExtensionsForState.get(futureExtensionsIndex));
                ++futureExtensionsIndex;
            }
            ++extensionIndex;
        }
        return extensions;
    }

    private boolean checkInsertCondition(List<PlanState> list, PlanState newState, List<Set<PVariable>> reachableBoundVariableSets, int a, int c, int k) {
        boolean isBetterThanCurrent;
        boolean isAmongBestK = a == k && c < a;
        boolean bl = isBetterThanCurrent = a < k && c <= a;
        return isAmongBestK || isBetterThanCurrent;
    }

    private List<Integer> determineIndices(List<List<PlanState>> stateTable, int i2, PlanState newState, int k) {
        int a = k;
        int c = 0;
        ArrayList acIndices = Lists.newArrayList();
        int j = 0;
        while (j < k) {
            if (j >= stateTable.get(i2).size()) break;
            PlanState stateInTable = stateTable.get(i2).get(j);
            if (newState.getBoundVariables().equals(stateInTable.getBoundVariables())) {
                a = j;
            }
            if (newState.getCost() >= stateInTable.getCost()) {
                c = j + 1;
            }
            ++j;
        }
        acIndices.add(a);
        acIndices.add(c);
        return acIndices;
    }

    private PlanState calculateNextState(PlanState currentState, PConstraintInfo constraintInfo) {
        ArrayList newOperationsList = Lists.newArrayList(currentState.getOperations());
        newOperationsList.add(constraintInfo);
        Sets.SetView allBoundVariables = Sets.union(currentState.getBoundVariables(), (Set)constraintInfo.getFreeVariables());
        PlanState newState = new PlanState(currentState.getAssociatedPBody(), newOperationsList, (Set<PVariable>)allBoundVariables.immutableCopy());
        return newState;
    }

    private List<Set<PVariable>> reachabilityAnalysis(PBody pBody, List<PConstraintInfo> constraintInfos) {
        ArrayList reachableBoundVariableSets = Lists.newArrayList();
        return reachableBoundVariableSets;
    }

    protected EClassifier extractClassifierLiteral(String packageUriAndClassifierName) {
        int lastSlashPosition = packageUriAndClassifierName.lastIndexOf(47);
        int scopingPosition = packageUriAndClassifierName.lastIndexOf("::");
        String packageUri = packageUriAndClassifierName.substring(scopingPosition + 2, lastSlashPosition);
        String classifierName = packageUriAndClassifierName.substring(lastSlashPosition + 1);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageUri);
        Preconditions.checkState((ePackage != null ? 1 : 0) != 0, (String)"EPackage %s not found in EPackage Registry.", (Object[])new Object[]{packageUri});
        EClassifier literal = ePackage.getEClassifier(classifierName);
        Preconditions.checkState((literal != null ? 1 : 0) != 0, (String)"Classifier %s not found in EPackage %s", (Object[])new Object[]{classifierName, packageUri});
        return literal;
    }
}

