/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase.AbstractIteratingExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;

public class IterateOverEDatatypeInstances
extends AbstractIteratingExtendOperation<Object>
implements IIteratingSearchOperation {
    private EDataType dataType;

    public IterateOverEDatatypeInstances(int position, EDataType dataType, EMFScope scope) {
        super(position, scope);
        this.dataType = dataType;
    }

    protected Iterator<EAttribute> doGetEAttributes(EClass eclass, ISearchContext context) {
        Table cache = context.accessBackendLevelCache(this.getClass(), Table.class, new IProvider<Table>(){

            public Table<EDataType, EClass, Set<EAttribute>> get() {
                return HashBasedTable.create();
            }
        });
        if (!cache.contains((Object)this.dataType, (Object)eclass)) {
            EList eAllAttributes = eclass.getEAllAttributes();
            cache.put((Object)this.dataType, (Object)eclass, (Object)Sets.filter((Set)Sets.newHashSet((Iterable)eAllAttributes), (Predicate)new Predicate<EAttribute>(){

                public boolean apply(EAttribute input) {
                    return input.getEType().equals(IterateOverEDatatypeInstances.this.dataType);
                }
            }));
        }
        return ((Set)cache.get((Object)this.dataType, (Object)eclass)).iterator();
    }

    public EDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void onInitialize(MatchingFrame frame, final ISearchContext context) {
        this.it = Iterators.concat((Iterator)Iterators.transform((Iterator)Iterators.filter(this.getModelContents(), EObject.class), (Function)new Function<EObject, Iterator<Object>>(){

            public Iterator<Object> apply(final EObject input) {
                Iterator<EAttribute> features = IterateOverEDatatypeInstances.this.doGetEAttributes(input.eClass(), context);
                return Iterators.concat((Iterator)Iterators.transform(features, (Function)new Function<EAttribute, Iterator<?>>(){

                    public Iterator<?> apply(EAttribute attribute) {
                        if (attribute.isMany()) {
                            return ((List)input.eGet((EStructuralFeature)attribute)).iterator();
                        }
                        Object o = input.eGet((EStructuralFeature)attribute);
                        return o == null ? Collections.emptyIterator() : Iterators.singletonIterator((Object)o);
                    }
                }));
            }
        }));
    }

    public String toString() {
        return "extend    " + this.dataType.getName() + "(-" + this.position + ") iterating";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.position, (Object[])new Integer[0]);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return new EDataTypeInSlotsKey(this.dataType);
    }
}

