/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.CallOperationHelper;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;

public class CountCheck
extends CheckOperation {
    private final CallOperationHelper helper;
    private CallOperationHelper.PatternCall call;
    private int position;

    public CountCheck(MatcherReference calledQuery, Map<PParameter, Integer> parameterMapping, int position) {
        this.helper = new CallOperationHelper(calledQuery, parameterMapping);
        this.position = position;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        super.onInitialize(frame, context);
        this.call = this.helper.createCall(context);
    }

    @Deprecated
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        return this.check(frame, null);
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        int count = this.call.count(frame);
        return (Integer)frame.getValue(this.position) == count;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.position, (Object[])new Integer[0]);
    }

    public String toString() {
        return "check     " + this.position + " = count find " + this.helper.toString();
    }
}

