/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;

public class ContainmentCheck
extends CheckOperation {
    int childPosition;
    int containerPosition;
    private boolean transitive;

    public ContainmentCheck(int childPosition, int containerPosition, boolean transitive) {
        this.childPosition = childPosition;
        this.containerPosition = containerPosition;
        this.transitive = transitive;
    }

    @Deprecated
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        return this.check(frame, null);
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        try {
            EObject child = (EObject)frame.getValue(this.childPosition);
            EObject container = (EObject)frame.getValue(this.containerPosition);
            if (this.transitive) {
                return EcoreUtil.isAncestor((EObject)container, (EObject)child);
            }
            return child.eContainer().equals(container);
        }
        catch (ClassCastException e) {
            throw new LocalSearchException("Invalid type of variable", e);
        }
    }

    public String toString() {
        return "check     containment +" + this.containerPosition + " <>--> +" + this.childPosition + (this.transitive ? " transitively" : " directly");
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.childPosition, (Object)this.containerPosition, (Object[])new Integer[0]);
    }
}

