/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IUpdateable;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class CallOperationHelper {
    private final PQuery calledQuery;
    private final Set<PParameter> adornment;
    private final Map<PParameter, Integer> parameterMapping;
    private final Multimap<Integer, Integer> frameMapping;

    private static Multimap<Integer, Integer> calculateFrameMapping(PQuery calledQuery, Map<PParameter, Integer> parameterMapping) {
        ListMultimap frameMapping = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<Integer>>(){

            public List<Integer> get() {
                return new ArrayList<Integer>(1);
            }
        });
        for (Map.Entry<PParameter, Integer> entry : parameterMapping.entrySet()) {
            frameMapping.put((Object)entry.getValue(), (Object)calledQuery.getPositionOfParameter(entry.getKey().getName()));
        }
        return frameMapping;
    }

    public CallOperationHelper(MatcherReference calledQuery, Map<PParameter, Integer> parameterMapping) {
        this.calledQuery = calledQuery.getQuery();
        this.adornment = calledQuery.getAdornment();
        this.parameterMapping = parameterMapping;
        this.frameMapping = CallOperationHelper.calculateFrameMapping(calledQuery.getQuery(), parameterMapping);
    }

    @Deprecated
    public PatternCall createCall(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        return new PatternCall(this.adornment, context);
    }

    @Deprecated
    public PatternCall createCall(Set<Integer> adornment, ISearchContext context) throws LocalSearchException {
        return new PatternCall(this.adornment, context);
    }

    public PatternCall createCall(ISearchContext context) throws LocalSearchException {
        return new PatternCall(this.adornment, context);
    }

    public List<Integer> getVariablePositions() {
        ArrayList<Integer> variables = new ArrayList<Integer>(this.parameterMapping.size());
        for (PParameter p : this.calledQuery.getParameters()) {
            variables.add(this.parameterMapping.get(p));
        }
        return variables;
    }

    public PQuery getCalledQuery() {
        return this.calledQuery;
    }

    public String toString() {
        return String.valueOf(this.calledQuery.getFullyQualifiedName()) + "(" + Joiner.on((String)",").join(Iterables.transform((Iterable)this.calledQuery.getParameters(), (Function)new Function<PParameter, String>(){

            public String apply(PParameter input) {
                return String.valueOf(CallOperationHelper.this.adornment.contains(input) ? "+" : "-") + CallOperationHelper.this.parameterMapping.get(input);
            }
        })) + ")";
    }

    public class PatternCall {
        IQueryResultProvider matcher;
        Set<PParameter> adornment;
        Set<Integer> filledVariables;

        public boolean fillInResult(MatchingFrame frame, Tuple result) {
            this.filledVariables = Sets.newHashSet();
            Multimap backMap = Multimaps.invertFrom((Multimap)CallOperationHelper.this.frameMapping, (Multimap)ArrayListMultimap.create());
            int i = 0;
            while (i < result.getSize()) {
                if (!this.adornment.contains(CallOperationHelper.this.calledQuery.getParameters().get(i))) {
                    Object value = null;
                    for (Integer j : backMap.get((Object)i)) {
                        Object filledValue = result.get(i);
                        if (value != null && !value.equals(filledValue)) {
                            return false;
                        }
                        value = filledValue;
                        frame.setValue(j, filledValue);
                        this.filledVariables.add(j);
                    }
                }
                ++i;
            }
            return true;
        }

        public void backtrack(MatchingFrame frame) {
            if (this.filledVariables != null) {
                for (Integer i : this.filledVariables) {
                    frame.setValue(i, null);
                }
            }
        }

        private PatternCall(Set<PParameter> adornment, ISearchContext context) throws LocalSearchException {
            this.adornment = adornment;
            this.matcher = context.getMatcher(new MatcherReference(CallOperationHelper.this.calledQuery, this.adornment));
        }

        private Object[] mapFrame(MatchingFrame frameInCaller) {
            Object[] parameterValues = new Object[CallOperationHelper.this.calledQuery.getParameters().size()];
            for (Map.Entry entry : CallOperationHelper.this.frameMapping.entries()) {
                parameterValues[((Integer)entry.getValue()).intValue()] = frameInCaller.getValue((Integer)entry.getKey());
            }
            return parameterValues;
        }

        public boolean has(MatchingFrame frame) {
            return this.matcher.getOneArbitraryMatch(this.mapFrame(frame)) != null;
        }

        public int count(MatchingFrame frame) {
            return this.matcher.countMatches(this.mapFrame(frame));
        }

        public <Domain, Accumulator, AggregateResult> AggregateResult aggregate(IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, int aggregatedColumn, MatchingFrame initialFrame) {
            Object[] frame = this.mapFrame(initialFrame);
            Object accumulator = operator.createNeutral();
            for (Tuple match : this.matcher.getAllMatches(frame)) {
                Object column = match.get(aggregatedColumn);
                accumulator = operator.update(accumulator, column, true);
            }
            return (AggregateResult)operator.getAggregate(accumulator);
        }

        public Collection<? extends Tuple> getAllMatches(Object[] mappedFrame) {
            return this.matcher.getAllMatches(mappedFrame);
        }

        public Collection<? extends Tuple> getAllMatches(MatchingFrame frameInCaller) {
            return this.matcher.getAllMatches(this.mapFrame(frameInCaller));
        }

        public void registerChangeListener(IUpdateable listener) {
            this.matcher.addUpdateListener(listener, (Object)listener, true);
        }

        public void removeChangeListener(IUpdateable listener) {
            this.matcher.removeUpdateListener((Object)listener);
        }
    }
}

