/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.IAdornmentProvider;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHintOptions;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryResultProviderAccess;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.util.ICache;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;

public interface ISearchContext {
    public IQueryRuntimeContext getRuntimeContext();

    public void registerObservedTypes(Set<EClass> var1, Set<EDataType> var2, Set<EStructuralFeature> var3);

    public IQueryResultProvider getMatcher(MatcherReference var1) throws LocalSearchException;

    public <T> T accessBackendLevelCache(Object var1, Class<? extends T> var2, IProvider<T> var3);

    public static class SearchContext
    implements ISearchContext {
        private final NavigationHelper navigationHelper;
        private final IQueryResultProviderAccess resultProviderAccess;
        private final QueryEvaluationHint overrideHints;
        private final IQueryRuntimeContext runtimeContext;
        private final ICache backendLevelCache;

        public SearchContext(IQueryBackendContext backendContext, QueryEvaluationHint overrideHints, ICache backendLevelCache) {
            this.runtimeContext = backendContext.getRuntimeContext();
            this.navigationHelper = null;
            this.resultProviderAccess = backendContext.getResultProviderAccess();
            this.overrideHints = overrideHints;
            this.backendLevelCache = backendLevelCache;
        }

        @Override
        public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) {
            if (this.navigationHelper.isInWildcardMode()) {
                return;
            }
            this.navigationHelper.registerObservedTypes(classes, dataTypes, features, IndexingLevel.FULL);
        }

        @Override
        public IQueryResultProvider getMatcher(final MatcherReference reference) throws LocalSearchException {
            IAdornmentProvider adornmentProvider = new IAdornmentProvider(){

                @Override
                public Iterable<Set<PParameter>> getAdornments(PQuery query) {
                    if (query.equals(reference.query)) {
                        return Collections.singleton(reference.adornment);
                    }
                    return Collections.emptySet();
                }
            };
            QueryEvaluationHint hints = new QueryEvaluationHint(Collections.singletonMap(LocalSearchHintOptions.ADORNMENT_PROVIDER, adornmentProvider), null);
            if (this.overrideHints != null) {
                hints = this.overrideHints.overrideBy(hints);
            }
            try {
                return this.resultProviderAccess.getResultProvider(reference.getQuery(), hints);
            }
            catch (QueryProcessingException e) {
                throw new LocalSearchException("Could not access referenced query: " + reference, e);
            }
        }

        @Override
        public <T> T accessBackendLevelCache(Object key, Class<? extends T> clazz, IProvider<T> valueProvider) {
            return (T)this.backendLevelCache.getValue(key, clazz, valueProvider);
        }

        @Override
        public IQueryRuntimeContext getRuntimeContext() {
            return this.runtimeContext;
        }
    }
}

