/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.properties.HintsPropertySource;
import org.eclipse.viatra.query.tooling.ui.queryresult.properties.MatcherFiltersPropertySource;

public class QueryResultTreeMatcherPropertySource
implements IPropertySource {
    private static final String FILTERS_ID = "filters";
    private static final String BACKEND_ID = "backend";
    private static final String HINTS_ID = "hints";
    private QueryResultTreeMatcher matcher;

    public QueryResultTreeMatcherPropertySource(QueryResultTreeMatcher matcher) {
        this.matcher = matcher;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String category = "Info";
        PropertyDescriptor hintsProperty = new PropertyDescriptor((Object)HINTS_ID, "Hints");
        hintsProperty.setCategory(category);
        PropertyDescriptor backendProperty = new PropertyDescriptor((Object)BACKEND_ID, "Backend");
        backendProperty.setCategory(category);
        PropertyDescriptor matchCountProperty = new PropertyDescriptor((Object)FILTERS_ID, "Filters");
        matchCountProperty.setCategory(category);
        return new IPropertyDescriptor[]{backendProperty, hintsProperty, matchCountProperty};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(HINTS_ID)) {
            if (this.matcher.getHint() != null) {
                return new HintsPropertySource(this.matcher.getHint());
            }
            return "Unknown";
        }
        if (id.equals(BACKEND_ID)) {
            if (this.matcher.getHint() != null) {
                return this.matcher.getHint().getQueryBackendFactory().getBackendClass().getSimpleName();
            }
            return "Unknown";
        }
        if (id.equals(FILTERS_ID)) {
            return new MatcherFiltersPropertySource(this.matcher);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (id.equals(FILTERS_ID)) {
            return this.matcher.isFiltered();
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (id.equals(FILTERS_ID)) {
            this.matcher.resetFilter();
        }
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

