/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.shared;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.ui.containers.JavaProjectsState;
import org.eclipse.xtext.ui.containers.StrictJavaProjectsState;
import org.eclipse.xtext.ui.containers.WorkspaceProjectsState;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.notification.IStateChangeEventBroker;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.ui.shared.internal.Activator;
import org.eclipse.xtext.ui.util.IJdtHelper;

public class Access {
    public static <T> Provider<T> contributedProvider(Class<? extends T> clazz) {
        return new InternalProviderForContribution<T>(clazz);
    }

    public static <T> Provider<T> provider(Class<? extends T> clazz) {
        return new InternalProvider<T>(clazz);
    }

    public static Provider<IResourceDescriptions> getIResourceDescriptions() {
        return Access.provider(IResourceDescriptions.class);
    }

    public static Provider<IStorage2UriMapper> getIStorage2UriMapper() {
        return Access.provider(IStorage2UriMapper.class);
    }

    public static Provider<IStorage2UriMapperJdtExtensions> getIStorage2UriMapperJdtExtensions() {
        return new InternalProviderForOptionalContribution<IStorage2UriMapperJdtExtensions>(IStorage2UriMapperJdtExtensions.class);
    }

    public static Provider<IStateChangeEventBroker> getIStateChangeEventBroker() {
        return Access.provider(IStateChangeEventBroker.class);
    }

    public static Provider<IDirtyStateManager> getIDirtyStateManager() {
        return Access.provider(IDirtyStateManager.class);
    }

    public static Provider<IBuilderState> getIBuilderState() {
        return Access.provider(IBuilderState.class);
    }

    public static Provider<IURIEditorOpener> getIURIEditorOpener() {
        return Access.provider(IURIEditorOpener.class);
    }

    public static Provider<IAllContainersState> getWorkspaceProjectsState() {
        return Access.contributedProvider(WorkspaceProjectsState.class);
    }

    public static Provider<IAllContainersState> getJavaProjectsState() {
        return Access.contributedProvider(JavaProjectsState.class);
    }

    public static Provider<IAllContainersState> getStrictJavaProjectsState() {
        return Access.contributedProvider(StrictJavaProjectsState.class);
    }

    public static Provider<IJdtHelper> getJdtHelper() {
        return Access.provider(IJdtHelper.class);
    }

    public static Provider<ISharedStateContributionRegistry> getSharedStateContributionRegistry() {
        return Access.provider(ISharedStateContributionRegistry.class);
    }

    public static Provider<QueuedBuildData> getQueuedBuildData() {
        return Access.provider(QueuedBuildData.class);
    }

    static class InternalProvider<T>
    implements Provider<T> {
        private Class<? extends T> clazz;

        public InternalProvider(Class<? extends T> clazz) {
            this.clazz = clazz;
        }

        public T get() {
            if (Activator.getDefault() == null) {
                throw new IllegalStateException("The bundle has not been started!");
            }
            return (T)Activator.getDefault().getInjector().getInstance(this.clazz);
        }
    }

    static class InternalProviderForContribution<T>
    implements Provider<T> {
        private Class<? extends T> clazz;
        private Provider<? extends T> delegate;

        public InternalProviderForContribution(Class<? extends T> clazz) {
            this.clazz = clazz;
        }

        @Inject
        private void inject(ISharedStateContributionRegistry registry) {
            this.delegate = registry.getLazySingleContributedInstance(this.clazz);
        }

        public T get() {
            return (T)this.delegate.get();
        }
    }

    private static class InternalProviderForOptionalContribution<T>
    implements Provider<T> {
        private Class<? extends T> clazz;
        private Provider<? extends T> delegate;

        private InternalProviderForOptionalContribution(Class<? extends T> clazz) {
            this.clazz = clazz;
        }

        @Inject
        private void inject(ISharedStateContributionRegistry registry) {
            ImmutableList allContributions = registry.getLazyContributedInstances(this.clazz);
            if (allContributions.size() == 1) {
                this.delegate = registry.getLazySingleContributedInstance(this.clazz);
            }
        }

        public T get() {
            if (this.delegate == null) {
                throw new ProvisionException("Missing contribution for " + this.clazz.getName());
            }
            return (T)this.delegate.get();
        }
    }
}

