/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.views;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.viatra.integration.zest.viewer.ModifiableZestContentViewer;
import org.eclipse.viatra.integration.zest.viewer.ZestContentViewer;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackend;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.LocalSearchDebugger;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.internal.LocalSearchDebuggerRunner;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.FrameViewerContentProvider;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.MatchesTableLabelProvider;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.OperationListContentProvider;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.OperationListLabelProvider;

public class LocalSearchDebugView
extends ViewPart {
    public static final String ID = "org.eclipse.viatra.query.tooling.localsearch.ui.LocalSearchDebugView";
    public static final String VIEWER_KEY = "key";
    private OperationListContentProvider operationListContentProvider;
    private TreeViewer operationListViewer;
    private ZestContentViewer graphViewer;
    private SashForm planSashForm;
    private CTabFolder matchesTabFolder;
    private Map<String, TableViewer> matchViewersMap = Maps.newHashMap();
    private LocalSearchDebugger debugger;
    private Thread planExecutorThread = null;

    public void createDebugger(AdvancedViatraQueryEngine engine, IQuerySpecification<?> query, Object[] adornment) throws ViatraQueryException, QueryProcessingException {
        this.disposeExistingDebugger();
        this.initializeDebugger(engine, query, adornment);
        this.closeMatchTabs();
    }

    private String getSimpleQueryName(PQuery query) {
        String[] stringTokens = query.getFullyQualifiedName().split("\\.");
        String queryName = stringTokens[stringTokens.length - 1];
        return queryName;
    }

    private void initializeDebugger(AdvancedViatraQueryEngine engine, IQuerySpecification<?> specification, Object[] adornment) throws ViatraQueryException, QueryProcessingException {
        IQueryBackend lsBackend = engine.getQueryBackend((IQueryBackendFactory)LocalSearchBackendFactory.INSTANCE);
        LocalSearchResultProvider lsResultProvider = (LocalSearchResultProvider)lsBackend.getResultProvider(specification.getInternalQueryRepresentation());
        final LocalSearchBackend localSearchBackend = (LocalSearchBackend)lsBackend;
        this.debugger = new LocalSearchDebugger(){

            @Override
            public void dispose() {
                localSearchBackend.removeAdapter((ILocalSearchAdapter)this);
                super.dispose();
            }
        };
        localSearchBackend.addAdapter((ILocalSearchAdapter)this.debugger);
        LocalSearchDebuggerRunner planExecutorRunnable = new LocalSearchDebuggerRunner(this.debugger, adornment, lsResultProvider);
        if (this.planExecutorThread == null || !this.planExecutorThread.isAlive()) {
            this.planExecutorThread = new Thread(planExecutorRunnable);
            this.planExecutorThread.start();
        } else if (this.planExecutorThread.isAlive()) {
            this.planExecutorThread.interrupt();
            this.planExecutorThread = new Thread(planExecutorRunnable);
            this.planExecutorThread.start();
        }
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        service.requestEvaluation("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.operational");
    }

    public void setDebugger(LocalSearchDebugger localSearchDebugger) {
        this.debugger = localSearchDebugger;
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        service.requestEvaluation("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.operational");
    }

    public LocalSearchDebugger getDebugger() {
        return this.debugger;
    }

    public CTabFolder getMatchesTabFolder() {
        return this.matchesTabFolder;
    }

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        this.planSashForm = new SashForm((Composite)sashForm, 512);
        this.createTreeViewer(this.planSashForm);
        this.matchesTabFolder = new CTabFolder((Composite)this.planSashForm, 66);
        this.createZestViewer(sashForm);
    }

    public void recreateColumns(List<String> colNames, int keySize, TableViewer matchesViewer) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = matchesViewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.dispose();
            ++n2;
        }
        int i = 0;
        while (i < colNames.size()) {
            TableViewerColumn col = this.createTableViewerColumn(colNames.get(i), 100, i, matchesViewer);
            col.setLabelProvider((CellLabelProvider)new MatchesTableLabelProvider(i, i < keySize, matchesViewer));
            ++i;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber, TableViewer matchesViewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(matchesViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createZestViewer(SashForm sashForm) {
        this.graphViewer = new ModifiableZestContentViewer();
        this.graphViewer.createControl((Composite)sashForm, 2048);
        FrameViewerContentProvider zestContentProvider = new FrameViewerContentProvider();
        this.graphViewer.setContentProvider((IContentProvider)zestContentProvider);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.graphViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        ILayoutAlgorithm layout = this.getLayout();
        this.graphViewer.setLayoutAlgorithm(layout);
    }

    private void createTreeViewer(SashForm sashForm) {
        this.operationListViewer = new TreeViewer((Composite)sashForm, 2818);
        this.operationListContentProvider = new OperationListContentProvider();
        this.operationListViewer.setContentProvider((IContentProvider)this.operationListContentProvider);
        this.operationListViewer.setLabelProvider((IBaseLabelProvider)new OperationListLabelProvider());
        this.operationListViewer.setInput(null);
    }

    private ILayoutAlgorithm getLayout() {
        TreeLayoutAlgorithm layout = new TreeLayoutAlgorithm();
        return layout;
    }

    public void setFocus() {
        this.operationListViewer.getControl().setFocus();
    }

    public void refreshView() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LocalSearchDebugView.this.operationListViewer.refresh();
                LocalSearchDebugView.this.graphViewer.refresh();
                Collection tableViewers = LocalSearchDebugView.this.matchViewersMap.values();
                for (TableViewer tableViewer : tableViewers) {
                    tableViewer.refresh();
                }
            }
        });
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        service.requestEvaluation("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.operational");
    }

    public TreeViewer getOperationListViewer() {
        return this.operationListViewer;
    }

    public void setOperationListViewer(TreeViewer operationListViewer) {
        this.operationListViewer = operationListViewer;
    }

    public OperationListContentProvider getOperationListContentProvider() {
        return this.operationListContentProvider;
    }

    public ZestContentViewer getGraphViewer() {
        return this.graphViewer;
    }

    public TableViewer getMatchesViewer(PQuery query) {
        String queryName = this.getSimpleQueryName(query);
        TableViewer viewer = this.matchViewersMap.get(queryName);
        if (viewer == null) {
            this.getOrCreateMatchesTab(queryName);
        }
        return this.matchViewersMap.get(queryName);
    }

    private void getOrCreateMatchesTab(final String tabTitle) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CTabItem item = new CTabItem(LocalSearchDebugView.this.getMatchesTabFolder(), 0);
                item.setText(tabTitle);
                LocalSearchDebugView.this.getMatchesTabFolder().setSelection(item);
                Composite container = new Composite((Composite)LocalSearchDebugView.this.getMatchesTabFolder(), 0);
                container.setLayout((Layout)new FillLayout());
                final TableViewer viewer = LocalSearchDebugView.this.createTableViewer(container);
                viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection() instanceof IStructuredSelection) {
                            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                            MatchingFrame frame = (MatchingFrame)selection.getFirstElement();
                            LocalSearchDebugView.this.graphViewer.setInput((Object)frame);
                            LocalSearchDebugView.this.graphViewer.refresh();
                        }
                    }
                });
                LocalSearchDebugView.this.matchViewersMap.put(tabTitle, viewer);
                viewer.refresh();
                ArrayList matchViewerInput = Lists.newArrayList();
                viewer.setData(LocalSearchDebugView.VIEWER_KEY, (Object)matchViewerInput);
                viewer.setInput((Object)matchViewerInput);
                item.setControl((Control)container);
                item.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        viewer.setSelection(null);
                    }
                });
                item.addListener(15, new Listener(){

                    public void handleEvent(Event event) {
                        viewer.setSelection(null);
                    }
                });
            }
        });
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer matchesViewer = new TableViewer(parent, 68354);
        matchesViewer.setContentProvider((IContentProvider)new MatchTableContentProvider());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        matchesViewer.getControl().setLayoutData((Object)gridData);
        Table table = matchesViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return matchesViewer;
    }

    public void dispose() {
        this.disposeExistingDebugger();
        super.dispose();
    }

    private void disposeExistingDebugger() {
        if (this.debugger != null) {
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    private void closeMatchTabs() {
        CTabItem[] cTabItemArray = this.getMatchesTabFolder().getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.matchViewersMap.clear();
    }

    private static class MatchTableContentProvider
    implements IStructuredContentProvider {
        private MatchTableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }
}

