/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.viatra.addon.viewers.runtime.notation.FormatSpecification;
import org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationFactory;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;

public final class FormatParser {
    public static final String ANNOTATION_ID = "Format";
    private static final String PREFIX = "org.eclipse.viatra.viewers.format.";
    public static final String COLOR = "org.eclipse.viatra.viewers.format.color";
    public static final String LINE_COLOR = "org.eclipse.viatra.viewers.format.linecolor";
    public static final String TEXT_COLOR = "org.eclipse.viatra.viewers.format.textcolor";
    public static final String LINE_WIDTH = "org.eclipse.viatra.viewers.format.linewidth";
    public static final String LINE_STYLE = "org.eclipse.viatra.viewers.format.linestyle";
    public static final String ARROW_SOURCE_END = "org.eclipse.viatra.viewers.format.arrowsourceend";
    public static final String ARROW_TARGET_END = "org.eclipse.viatra.viewers.format.arrowtargetend";
    private static final Map<String, String> parameterMapping = ImmutableMap.builder().put((Object)"color", (Object)"org.eclipse.viatra.viewers.format.color").put((Object)"lineColor", (Object)"org.eclipse.viatra.viewers.format.linecolor").put((Object)"textColor", (Object)"org.eclipse.viatra.viewers.format.textcolor").put((Object)"lineWidth", (Object)"org.eclipse.viatra.viewers.format.linewidth").put((Object)"lineStyle", (Object)"org.eclipse.viatra.viewers.format.linestyle").put((Object)"arrowSourceEnd", (Object)"org.eclipse.viatra.viewers.format.arrowsourceend").put((Object)"arrowTargetEnd", (Object)"org.eclipse.viatra.viewers.format.arrowtargetend").build();

    private FormatParser() {
    }

    public static boolean isFormatted(FormattableElement element) {
        return element.getFormat() != null;
    }

    public static FormatSpecification parseFormatAnnotation(PAnnotation format) {
        FormatSpecification specification = NotationFactory.eINSTANCE.createFormatSpecification();
        for (Map.Entry param : format.getAllValues()) {
            FormatParser.parseParameter((String)param.getKey(), param.getValue(), specification);
        }
        return specification;
    }

    private static void parseParameter(String name, Object value, FormatSpecification specification) {
        String key = parameterMapping.get(name);
        if (value instanceof String) {
            specification.getProperties().put((Object)key, (Object)((String)value));
        } else if (value instanceof Integer) {
            specification.getProperties().put((Object)key, (Object)Integer.toString((Integer)value));
        }
    }

    public static RGB parseColor(String colorString) {
        String colorRegexp = "#[A-Fa-f0-9]{6}";
        if (colorString == null || !colorString.matches(colorRegexp)) {
            return null;
        }
        int red = Integer.parseInt(colorString.substring(1, 3), 16);
        int green = Integer.parseInt(colorString.substring(3, 5), 16);
        int blue = Integer.parseInt(colorString.substring(5, 7), 16);
        return new RGB(red, green, blue);
    }

    public static RGB getColorFormatProperty(FormattableElement element, String index) {
        return FormatParser.parseColor((String)element.getFormat().getProperties().get((Object)index));
    }

    public static int getNumberProperty(FormattableElement element, String index) {
        try {
            return Integer.parseInt((String)element.getFormat().getProperties().get((Object)index));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getStringProperty(FormattableElement element, String index) {
        return (String)element.getFormat().getProperties().get((Object)index);
    }
}

