/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.viatra.addon.viewers.runtime.ViewersRuntimePlugin;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViatraViewersPartSupport;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public abstract class ViatraViewersViewSupport
extends ViatraViewersPartSupport {
    protected IModelConnectorTypeEnum connectorType = IModelConnectorTypeEnum.RESOURCESET;
    protected ViewerState state;
    protected EMFScope modelSource;
    private Composite parent;
    private Composite cover;
    private Control contents;
    private StackLayout layout;

    public ViatraViewersViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, IModelConnectorTypeEnum _scope) {
        super((IWorkbenchPart)_owner, _config);
        this.connectorType = _scope;
    }

    protected IViewPart getOwner() {
        return (IViewPart)this.owner;
    }

    @Override
    public void dispose() {
        this.unbindModel();
        super.dispose();
    }

    @Override
    protected void onSelectionChanged(List<Object> objects) {
        try {
            EMFScope target = this.extractModelSource(objects);
            if (target != null && !target.equals((Object)this.modelSource)) {
                this.unsetModelSource();
                this.setModelSource(target);
            }
        }
        catch (ViatraQueryException e) {
            throw new RuntimeException("Failed to extract model source", e);
        }
    }

    protected EMFScope extractModelSource(List<Object> objects) throws ViatraQueryException {
        ImmutableSet notifiers = ImmutableSet.copyOf((Iterable)Iterables.filter(objects, Notifier.class));
        switch (this.connectorType) {
            default: {
                Iterator iterator = notifiers.iterator();
                if (!iterator.hasNext()) break;
                Notifier n = (Notifier)iterator.next();
                if (n instanceof ResourceSet) {
                    return new EMFScope(n);
                }
                if (n instanceof Resource) {
                    return new EMFScope((Notifier)((Resource)n).getResourceSet());
                }
                EObject eO = (EObject)n;
                return new EMFScope((Notifier)eO.eResource().getResourceSet());
            }
            case RESOURCE: {
                for (Notifier n : notifiers) {
                    if (n instanceof ResourceSet) continue;
                    if (n instanceof Resource) {
                        return new EMFScope((Notifier)((Resource)n));
                    }
                    EObject eO = (EObject)n;
                    return new EMFScope((Notifier)eO.eResource());
                }
            }
        }
        return new EMFScope((Set)notifiers, new BaseIndexOptions());
    }

    private void setModelSource(EMFScope p) {
        this.modelSource = p;
        this.bindModel();
        this.showView();
    }

    private void unsetModelSource() {
        this.hideView();
        this.unbindModel();
        this.modelSource = null;
    }

    protected ViatraQueryEngine getEngine() {
        Assert.isNotNull((Object)this.modelSource);
        try {
            return ViatraQueryEngine.on((QueryScope)this.modelSource);
        }
        catch (ViatraQueryException e) {
            ViewersRuntimePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.viatra.addon.viewers.runtime", e.getLocalizedMessage(), (Throwable)e));
            return null;
        }
    }

    public void createPartControl(Composite _parent, Control _contents) {
        this.parent = _parent;
        this.layout = new StackLayout();
        this.parent.setLayout((Layout)this.layout);
        this.contents = _contents;
        this.cover = new Composite(this.parent, 16);
        this.layout.topControl = this.cover;
        this.init();
    }

    private void showView() {
        this.layout.topControl = this.contents;
        this.parent.layout();
    }

    private void hideView() {
        this.layout.topControl = this.cover;
        this.parent.layout();
    }

    protected abstract void bindModel();

    protected abstract void unbindModel();
}

