/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.util;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandInvokingDoubleClickListener
implements IDoubleClickListener {
    protected String commandId;
    protected String exceptionMessage;
    @Inject
    Logger logger;

    public CommandInvokingDoubleClickListener(String commandId, String exceptionMessage) {
        Preconditions.checkArgument((commandId != null ? 1 : 0) != 0, (Object)"CommandId cannot be null");
        Preconditions.checkArgument((exceptionMessage != null ? 1 : 0) != 0, (Object)"Exception message cannot be null");
        this.commandId = commandId;
        this.exceptionMessage = exceptionMessage;
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof TreeSelection) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(this.commandId, null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                this.handleException((CommandException)e);
            }
        }
    }

    protected void handleException(CommandException e) {
        this.logger.error((Object)this.exceptionMessage, (Throwable)e);
    }
}

