/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.NM;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class DefaultGnuToolFactory
implements IGnuToolFactory {
    protected ICExtension fExtension;

    public DefaultGnuToolFactory(ICExtension ext) {
        this.fExtension = ext;
    }

    @Override
    public Addr2line getAddr2line(IPath path) {
        IPath addr2LinePath = this.getAddr2linePath();
        String[] environment = this.getEnvironment();
        Addr2line addr2line = null;
        if (addr2LinePath != null && !addr2LinePath.isEmpty()) {
            try {
                addr2line = new Addr2line(addr2LinePath.toOSString(), new String[0], path.toOSString(), environment);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return addr2line;
    }

    @Override
    public CPPFilt getCPPFilt() {
        IPath cppFiltPath = this.getCPPFiltPath();
        String[] environment = this.getEnvironment();
        CPPFilt cppfilt = null;
        if (cppFiltPath != null && !cppFiltPath.isEmpty()) {
            try {
                cppfilt = new CPPFilt(cppFiltPath.toOSString(), new String[0], environment);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cppfilt;
    }

    @Override
    public Objdump getObjdump(IPath path) {
        IPath objdumpPath = this.getObjdumpPath();
        String objdumpArgs = this.getObjdumpArgs();
        String[] environment = this.getEnvironment();
        Objdump objdump = null;
        if (objdumpPath != null && !objdumpPath.isEmpty()) {
            try {
                objdump = new Objdump(objdumpPath.toOSString(), objdumpArgs, path.toOSString(), environment);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return objdump;
    }

    @Override
    public NM getNM(IPath path) {
        IPath nmPath = this.getNMPath();
        String nmArgs = this.getNMArgs();
        String[] environment = this.getEnvironment();
        NM nm = null;
        if (nmPath != null && !nmPath.isEmpty()) {
            try {
                nm = new NM(nmPath.toOSString(), nmArgs, path.toOSString(), environment);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return nm;
    }

    protected IPath getAddr2linePath() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        Object value = ref.getExtensionData("addr2line");
        if (value == null || ((String)value).length() == 0) {
            value = this.getToolPrefix() + "addr2line";
        }
        return new Path((String)value);
    }

    protected IPath getObjdumpPath() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        Object value = ref.getExtensionData("objdump");
        if (value == null || ((String)value).length() == 0) {
            value = this.getToolPrefix() + "objdump";
        }
        return new Path((String)value);
    }

    protected String getObjdumpArgs() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        String value = ref.getExtensionData("objdumpArgs");
        if (value == null || value.length() == 0) {
            value = "";
        }
        return value;
    }

    protected IPath getCPPFiltPath() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        Object value = ref.getExtensionData("c++filt");
        if (value == null || ((String)value).length() == 0) {
            value = this.getToolPrefix() + "c++filt";
        }
        return new Path((String)value);
    }

    protected IPath getStripPath() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        Object value = ref.getExtensionData("strip");
        if (value == null || ((String)value).length() == 0) {
            value = this.getToolPrefix() + "strip";
        }
        return new Path((String)value);
    }

    protected IPath getNMPath() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        Object value = ref.getExtensionData("nm");
        if (value == null || ((String)value).length() == 0) {
            value = this.getToolPrefix() + "nm";
        }
        return new Path((String)value);
    }

    protected String getNMArgs() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        String value = ref.getExtensionData("nmArgs");
        if (value == null || value.length() == 0) {
            value = "";
        }
        return value;
    }

    protected String[] getEnvironment() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        ICConfigurationDescription cfg = ref.getConfiguration();
        IEnvironmentVariable[] vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
        return (String[])Arrays.stream(vars).map(v -> String.format("%s=%s", v.getName(), v.getValue())).toArray(String[]::new);
    }

    protected String getToolPrefix() {
        ICConfigExtensionReference ref = this.fExtension.getConfigExtensionReference();
        ICConfigurationDescription cfg = ref.getConfiguration();
        ICdtVariable[] userVars = CCorePlugin.getUserVarSupplier().getMacros(cfg);
        ICdtVariable var = Arrays.stream(userVars).filter(v -> v.getName().equals("gnu_tool_prefix")).findFirst().orElse(null);
        if (var == null) {
            var = CCorePlugin.getDefault().getCdtVariableManager().getVariable("gnu_tool_prefix", cfg);
        }
        if (var != null) {
            try {
                return var.getStringValue();
            }
            catch (CdtVariableException e) {
                Platform.getLog(this.getClass()).log(Status.error((String)"Error getting CDT variable string value: gnu_tool_prefix", (Throwable)((Object)e)));
            }
        }
        return "";
    }
}

