/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.nio.CharBuffer;
import org.eclipse.scout.sdk.core.util.Ensure;

public final class SourceState {
    private SourceState() {
    }

    public static State parse(char[] src, int pos) {
        return SourceState.parse(CharBuffer.wrap(src), pos);
    }

    public static State parse(CharSequence src, int pos) {
        int limit = SourceState.limit(src, pos);
        return SourceState.parseImpl(src, limit).toState();
    }

    public static boolean isInString(char[] src, int pos) {
        return SourceState.isInString(CharBuffer.wrap(src), pos);
    }

    public static boolean isInString(CharSequence src, int pos) {
        int limit = SourceState.limit(src, pos);
        IState state = SourceState.parseImpl(src, limit);
        if (SourceState.isStringEnd(state, src, limit)) {
            return true;
        }
        State result = state.toState();
        return result == State.IN_STRING || result == State.ESCAPE_STRING;
    }

    public static boolean isInCode(char[] src, int pos) {
        return SourceState.isInCode(CharBuffer.wrap(src), pos);
    }

    public static boolean isInCode(CharSequence src, int pos) {
        int limit = SourceState.limit(src, pos);
        IState state = SourceState.parseImpl(src, limit);
        if (SourceState.isStringEnd(state, src, limit)) {
            return false;
        }
        if (SourceState.isCommentBoundary(state, src, limit)) {
            return false;
        }
        return state == DefaultState.INSTANCE || state == AboutToEnterCommentState.INSTANCE;
    }

    public static boolean isInComment(char[] src, int pos) {
        return SourceState.isInComment(CharBuffer.wrap(src), pos);
    }

    public static boolean isInComment(CharSequence src, int pos) {
        int limit = SourceState.limit(src, pos);
        IState state = SourceState.parseImpl(src, limit);
        if (SourceState.isCommentBoundary(state, src, limit)) {
            return true;
        }
        return state == InBlockCommentState.INSTANCE || state == InLineCommentState.INSTANCE || state == AboutToExitBlockCommentState.INSTANCE;
    }

    static boolean isCommentBoundary(IState calculatedState, CharSequence src, int limit) {
        if (calculatedState == DefaultState.INSTANCE) {
            return SourceState.previousState(DefaultState.INSTANCE, src, limit) == AboutToEnterCommentState.INSTANCE;
        }
        if (calculatedState != AboutToEnterCommentState.INSTANCE) {
            return false;
        }
        IState next = SourceState.nextState(calculatedState, src, limit);
        return next == InBlockCommentState.INSTANCE || next == InLineCommentState.INSTANCE;
    }

    static boolean isStringEnd(IState calculatedState, CharSequence src, int limit) {
        return calculatedState == DefaultState.INSTANCE && SourceState.previousState(DefaultState.INSTANCE, src, limit).toState() == State.IN_STRING;
    }

    static IState parseImpl(CharSequence chars, int end) {
        IState state = DefaultState.INSTANCE;
        for (int i = 0; i < end; ++i) {
            state = state.next(chars.charAt(i));
        }
        return state;
    }

    static int limit(CharSequence src, int pos) {
        return Math.min(Ensure.notNull(src.length()), pos + 1);
    }

    static IState previousState(IState calculatedState, CharSequence src, int limit) {
        if (limit <= 0) {
            return DefaultState.INSTANCE;
        }
        return calculatedState.next(src.charAt(limit - 1));
    }

    static IState nextState(IState calculatedState, CharSequence src, int limit) {
        if (src.length() <= limit) {
            return calculatedState;
        }
        return calculatedState.next(src.charAt(limit));
    }

    public static enum State {
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        ABOUT_TO_EXIT_BLOCK_COMMENT,
        ABOUT_TO_ENTER_COMMENT,
        ESCAPE_STRING,
        IN_STRING,
        DEFAULT;

    }

    private static interface IState {
        public IState next(char var1);

        public State toState();
    }

    private static final class DefaultState
    implements IState {
        private static final IState INSTANCE = new DefaultState();

        private DefaultState() {
        }

        @Override
        public IState next(char c) {
            return switch (c) {
                case '\"', '\'', '`' -> new InStringState(c);
                case '/' -> AboutToEnterCommentState.INSTANCE;
                default -> this;
            };
        }

        @Override
        public State toState() {
            return State.DEFAULT;
        }
    }

    private static final class AboutToEnterCommentState
    implements IState {
        private static final IState INSTANCE = new AboutToEnterCommentState();

        private AboutToEnterCommentState() {
        }

        @Override
        public IState next(char c) {
            return switch (c) {
                case '*' -> InBlockCommentState.INSTANCE;
                case '/' -> InLineCommentState.INSTANCE;
                default -> DefaultState.INSTANCE;
            };
        }

        @Override
        public State toState() {
            return State.ABOUT_TO_ENTER_COMMENT;
        }
    }

    private static final class InBlockCommentState
    implements IState {
        private static final IState INSTANCE = new InBlockCommentState();

        private InBlockCommentState() {
        }

        @Override
        public IState next(char c) {
            if (c == '*') {
                return AboutToExitBlockCommentState.INSTANCE;
            }
            return this;
        }

        @Override
        public State toState() {
            return State.IN_BLOCK_COMMENT;
        }
    }

    private static final class InLineCommentState
    implements IState {
        private static final IState INSTANCE = new InLineCommentState();

        private InLineCommentState() {
        }

        @Override
        public IState next(char c) {
            if (c == '\n') {
                return DefaultState.INSTANCE;
            }
            return this;
        }

        @Override
        public State toState() {
            return State.IN_LINE_COMMENT;
        }
    }

    private static final class AboutToExitBlockCommentState
    implements IState {
        private static final IState INSTANCE = new AboutToExitBlockCommentState();

        private AboutToExitBlockCommentState() {
        }

        @Override
        public IState next(char c) {
            return switch (c) {
                case '*' -> this;
                case '/' -> DefaultState.INSTANCE;
                default -> InBlockCommentState.INSTANCE;
            };
        }

        @Override
        public State toState() {
            return State.ABOUT_TO_EXIT_BLOCK_COMMENT;
        }
    }

    private static final class InStringState
    implements IState {
        private final char m_delimiter;

        private InStringState(char delimiter) {
            this.m_delimiter = delimiter;
        }

        @Override
        public IState next(char c) {
            if (c == this.m_delimiter) {
                return DefaultState.INSTANCE;
            }
            if (c == '\\') {
                return new EscapeStringState(this.m_delimiter);
            }
            return this;
        }

        @Override
        public State toState() {
            return State.IN_STRING;
        }
    }

    private static final class EscapeStringState
    implements IState {
        private final char m_delimiter;

        private EscapeStringState(char delimiter) {
            this.m_delimiter = delimiter;
        }

        @Override
        public IState next(char c) {
            return new InStringState(this.m_delimiter);
        }

        @Override
        public State toState() {
            return State.ESCAPE_STRING;
        }
    }
}

