/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.old.descriptor;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.TemplateDescriptor;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ArchetypeDescriptorBuilder {
    public ArchetypeDescriptor build(Reader reader) throws IOException, XmlPullParserException {
        Xpp3Dom siteResources;
        Xpp3Dom testResources;
        Xpp3Dom testSources;
        Xpp3Dom resources;
        Xpp3Dom sources;
        String allowPartial;
        ArchetypeDescriptor descriptor = new ArchetypeDescriptor();
        Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
        descriptor.setId(dom.getChild("id").getValue());
        Xpp3Dom allowPartialDom = dom.getChild("allowPartial");
        if (allowPartialDom != null && ("true".equals(allowPartial = allowPartialDom.getValue()) || "1".equals(allowPartial) || "on".equals(allowPartial))) {
            descriptor.setAllowPartial(true);
        }
        if ((sources = dom.getChild("sources")) != null) {
            Xpp3Dom[] sourceList = sources.getChildren("source");
            for (int i = 0; i < sourceList.length; ++i) {
                ArchetypeDescriptorBuilder.addSourceToDescriptor(sourceList[i], descriptor);
            }
        }
        if ((resources = dom.getChild("resources")) != null) {
            Xpp3Dom[] resourceList = resources.getChildren("resource");
            for (int i = 0; i < resourceList.length; ++i) {
                ArchetypeDescriptorBuilder.addResourceToDescriptor(resourceList[i], descriptor);
            }
        }
        if ((testSources = dom.getChild("testSources")) != null) {
            Xpp3Dom[] testSourceList = testSources.getChildren("source");
            for (int i = 0; i < testSourceList.length; ++i) {
                ArchetypeDescriptorBuilder.addTestSourceToDescriptor(testSourceList[i], descriptor);
            }
        }
        if ((testResources = dom.getChild("testResources")) != null) {
            Xpp3Dom[] testResourceList = testResources.getChildren("resource");
            for (int i = 0; i < testResourceList.length; ++i) {
                ArchetypeDescriptorBuilder.addTestResourceToDescriptor(testResourceList[i], descriptor);
            }
        }
        if ((siteResources = dom.getChild("siteResources")) != null) {
            Xpp3Dom[] siteResourceList = siteResources.getChildren("resource");
            for (int i = 0; i < siteResourceList.length; ++i) {
                ArchetypeDescriptorBuilder.addSiteResourceToDescriptor(siteResourceList[i], descriptor);
            }
        }
        return descriptor;
    }

    private static void addSourceToDescriptor(Xpp3Dom source, ArchetypeDescriptor descriptor) throws XmlPullParserException {
        descriptor.addSource(source.getValue());
        TemplateDescriptor sourceDesc = descriptor.getSourceDescriptor(source.getValue());
        sourceDesc.setFiltered(true);
        if (source.getAttribute("encoding") != null) {
            try {
                sourceDesc.setEncoding(source.getAttribute("encoding"));
            }
            catch (IllegalCharsetNameException icne) {
                throw new XmlPullParserException(source.getAttribute("encoding") + " is not a valid encoding.");
            }
            catch (UnsupportedCharsetException uce) {
                throw new XmlPullParserException(source.getAttribute("encoding") + " is not a supported encoding.");
            }
        }
    }

    private static void addResourceToDescriptor(Xpp3Dom resource, ArchetypeDescriptor descriptor) throws XmlPullParserException {
        TemplateDescriptor resourceDesc;
        descriptor.addResource(resource.getValue());
        if (resource.getAttribute("filtered") != null) {
            resourceDesc = descriptor.getResourceDescriptor(resource.getValue());
            try {
                resourceDesc.setFiltered(ArchetypeDescriptorBuilder.getValueFilteredAttribute(resource.getAttribute("filtered")));
            }
            catch (IllegalArgumentException iae) {
                throw new XmlPullParserException(iae.getMessage());
            }
        }
        if (resource.getAttribute("encoding") != null) {
            resourceDesc = descriptor.getResourceDescriptor(resource.getValue());
            try {
                resourceDesc.setEncoding(resource.getAttribute("encoding"));
            }
            catch (IllegalCharsetNameException icne) {
                throw new XmlPullParserException(resource.getAttribute("encoding") + " is not a valid encoding.");
            }
            catch (UnsupportedCharsetException uce) {
                throw new XmlPullParserException(resource.getAttribute("encoding") + " is not a supported encoding.");
            }
        }
        if (resource.getValue().endsWith(".properties")) {
            resourceDesc = descriptor.getResourceDescriptor(resource.getValue());
            resourceDesc.setEncoding("iso-8859-1");
        }
    }

    private static void addTestSourceToDescriptor(Xpp3Dom testSource, ArchetypeDescriptor descriptor) throws XmlPullParserException {
        descriptor.addTestSource(testSource.getValue());
        TemplateDescriptor testSourceDesc = descriptor.getTestSourceDescriptor(testSource.getValue());
        testSourceDesc.setFiltered(true);
        if (testSource.getAttribute("encoding") != null) {
            try {
                testSourceDesc.setEncoding(testSource.getAttribute("encoding"));
            }
            catch (IllegalCharsetNameException icne) {
                throw new XmlPullParserException(testSource.getAttribute("encoding") + " is not a valid encoding.");
            }
            catch (UnsupportedCharsetException uce) {
                throw new XmlPullParserException(testSource.getAttribute("encoding") + " is not a supported encoding.");
            }
        }
    }

    private static void addTestResourceToDescriptor(Xpp3Dom testResource, ArchetypeDescriptor descriptor) throws XmlPullParserException {
        TemplateDescriptor testResourceDesc;
        descriptor.addTestResource(testResource.getValue());
        if (testResource.getAttribute("filtered") != null) {
            testResourceDesc = descriptor.getTestResourceDescriptor(testResource.getValue());
            try {
                testResourceDesc.setFiltered(ArchetypeDescriptorBuilder.getValueFilteredAttribute(testResource.getAttribute("filtered")));
            }
            catch (IllegalArgumentException iae) {
                throw new XmlPullParserException(iae.getMessage());
            }
        }
        if (testResource.getAttribute("encoding") != null) {
            testResourceDesc = descriptor.getTestResourceDescriptor(testResource.getValue());
            try {
                testResourceDesc.setEncoding(testResource.getAttribute("encoding"));
            }
            catch (IllegalCharsetNameException icne) {
                throw new XmlPullParserException(testResource.getAttribute("encoding") + " is not a valid encoding.");
            }
            catch (UnsupportedCharsetException uce) {
                throw new XmlPullParserException(testResource.getAttribute("encoding") + " is not a supported encoding.");
            }
        }
        if (testResource.getValue().endsWith(".properties")) {
            testResourceDesc = descriptor.getTestResourceDescriptor(testResource.getValue());
            testResourceDesc.setEncoding("iso-8859-1");
        }
    }

    private static void addSiteResourceToDescriptor(Xpp3Dom siteResource, ArchetypeDescriptor descriptor) throws XmlPullParserException {
        TemplateDescriptor siteResourceDesc;
        descriptor.addSiteResource(siteResource.getValue());
        if (siteResource.getAttribute("filtered") != null) {
            siteResourceDesc = descriptor.getSiteResourceDescriptor(siteResource.getValue());
            try {
                siteResourceDesc.setFiltered(ArchetypeDescriptorBuilder.getValueFilteredAttribute(siteResource.getAttribute("filtered")));
            }
            catch (IllegalArgumentException iae) {
                throw new XmlPullParserException(iae.getMessage());
            }
        }
        if (siteResource.getAttribute("encoding") != null) {
            siteResourceDesc = descriptor.getSiteResourceDescriptor(siteResource.getValue());
            try {
                siteResourceDesc.setEncoding(siteResource.getAttribute("encoding"));
            }
            catch (IllegalCharsetNameException icne) {
                throw new XmlPullParserException(siteResource.getAttribute("encoding") + " is not a valid encoding.");
            }
            catch (UnsupportedCharsetException uce) {
                throw new XmlPullParserException(siteResource.getAttribute("encoding") + " is not a supported encoding.");
            }
        }
        if (siteResource.getValue().endsWith(".properties")) {
            siteResourceDesc = descriptor.getSiteResourceDescriptor(siteResource.getValue());
            siteResourceDesc.setEncoding("iso-8859-1");
        }
    }

    private static boolean getValueFilteredAttribute(String str) throws IllegalArgumentException {
        boolean ret = false;
        if (str.equals("true")) {
            ret = true;
        } else if (str.equals("false")) {
            ret = false;
        } else {
            throw new IllegalArgumentException(str + " is not an accepted value for the attribute 'filtered'");
        }
        return ret;
    }
}

