/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSInlineFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSTextFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigureLayout;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.layout.TextFragmentBox;
import org.eclipse.jst.pagedesigner.css2.layout.TextLayoutSupport;
import org.eclipse.jst.pagedesigner.css2.style.AbstractStyle;
import org.eclipse.swt.graphics.Font;
import org.w3c.dom.Element;

public class CSSTextLayout
extends FlowFigureLayout {
    public static final int WORD_WRAP_HARD = 0;
    public static final int WORD_WRAP_SOFT = 1;
    private int _wrappingStyle = 0;

    public CSSTextLayout(CSSTextFigure textfigure) {
        super(textfigure);
    }

    FlowBox findLastNonLineBox(LineBox box) {
        List fragments = box.getFragments();
        int i = fragments.size() - 1;
        while (i >= 0) {
            FlowBox item = (FlowBox)fragments.get(i);
            if (item instanceof LineBox) {
                FlowBox found = this.findLastNonLineBox((LineBox)item);
                if (found != null) {
                    return found;
                }
            } else {
                return item;
            }
            --i;
        }
        return null;
    }

    private void layoutEmptyString(List fragments, Font font) {
        fragments.clear();
        TextFragmentBox box = TextLayoutSupport.getFragment(0, fragments);
        box._length = 0;
        box._offset = 0;
        box._height = 0;
        box._width = 0;
        box.setTextData("");
        this.getFlowContext().getCurrentLine().add(box);
    }

    @Override
    protected void layout() {
        CSSTextFigure flowFigure = (CSSTextFigure)this.getFlowFigure();
        List fragments = flowFigure.getFragments();
        String text = flowFigure.getText();
        Font font = flowFigure.getCSSStyle().getCSSFont().getSwtFont();
        Object whitespace = flowFigure.getCSSStyle().getStyleProperty("white-space");
        if (whitespace == "pre") {
            if (text == null || text.length() == 0) {
                this.layoutEmptyString(fragments, font);
            } else {
                TextLayoutSupport.layoutNoWrap(this.getFlowContext(), text, fragments, font);
            }
        } else if (whitespace == "nowrap") {
            if (text == null || text.length() == 0) {
                this.layoutEmptyString(fragments, font);
            } else {
                TextLayoutSupport.layoutNoWrap(this.getFlowContext(), text, fragments, font);
            }
        } else if (text == null || text.length() == 0) {
            this.layoutEmptyString(fragments, font);
        } else {
            Element element;
            ICSSStyle style;
            boolean useShouldTrimLeadingWSInlineMethod = false;
            IFigure parentFigure = flowFigure.getParent();
            if (parentFigure instanceof CSSFigure && (style = ((CSSFigure)parentFigure).getCSSStyle()) instanceof AbstractStyle && (element = ((AbstractStyle)style).getElement()) != null && element.getNodeName().equals("span")) {
                useShouldTrimLeadingWSInlineMethod = true;
            }
            boolean trimLeadingChar = !useShouldTrimLeadingWSInlineMethod ? text.charAt(0) == ' ' && this.shouldTrimLeadingWhitespace(this.getFlowContext()) : text.charAt(0) == ' ' && this.shouldTrimLeadingWhitespaceInline(this.getFlowContext());
            TextLayoutSupport.layoutNormal(this.getFlowContext(), text, fragments, font, this._wrappingStyle, trimLeadingChar);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean shouldTrimLeadingWhitespace(FlowContext context) {
        if (context.isCurrentLineOccupied()) ** GOTO lbl4
        return true;
lbl-1000:
        // 1 sources

        {
            context = ((CSSInlineFlowLayout)context).getFlowContext();
lbl4:
            // 2 sources

            ** while (context instanceof CSSInlineFlowLayout)
        }
lbl5:
        // 1 sources

        line = context.getCurrentLine();
        if (line == null || !line.isOccupied()) {
            return true;
        }
        lastNoneLinebox = this.findLastNonLineBox(line);
        if (lastNoneLinebox == null || lastNoneLinebox.getWidth() == 0) {
            return true;
        }
        if (lastNoneLinebox instanceof TextFragmentBox) {
            return ((TextFragmentBox)lastNoneLinebox)._isLastCharWhitespace;
        }
        return false;
    }

    private boolean shouldTrimLeadingWhitespaceInline(FlowContext context) {
        if (!context.isCurrentLineOccupied()) {
            return true;
        }
        LineBox line = context.getCurrentLine();
        if (line == null || !line.isOccupied()) {
            return true;
        }
        FlowBox lastNoneLinebox = this.findLastNonLineBox(line);
        if (lastNoneLinebox == null || lastNoneLinebox.getWidth() == 0) {
            return true;
        }
        if (lastNoneLinebox instanceof TextFragmentBox) {
            return ((TextFragmentBox)lastNoneLinebox)._isLastCharWhitespace;
        }
        return false;
    }

    @Override
    public void dispose() {
    }
}

