/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.deployables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURL;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURLExtensionReader;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.IWebCommon;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.internal.impl.ServletImpl;
import org.eclipse.jst.jee.internal.deployables.JEEFlexProjDeployable;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.server.core.EJBBean;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.NullModuleArtifact;
import org.eclipse.wst.server.core.util.WebResource;

public class WebDeployableArtifactUtil {
    private static final String GENERIC_SERVLET_CLASS_TYPE = "javax.servlet.GenericServlet";
    private static final String GENERIC_JAKARTA_SERVLET_CLASS_TYPE = "jakarta.servlet.GenericServlet";
    private static final String CACTUS_SERVLET_CLASS_TYPE = "org.apache.cactus.server.ServletTestRedirector";

    public static IModuleArtifact getModuleObject(Object obj) {
        IProject project;
        IVirtualComponent component;
        IVirtualResource[] resources;
        String mapping;
        IResource resource = null;
        if (obj instanceof IResource) {
            resource = (IResource)obj;
        }
        if (obj instanceof IModuleArtifact) {
            resource = ((IModuleArtifact)obj).getModule().getProject();
        } else if (obj instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
        } else if (obj instanceof EObject) {
            resource = ProjectUtilities.getProject((EObject)((EObject)obj));
            if (obj instanceof Servlet) {
                ServletImpl servlet = (ServletImpl)obj;
                Resource servResource = servlet.eResource();
                IVirtualResource[] resources2 = null;
                try {
                    IFile eclipeServResoruce = WorkbenchResourceHelper.getFile((Resource)servResource);
                    resources2 = ComponentCore.createResources((IResource)eclipeServResoruce);
                }
                catch (Exception e) {
                    JEEUIPlugin.logError(e);
                }
                IVirtualComponent component2 = null;
                if (resources2 != null && resources2[0] != null) {
                    component2 = resources2[0].getComponent();
                }
                mapping = null;
                if (servlet.getServletClass() != null) {
                    List<ServletMapping> mappings = WebDeployableArtifactUtil.getServletMappings(resource, servlet.getServletName());
                    if (mappings != null && !mappings.isEmpty()) {
                        ServletMapping map = mappings.get(0);
                        UrlPatternType urlPattern = (UrlPatternType)map.getUrlPatterns().get(0);
                        mapping = urlPattern.getValue();
                    }
                    if (mapping != null) {
                        return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component2), (IPath)new Path(mapping));
                    }
                    return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component2), (IPath)new Path("servlet/" + servlet.getServletClass()));
                }
                if (servlet.getJspFile() != null && component2 != null) {
                    Path jspFilePath = new Path(servlet.getJspFile());
                    resource = component2.getRootFolder().getUnderlyingFolder().getFile((IPath)jspFilePath);
                }
            } else if ((obj instanceof SessionBean || obj instanceof MessageDrivenBean) && JavaEEProjectUtilities.isDynamicWebProject((IProject)((IProject)resource))) {
                IModule module;
                Resource servResource = ((BasicEObjectImpl)obj).eResource();
                resources = null;
                try {
                    IFile eclipeServResoruce = WorkbenchResourceHelper.getFile((Resource)servResource);
                    resources = ComponentCore.createResources((IResource)eclipeServResoruce);
                }
                catch (Exception e) {
                    JEEUIPlugin.logError(e);
                }
                component = null;
                if (resources != null && resources[0] != null) {
                    component = resources[0].getComponent();
                }
                if ((module = WebDeployableArtifactUtil.getModule(resource.getProject(), component)) != null) {
                    String jndiName = null;
                    String ejbName = null;
                    if (obj instanceof SessionBean) {
                        ejbName = ((SessionBean)obj).getEjbName();
                    } else if (obj instanceof MessageDrivenBean) {
                        ejbName = ((MessageDrivenBean)obj).getEjbName();
                    }
                    if (ejbName != null) {
                        module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
                        JEEFlexProjDeployable moduleDelegate = (JEEFlexProjDeployable)module.getAdapter(ModuleDelegate.class);
                        jndiName = moduleDelegate.getJNDIName(ejbName);
                        return new EJBBean(module, jndiName, false, false, "3.0");
                    }
                    return new NullModuleArtifact(module);
                }
            }
        }
        if (resource == null) {
            return null;
        }
        if (resource instanceof IProject && WebDeployableArtifactUtil.hasInterestedComponents(project = (IProject)resource)) {
            return new WebResource(WebDeployableArtifactUtil.getModule(project, null), project.getProjectRelativePath());
        }
        if (!WebDeployableArtifactUtil.hasInterestedComponents(resource.getProject())) {
            return null;
        }
        if (WebDeployableArtifactUtil.isCactusJunitTest(resource)) {
            return null;
        }
        IPath resourcePath = resource.getFullPath();
        resources = ComponentCore.createResources((IResource)resource);
        component = null;
        if (resources.length <= 0 || resources[0] == null) {
            return null;
        }
        component = resources[0].getComponent();
        String className = WebDeployableArtifactUtil.getServletClassName(resource);
        if (className != null && component != null) {
            mapping = WebDeployableArtifactUtil.getServletMapping(resource, true, className, component.getName());
            if (mapping != null) {
                return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), (IPath)new Path(mapping));
            }
            return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), (IPath)new Path("servlet/" + className));
        }
        if (className == null && component != null) {
            IPath rootPath = component.getRootFolder().getProjectRelativePath();
            IPath jspPath = resource.getProjectRelativePath().removeFirstSegments(rootPath.segmentCount());
            String mapping2 = WebDeployableArtifactUtil.getJSPServletMapping(resource, jspPath.makeAbsolute().toString());
            if (mapping2 != null) {
                return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), (IPath)new Path(mapping2));
            }
        }
        resourcePath = resources[0].getRuntimePath();
        try {
            IPath correctJSPPath;
            FileURL jspURL = FileURLExtensionReader.getInstance().getFilesURL();
            if (jspURL != null && (correctJSPPath = jspURL.getFileURL(resource, resourcePath)) != null && correctJSPPath.toString().length() > 0) {
                return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), correctJSPPath);
            }
        }
        catch (Exception e) {
            JEEUIPlugin.logError(e);
        }
        return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), resourcePath);
    }

    protected static IModule getModule(IProject project, IVirtualComponent component) {
        IModule module;
        IModule[] modules;
        String componentName = null;
        if (component != null) {
            componentName = component.getName();
        }
        ModuleType[] moduleTypeArray = new ModuleType[]{ModuleType.getModuleType((String)"jst.web", null), ModuleType.getModuleType((String)"jst.webfragment", null)};
        IModule[] iModuleArray = modules = ServerUtil.getModules((IModuleType[])moduleTypeArray);
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            module = iModuleArray[n2];
            if ((project == null || project.equals((Object)module.getProject())) && (componentName == null || componentName.equals(module.getName()))) {
                return module;
            }
            ++n2;
        }
        if (project != null) {
            iModuleArray = modules = ServerUtil.getModules((IProject)project);
            n = modules.length;
            n2 = 0;
            while (n2 < n) {
                module = iModuleArray[n2];
                if (componentName == null || componentName.equals(module.getName())) {
                    return module;
                }
                ++n2;
            }
        }
        return null;
    }

    protected static IModule getModuleProject(IProject project, Iterator iterator) {
        IModule deployable = null;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = (IModule)next).getProject().equals((Object)project)) continue;
            return deployable;
        }
        return null;
    }

    private static boolean isCactusJunitTest(IResource resource) {
        return WebDeployableArtifactUtil.getClassNameForType(resource, CACTUS_SERVLET_CLASS_TYPE) != null;
    }

    private static IType[] getTypes(IJavaElement element) {
        block3: {
            try {
                if (element.getElementType() == 5) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return ((ICompilationUnit)element).getAllTypes();
    }

    public static String getServletClassName(IResource resource) {
        String className = WebDeployableArtifactUtil.getClassNameForType(resource, GENERIC_JAKARTA_SERVLET_CLASS_TYPE);
        if (className != null) {
            return className;
        }
        return WebDeployableArtifactUtil.getClassNameForType(resource, GENERIC_SERVLET_CLASS_TYPE);
    }

    public static String getClassNameForType(IResource resource, String superType) {
        IPath path;
        IProject project;
        block13: {
            if (resource == null) {
                return null;
            }
            project = resource.getProject();
            path = resource.getFullPath();
            if (project.hasNature("org.eclipse.jdt.core.javanature") && path != null) break block13;
            return null;
        }
        try {
            IType[] types;
            IJavaElement javaElement;
            IClasspathEntry[] classPathEntry;
            IPath outputPath;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (!javaProject.isOpen()) {
                javaProject.open((IProgressMonitor)new NullProgressMonitor());
            }
            if ((outputPath = javaProject.getOutputLocation()) != null && "class".equals(path.getFileExtension()) && outputPath.isPrefixOf(path)) {
                int count = outputPath.segmentCount();
                path = path.removeFirstSegments(count);
            }
            if ((classPathEntry = javaProject.getResolvedClasspath(true)) != null) {
                int size = classPathEntry.length;
                int i = 0;
                while (i < size) {
                    IPath classPath = classPathEntry[i].getPath();
                    if (classPath.isPrefixOf(path)) {
                        int count = classPath.segmentCount();
                        path = path.removeFirstSegments(count);
                        i += size;
                    }
                    ++i;
                }
            }
            if ((javaElement = javaProject.findElement(path)) != null && (types = WebDeployableArtifactUtil.getTypes(javaElement)) != null) {
                int size2 = types.length;
                int i = 0;
                while (i < size2) {
                    if (WebDeployableArtifactUtil.hasSuperclass(types[i], superType)) {
                        return types[i].getFullyQualifiedName();
                    }
                    ++i;
                }
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (Exception e) {
            JEEUIPlugin.logError(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSuperclass(IType type, String superClassName) {
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] superClasses = hierarchy.getAllSuperclasses(type);
            int size = superClasses.length;
            int i = 0;
            while (true) {
                if (i >= size) {
                    return false;
                }
                if (superClassName.equals(superClasses[i].getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getServletMapping(IResource resource, boolean isServlet, String typeName, String componentName) {
        IWebCommon webApp;
        List servlets;
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)resource.getProject());
        Object mObj = provider.getModelObject();
        if (mObj instanceof IWebCommon && (servlets = (webApp = (IWebCommon)mObj).getServlets()) != null && !servlets.isEmpty()) {
            int i = 0;
            while (i < servlets.size()) {
                List mappings;
                Servlet servlet = (Servlet)servlets.get(i);
                if (servlet.getServletClass() != null && servlet.getServletClass().equals(typeName) && (mappings = webApp.getServletMappings()) != null && !mappings.isEmpty()) {
                    for (ServletMapping map : mappings) {
                        if (!map.getServletName().equals(servlet.getServletName())) continue;
                        UrlPatternType urlPattern = (UrlPatternType)map.getUrlPatterns().get(0);
                        return urlPattern.getValue();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected static boolean hasInterestedComponents(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || JavaEEProjectUtilities.isWebFragmentProject((IProject)project);
    }

    private static String getJSPServletMapping(IResource resource, String jspPath) {
        WebApp webApp;
        List servlets;
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)resource.getProject());
        Object mObj = provider.getModelObject();
        if (mObj instanceof WebApp && (servlets = (webApp = (WebApp)mObj).getServlets()) != null && !servlets.isEmpty()) {
            int i = 0;
            while (i < servlets.size()) {
                List mappings;
                Servlet servlet = (Servlet)servlets.get(i);
                if (servlet.getJspFile() != null && servlet.getJspFile().equals(jspPath) && (mappings = webApp.getServletMappings()) != null && !mappings.isEmpty()) {
                    for (ServletMapping map : mappings) {
                        if (!map.getServletName().equals(servlet.getServletName())) continue;
                        UrlPatternType urlPattern = (UrlPatternType)map.getUrlPatterns().get(0);
                        return urlPattern.getValue();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static List<ServletMapping> getServletMappings(IResource resource, String servletName) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)resource.getProject());
        IWebCommon webApp = (IWebCommon)provider.getModelObject();
        List servlets = webApp.getServlets();
        ArrayList<ServletMapping> list = new ArrayList<ServletMapping>();
        if (servlets != null && !servlets.isEmpty()) {
            int i = 0;
            while (i < servlets.size()) {
                List mappings;
                Servlet servlet = (Servlet)servlets.get(i);
                if (servlet.getServletName() != null && servlet.getServletName().equals(servletName) && (mappings = webApp.getServletMappings()) != null && !mappings.isEmpty()) {
                    for (ServletMapping map : mappings) {
                        if (!map.getServletName().equals(servlet.getServletName())) continue;
                        list.add(map);
                    }
                }
                ++i;
            }
        }
        return list;
    }
}

