/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xcore.ui.AbstractSelectionView;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class EOperationInvocationView
extends AbstractSelectionView {
    private static final String NO_OPERATIONS = "<No EOperations available>";
    private EOperationInvocation currentInvocation;
    private EPackage operationArgumentsPackage;
    private Map<EOperation, EObject> operationArgumentsInstances = new HashMap<EOperation, EObject>();
    private EObject operationOwnerContainer;
    private EReference operationOwnerContainerContentRef;
    private EReference operationOwnerContainerContextRef;
    private Shell parentShell;
    private Combo operationsCombo;
    private PropertySheetPage propertySheetPage;

    @Override
    public void dispose() {
        this.propertySheetPage.dispose();
        this.propertySheetPage.dispose();
        super.dispose();
    }

    @Override
    protected boolean isValidSelection(Object o) {
        return o instanceof EObject;
    }

    private EObject getSelectedEObject() {
        return (EObject)this.selection;
    }

    private String toString(EOperation operation) {
        String item = String.valueOf(operation.getName()) + "(";
        for (EParameter param : operation.getEParameters()) {
            if (param != operation.getEParameters().get(0)) {
                item = String.valueOf(item) + ",";
            }
            EClassifier type = param.getEType();
            item = String.valueOf(item) + type.getName() + (param.isMany() ? "* " : " ") + param.getName();
        }
        item = String.valueOf(item) + ")";
        return item;
    }

    @Override
    protected void updateView() {
        EObject selection = this.getSelectedEObject();
        EClass eClass = null;
        if (selection == null) {
            this.currentInvocation = null;
        } else {
            eClass = selection.eClass();
            this.currentInvocation = new EOperationInvocation(selection);
        }
        if (eClass != this.operationsCombo.getData()) {
            EList operations = eClass != null ? eClass.getEAllOperations() : new BasicEList();
            String[] items = new String[operations.size()];
            int i = 0;
            while (i < items.length) {
                items[i] = this.toString((EOperation)operations.get(i));
                ++i;
            }
            this.operationsCombo.setItems(items);
            if (items.length > 0) {
                this.operationsCombo.select(0);
            } else {
                this.operationsCombo.setText(NO_OPERATIONS);
            }
            this.operationsCombo.setData((Object)eClass);
        }
        this.operationSelected(this.operationsCombo.getSelectionIndex());
    }

    private void operationSelected(int selectionIndex) {
        EList operations;
        EClass eClass = (EClass)this.operationsCombo.getData();
        EOperation operation = null;
        if (eClass != null && selectionIndex >= 0 && selectionIndex < (operations = eClass.getEAllOperations()).size()) {
            operation = (EOperation)operations.get(selectionIndex);
        }
        EObject operationArgumentsInstance = null;
        if (this.currentInvocation != null) {
            if (operation != null && (operationArgumentsInstance = this.operationArgumentsInstances.get(operation)) == null) {
                operationArgumentsInstance = this.createEOperationEObject(this.createEOperationEClass(operation));
                this.operationArgumentsInstances.put(operation, operationArgumentsInstance);
                this.initEOperationOwnerContainer(operationArgumentsInstance, this.currentInvocation.getOperationOwner());
            }
            this.currentInvocation.setOperation(operation, operationArgumentsInstance);
        }
        this.updatePropertySheet(operationArgumentsInstance);
    }

    private EPackage getEOperationEPackage() {
        if (this.operationArgumentsPackage == null) {
            this.operationArgumentsPackage = EcoreFactory.eINSTANCE.createEPackage();
            this.operationArgumentsPackage.setEFactoryInstance(EcoreFactory.eINSTANCE.createEFactory());
        }
        return this.operationArgumentsPackage;
    }

    private EClass createEOperationEClass(EOperation operation) {
        EClass eClass = this.createEOperationEClass();
        for (EParameter param : operation.getEParameters()) {
            EClassifier type = param.getEType();
            EReference property = type instanceof EClass ? EcoreFactory.eINSTANCE.createEReference() : EcoreFactory.eINSTANCE.createEAttribute();
            property.setName(param.getName());
            property.setEType(type);
            property.setLowerBound(param.getLowerBound());
            property.setUpperBound(param.getUpperBound());
            eClass.getEStructuralFeatures().add((Object)property);
        }
        return eClass;
    }

    private EReference createEObjectEReference(EClass owner, String name) {
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName(name);
        ref.setEType((EClassifier)EcorePackage.eINSTANCE.getEObject());
        owner.getEStructuralFeatures().add((Object)ref);
        return ref;
    }

    private EClass createEOperationEClass() {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.getEOperationEPackage().getEClassifiers().add((Object)eClass);
        return eClass;
    }

    private EObject createEOperationEObject(EClass eClass) {
        EObject eObject = this.getEOperationEPackage().getEFactoryInstance().create(eClass);
        return eObject;
    }

    private EObject getEOperationOwnerContainer() {
        if (this.operationOwnerContainer == null) {
            EClass operationOwnerContainerContainerClass = this.createEOperationEClass();
            if (this.operationOwnerContainerContentRef == null) {
                this.operationOwnerContainerContentRef = this.createEObjectEReference(operationOwnerContainerContainerClass, "contentRef");
                this.operationOwnerContainerContentRef.setContainment(true);
            }
            if (this.operationOwnerContainerContextRef == null) {
                this.operationOwnerContainerContextRef = this.createEObjectEReference(operationOwnerContainerContainerClass, "contextRef");
            }
            this.operationOwnerContainer = this.createEOperationEObject(operationOwnerContainerContainerClass);
        }
        return this.operationOwnerContainer;
    }

    private void initEOperationOwnerContainer(EObject operationArgumentsInstance, EObject operationOwner) {
        EObject container = this.getEOperationOwnerContainer();
        container.eSet((EStructuralFeature)this.operationOwnerContainerContentRef, (Object)operationArgumentsInstance);
        container.eSet((EStructuralFeature)this.operationOwnerContainerContextRef, (Object)this.getSelectedEObject());
    }

    private void updatePropertySheet(EObject eObject) {
        if (this.editingDomainProvider != null) {
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)this.editingDomainProvider.getEditingDomain();
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(editingDomain.getAdapterFactory()));
        }
        StructuredSelection selection = eObject != null && this.editingDomainProvider != null ? new StructuredSelection((Object)eObject) : StructuredSelection.EMPTY;
        this.propertySheetPage.selectionChanged(null, (ISelection)selection);
    }

    @Override
    public void createPartControl(Composite parent) {
        this.parentShell = parent.getShell();
        super.createPartControl(parent);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.operationsCombo = new Combo(parent, 12);
        this.operationsCombo.setText(NO_OPERATIONS);
        this.operationsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EOperationInvocationView.this.operationSelected(EOperationInvocationView.this.operationsCombo.getSelectionIndex());
            }
        });
        this.operationsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button invokeButton = new Button(parent, 8);
        invokeButton.setText("Invoke!");
        invokeButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EOperationInvocation invocation = EOperationInvocationView.this.currentInvocation;
                EOperationInvocationView.this.currentInvocation = null;
                if (invocation != null) {
                    invocation.execute(EOperationInvocationView.this.editingDomainProvider, EOperationInvocationView.this.parentShell);
                }
                EOperationInvocationView.this.updateView();
            }
        });
        Composite propertySheetParent = new Composite(parent, 0);
        propertySheetParent.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        propertySheetParent.setLayout((Layout)new FillLayout());
        this.propertySheetPage = new PropertySheetPage();
        this.propertySheetPage.createControl(propertySheetParent);
    }

    public void setFocus() {
        this.operationsCombo.setFocus();
    }

    private static class EOperationInvocation
    extends ChangeCommand {
        private EOperation operation;
        private EObject argumentsInstance;
        private Collection<?> affectedObjects;
        private Object result;
        private EList<Object> argumentList = new BasicEList();

        public EOperationInvocation(EObject operationOwner) {
            super((Notifier)operationOwner);
        }

        public void dispose() {
            super.dispose();
            this.operation = null;
            this.argumentsInstance = null;
            this.affectedObjects = null;
            this.result = null;
        }

        public EObject getOperationOwner() {
            return (EObject)this.notifier;
        }

        public void setOperation(EOperation operation, EObject argumentsInstance) {
            this.operation = operation;
            this.argumentsInstance = argumentsInstance;
        }

        protected boolean prepare() {
            if (!super.prepare() || this.getOperationOwner() == null || this.operation == null) {
                return false;
            }
            for (EStructuralFeature property : this.argumentsInstance.eClass().getEStructuralFeatures()) {
                Object value = this.argumentsInstance.eGet(property);
                this.argumentList.add(value);
            }
            return true;
        }

        protected void doExecute() {
            try {
                this.result = this.getOperationOwner().eInvoke(this.operation, this.argumentList);
                this.affectedObjects = this.operation.isMany() ? (Set<Object>)this.result : Collections.singleton(this.result);
            }
            catch (Exception e) {
                this.result = Collections.singletonList(e);
                this.affectedObjects = Collections.singletonList(e);
            }
        }

        public void undo() {
            this.affectedObjects = this.notifier != null ? Collections.singleton(this.notifier) : this.notifiers;
            this.result = Collections.emptyList();
            super.undo();
        }

        private void execute(IEditingDomainProvider editingDomainProvider, Shell shell) {
            if (!this.canExecute()) {
                return;
            }
            if (editingDomainProvider != null) {
                editingDomainProvider.getEditingDomain().getCommandStack().execute((Command)this);
            } else {
                this.execute();
            }
            if (this.affectedObjects != null && shell != null) {
                MessageDialog dialog = new MessageDialog(shell, "Invocation result", null, String.valueOf(this.affectedObjects), this.affectedObjects instanceof Exception ? 1 : 2, new String[]{"Close"}, 0);
                dialog.open();
            }
        }

        public Collection<?> getResult() {
            return this.result == null ? Collections.emptyList() : Collections.singleton(this.result);
        }

        public Collection<?> getAffectedObjects() {
            return this.affectedObjects;
        }
    }
}

