/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.astview.ASTViewPlugin;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.Binding;
import org.eclipse.jdt.astview.views.CommentsProperty;
import org.eclipse.jdt.astview.views.Error;
import org.eclipse.jdt.astview.views.GeneralAttribute;
import org.eclipse.jdt.astview.views.JavaElement;
import org.eclipse.jdt.astview.views.NodeProperty;
import org.eclipse.jdt.astview.views.ProblemsProperty;
import org.eclipse.jdt.astview.views.SettingsProperty;
import org.eclipse.jdt.astview.views.WellKnownTypesProperty;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ASTViewContentProvider
implements ITreeContentProvider {
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof ASTNode) {
            ASTNode node = (ASTNode)child;
            ASTNode parent = node.getParent();
            if (parent != null) {
                StructuralPropertyDescriptor prop = node.getLocationInParent();
                return new NodeProperty(parent, prop);
            }
        } else if (child instanceof ASTAttribute) {
            return ((ASTAttribute)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ASTAttribute) {
            return ((ASTAttribute)parent).getChildren();
        }
        if (parent instanceof ASTNode) {
            return this.getNodeChildren((ASTNode)parent);
        }
        return new Object[0];
    }

    private Object[] getNodeChildren(ASTNode node) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (node instanceof Expression) {
            Expression expression = (Expression)node;
            ITypeBinding expressionTypeBinding = expression.resolveTypeBinding();
            res.add(this.createExpressionTypeBinding(node, expressionTypeBinding));
            if (expression instanceof Name) {
                binding = ((Name)expression).resolveBinding();
                if (binding != expressionTypeBinding) {
                    res.add(this.createBinding((ASTNode)expression, binding));
                }
            } else if (expression instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)expression;
                binding = methodInvocation.resolveMethodBinding();
                res.add(this.createBinding((ASTNode)expression, (IBinding)binding));
                inferred = String.valueOf(methodInvocation.isResolvedTypeInferredFromExpectedType());
                res.add(new GeneralAttribute((Object)expression, "ResolvedTypeInferredFromExpectedType", inferred));
            } else if (expression instanceof SuperMethodInvocation) {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression;
                binding = superMethodInvocation.resolveMethodBinding();
                res.add(this.createBinding((ASTNode)expression, (IBinding)binding));
                inferred = String.valueOf(superMethodInvocation.isResolvedTypeInferredFromExpectedType());
                res.add(new GeneralAttribute((Object)expression, "ResolvedTypeInferredFromExpectedType", inferred));
            } else if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                binding = classInstanceCreation.resolveConstructorBinding();
                res.add(this.createBinding((ASTNode)expression, (IBinding)binding));
                inferred = String.valueOf(classInstanceCreation.isResolvedTypeInferredFromExpectedType());
                res.add(new GeneralAttribute((Object)expression, "ResolvedTypeInferredFromExpectedType", inferred));
            } else if (expression instanceof FieldAccess) {
                binding = ((FieldAccess)expression).resolveFieldBinding();
                res.add(this.createBinding((ASTNode)expression, binding));
            } else if (expression instanceof SuperFieldAccess) {
                binding = ((SuperFieldAccess)expression).resolveFieldBinding();
                res.add(this.createBinding((ASTNode)expression, binding));
            } else if (expression instanceof Annotation) {
                binding = ((Annotation)expression).resolveAnnotationBinding();
                res.add(this.createBinding((ASTNode)expression, binding));
            } else if (expression instanceof LambdaExpression) {
                ASTAttribute bindingAttribute;
                try {
                    binding = ((LambdaExpression)expression).resolveMethodBinding();
                    bindingAttribute = this.createBinding((ASTNode)expression, (IBinding)binding);
                }
                catch (RuntimeException e) {
                    bindingAttribute = new Error(res, ">binding: Error: " + e.getMessage(), e);
                    ASTViewPlugin.log("Exception thrown in LambdaExpression#resolveMethodBinding() for \"" + String.valueOf(expression) + "\"", e);
                }
                res.add(bindingAttribute);
            } else if (expression instanceof MethodReference) {
                binding = ((MethodReference)expression).resolveMethodBinding();
                res.add(this.createBinding((ASTNode)expression, binding));
            }
            res.add(new GeneralAttribute(expression, "Boxing: " + expression.resolveBoxing() + "; Unboxing: " + expression.resolveUnboxing()));
            res.add(new GeneralAttribute((Object)expression, "ConstantExpressionValue", expression.resolveConstantExpressionValue()));
        } else if (node instanceof ConstructorInvocation) {
            binding = ((ConstructorInvocation)node).resolveConstructorBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof SuperConstructorInvocation) {
            binding = ((SuperConstructorInvocation)node).resolveConstructorBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof MethodRef) {
            binding = ((MethodRef)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof MemberRef) {
            binding = ((MemberRef)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof Type) {
            binding = ((Type)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof AbstractTypeDeclaration) {
            binding = ((AbstractTypeDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof AnnotationTypeMemberDeclaration) {
            binding = ((AnnotationTypeMemberDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof EnumConstantDeclaration) {
            binding = ((EnumConstantDeclaration)node).resolveVariable();
            res.add(this.createBinding(node, (IBinding)binding));
            IMethodBinding binding2 = ((EnumConstantDeclaration)node).resolveConstructorBinding();
            res.add(this.createBinding(node, (IBinding)binding2));
        } else if (node instanceof MethodDeclaration) {
            binding = ((MethodDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof VariableDeclaration) {
            binding = ((VariableDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof AnonymousClassDeclaration) {
            binding = ((AnonymousClassDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof ImportDeclaration) {
            binding = ((ImportDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof PackageDeclaration) {
            binding = ((PackageDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof TypeParameter) {
            binding = ((TypeParameter)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof MemberValuePair) {
            binding = ((MemberValuePair)node).resolveMemberValuePairBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        } else if (node instanceof ModuleDeclaration) {
            binding = ((ModuleDeclaration)node).resolveBinding();
            res.add(this.createBinding(node, (IBinding)binding));
        }
        List list = node.structuralPropertiesForType();
        for (StructuralPropertyDescriptor curr : list) {
            res.add(new NodeProperty(node, curr));
        }
        if (node instanceof CompilationUnit) {
            CompilationUnit root = (CompilationUnit)node;
            res.add(new JavaElement(root, root.getJavaElement()));
            res.add(new CommentsProperty(root));
            res.add(new ProblemsProperty(root));
            res.add(new SettingsProperty(root));
            res.add(new WellKnownTypesProperty(root));
        }
        return res.toArray();
    }

    private Binding createBinding(ASTNode parent, IBinding binding) {
        String label = Binding.getBindingLabel(binding);
        return new Binding(parent, label, binding, true);
    }

    private Object createExpressionTypeBinding(ASTNode parent, ITypeBinding binding) {
        String label = "> (Expression) type binding";
        return new Binding(parent, label, (IBinding)binding, true);
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }
}

