/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackObjectSizeIndexWriter;
import org.eclipse.jgit.internal.storage.file.PackReverseIndexComputed;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackObjectSizeIndexHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PackObjectSizeIndexHelper.class);

    public static void forAllPacks(ObjectDirectory db, ProgressMonitor pm) throws IOException {
        WindowCursor wc = (WindowCursor)db.newReader();
        for (Pack pack : db.getPacks()) {
            LOG.info("Checking " + pack.getPackName());
            if (pack.hasObjectSizeIndex()) {
                LOG.debug("    has object size index");
                continue;
            }
            List<PackedObjectInfo> objectsInPack = PackObjectSizeIndexHelper.getObjectsInPack(wc, pack, pm);
            LOG.debug(String.format("    index has %d objects", objectsInPack.size()));
            if (objectsInPack.isEmpty()) continue;
            LOG.info("    start writing object size index");
            PackFile packFile = pack.getPackFile().create(PackExt.OBJECT_SIZE_INDEX);
            long start = System.currentTimeMillis();
            Throwable throwable = null;
            Object var10_10 = null;
            try (FileOutputStream out = new FileOutputStream(packFile);){
                PackObjectSizeIndexWriter writer = PackObjectSizeIndexWriter.createWriter(out, 0);
                writer.write(objectsInPack);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            LOG.info(String.format("     done writing. Took %d ms", System.currentTimeMillis() - start));
        }
    }

    private static List<PackedObjectInfo> getObjectsInPack(WindowCursor wc, Pack pack, ProgressMonitor pm) throws IOException {
        PackIndex idx = pack.getIndex();
        PackReverseIndexComputed ridx = new PackReverseIndexComputed(idx);
        pm.beginTask("Adding size to objects in index", (int)idx.getObjectCount());
        ArrayList<PackedObjectInfo> objs = new ArrayList<PackedObjectInfo>((int)idx.getObjectCount());
        int i = 0;
        while ((long)i < idx.getObjectCount()) {
            ObjectId oid = ridx.findObjectByPosition(i);
            PackedObjectInfo poi = new PackedObjectInfo(oid);
            long offset = idx.findOffset(oid);
            poi.setFullSize(pack.getObjectSize(wc, offset));
            poi.setType(pack.getObjectType(wc, offset));
            objs.add(poi);
            pm.update(1);
            ++i;
        }
        pm.endTask();
        return objs;
    }

    private PackObjectSizeIndexHelper() {
    }
}

