/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.formatting2;

import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.dsl.model.AbstractControlFactory;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureCaptionProviderWithLabel;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureProvider;
import org.eclipse.emf.parsley.dsl.model.Binding;
import org.eclipse.emf.parsley.dsl.model.BindingsSpecification;
import org.eclipse.emf.parsley.dsl.model.Configurator;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecification;
import org.eclipse.emf.parsley.dsl.model.ExtendsClause;
import org.eclipse.emf.parsley.dsl.model.FeatureAssociatedExpression;
import org.eclipse.emf.parsley.dsl.model.FeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecification;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.LabelProvider;
import org.eclipse.emf.parsley.dsl.model.MenuBuilder;
import org.eclipse.emf.parsley.dsl.model.Model;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.PolymorphicSpecification;
import org.eclipse.emf.parsley.dsl.model.ProposalCreator;
import org.eclipse.emf.parsley.dsl.model.ProviderBinding;
import org.eclipse.emf.parsley.dsl.model.ResourceManager;
import org.eclipse.emf.parsley.dsl.model.SimpleMethodSpecification;
import org.eclipse.emf.parsley.dsl.model.TableLabelProvider;
import org.eclipse.emf.parsley.dsl.model.TableViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.TypeBinding;
import org.eclipse.emf.parsley.dsl.model.ValueBinding;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.emf.parsley.dsl.model.ViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.WithExpressions;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.model.WithFeatureAssociatedExpressions;
import org.eclipse.emf.parsley.dsl.model.WithFields;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.xbase.annotations.formatting2.XbaseWithAnnotationsFormatter;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class EmfParsleyDslFormatter
extends XbaseWithAnnotationsFormatter {
    public void format(Object o, IFormattableDocument document) {
        if (o instanceof AbstractControlFactory) {
            this._format((AbstractControlFactory)o, document);
            return;
        }
        if (o instanceof AbstractFeatureCaptionProviderWithLabel) {
            this._format((AbstractFeatureCaptionProviderWithLabel)o, document);
            return;
        }
        if (o instanceof AbstractFeatureProvider) {
            this._format((AbstractFeatureProvider)o, document);
            return;
        }
        if (o instanceof Configurator) {
            this._format((Configurator)o, document);
            return;
        }
        if (o instanceof FeatureCaptionProvider) {
            this._format((FeatureCaptionProvider)o, document);
            return;
        }
        if (o instanceof LabelProvider) {
            this._format((LabelProvider)o, document);
            return;
        }
        if (o instanceof MenuBuilder) {
            this._format((MenuBuilder)o, document);
            return;
        }
        if (o instanceof ProposalCreator) {
            this._format((ProposalCreator)o, document);
            return;
        }
        if (o instanceof ResourceManager) {
            this._format((ResourceManager)o, document);
            return;
        }
        if (o instanceof TableLabelProvider) {
            this._format((TableLabelProvider)o, document);
            return;
        }
        if (o instanceof TableViewerContentProvider) {
            this._format((TableViewerContentProvider)o, document);
            return;
        }
        if (o instanceof ViewerContentProvider) {
            this._format((ViewerContentProvider)o, document);
            return;
        }
        if (o instanceof ControlFactorySpecification) {
            this._format((ControlFactorySpecification)o, document);
            return;
        }
        if (o instanceof FeatureAssociatedExpression) {
            this._format((FeatureAssociatedExpression)o, document);
            return;
        }
        if (o instanceof FeatureSpecification) {
            this._format((FeatureSpecification)o, document);
            return;
        }
        if (o instanceof Module) {
            this._format((Module)o, document);
            return;
        }
        if (o instanceof ProviderBinding) {
            this._format((ProviderBinding)o, document);
            return;
        }
        if (o instanceof TypeBinding) {
            this._format((TypeBinding)o, document);
            return;
        }
        if (o instanceof ValueBinding) {
            this._format((ValueBinding)o, document);
            return;
        }
        if (o instanceof ViewSpecification) {
            this._format((ViewSpecification)o, document);
            return;
        }
        if (o instanceof BindingsSpecification) {
            this._format((BindingsSpecification)o, document);
            return;
        }
        if (o instanceof ExtendsClause) {
            this._format((ExtendsClause)o, document);
            return;
        }
        if (o instanceof FieldSpecification) {
            this._format((FieldSpecification)o, document);
            return;
        }
        if (o instanceof PolymorphicSpecification) {
            this._format((PolymorphicSpecification)o, document);
            return;
        }
        if (o instanceof Model) {
            this._format((Model)o, document);
            return;
        }
        if (o instanceof PartsSpecifications) {
            this._format((PartsSpecifications)o, document);
            return;
        }
        if (o instanceof SimpleMethodSpecification) {
            this._format((SimpleMethodSpecification)o, document);
            return;
        }
        super.format(o, document);
    }

    public void _format(Model model, @Extension IFormattableDocument document) {
        this.format(model.getImportSection(), document);
        this.format(model.getModule(), document);
    }

    public void _format(Module module, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.format(module.getExtendsClause(), document);
            this.format(module.getBindingsSpecification(), document);
            this.format(module.getLabelProvider(), document);
            this.format(module.getTableLabelProvider(), document);
            this.format(module.getFeatureCaptionProvider(), document);
            this.format(module.getFormFeatureCaptionProvider(), document);
            this.format(module.getDialogFeatureCaptionProvider(), document);
            this.format(module.getFeaturesProvider(), document);
            this.format(module.getTableFeaturesProvider(), document);
            this.format(module.getFormControlFactory(), document);
            this.format(module.getDialogControlFactory(), document);
            this.format(module.getProposalCreator(), document);
            this.format(module.getMenuBuilder(), document);
            this.format(module.getConfigurator(), document);
            this.format(module.getViewerContentProvider(), document);
            this.format(module.getTableViewerContentProvider(), document);
            this.format(module.getPartsSpecifications(), document);
            this.format(module.getResourceManager(), document);
        };
        this.indentBlock(module, document, _function);
    }

    public void _format(ExtendsClause extendsclause, @Extension IFormattableDocument document) {
        this.format(extendsclause.getSuperType(), document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.regionFor(extendsclause).keyword("extends"), _function);
    }

    public void _format(BindingsSpecification bindingsspecification, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> this.formatAndSeparateElementsWithNewlines((List)bindingsspecification.getBindings(), document);
        this.indentBlock(bindingsspecification, document, _function);
    }

    public void _format(TypeBinding typebinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(typebinding, "type", document);
        this.format(typebinding.getTypeToBind(), document);
        this.formatBinding(typebinding, document);
    }

    public void _format(ProviderBinding providerbinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(providerbinding, "provide", document);
        this.format(providerbinding.getType(), document);
        this.formatBinding(providerbinding, document);
    }

    public void _format(ValueBinding valuebinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(valuebinding, "value", document);
        this.format(valuebinding.getTypeDecl(), document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.regionFor(valuebinding).feature((EStructuralFeature)ModelPackage.Literals.VALUE_BINDING__ID), _function);
        this.formatBinding(valuebinding, document);
    }

    private void formatBinding(Binding binding, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.regionFor(binding).keyword("->"), _function);
        this.format(binding.getTo(), document);
    }

    public void _format(LabelProvider labelprovider, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.formatSpecifications(labelprovider.getTexts(), document);
            this.formatSpecifications(labelprovider.getImages(), document);
            this.formatSpecifications(labelprovider.getFonts(), document);
            this.formatSpecifications(labelprovider.getForegrounds(), document);
            this.formatSpecifications(labelprovider.getBackgrounds(), document);
        };
        this.formatWithFields(labelprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FieldSpecification expr, @Extension IFormattableDocument document) {
        EList<XAnnotation> _annotations = expr.getAnnotations();
        for (XAnnotation annotations : _annotations) {
            this.format(annotations, document);
        }
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append(this.regionFor(expr).keyword("val"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(this.regionFor(expr).keyword("var"), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.append(this.regionFor(expr).keyword("extension"), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.append((EObject)expr.getType(), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        document.surround(this.regionFor(expr).keyword("="), _function_4);
        this.format(expr.getType(), document);
        this.format(expr.getRight(), document);
        Procedures.Procedure1 _function_5 = it -> it.noSpace();
        document.prepend(this.regionFor(expr).keyword(";"), _function_5);
    }

    public void _format(TableLabelProvider tablelabelprovider, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.formatFeatureSpecifications(tablelabelprovider.getFeatureTexts(), document);
            this.formatFeatureSpecifications(tablelabelprovider.getFeatureImages(), document);
            this.formatFeatureSpecifications(tablelabelprovider.getFeatureFonts(), document);
            this.formatFeatureSpecifications(tablelabelprovider.getFeatureForegrounds(), document);
            this.formatFeatureSpecifications(tablelabelprovider.getFeatureBackgrounds(), document);
            this.formatSpecifications(tablelabelprovider.getRowFonts(), document);
            this.formatSpecifications(tablelabelprovider.getRowForegrounds(), document);
            this.formatSpecifications(tablelabelprovider.getRowBackgrounds(), document);
        };
        this.formatWithFields(tablelabelprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(PolymorphicSpecification specification, @Extension IFormattableDocument document) {
        this.format(specification.getParameterType(), document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.regionFor(specification).keyword("->"), _function);
        this.format(specification.getExpression(), document);
    }

    public void _format(FeatureCaptionProvider featurecaptionprovider, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            Provider _function_1 = () -> featurecaptionprovider.getFeatureTexts().getSpecifications();
            this.indentBlockAndFormatAndSeparateElementsWithNewlines(featurecaptionprovider.getFeatureTexts(), document, _function_1);
        };
        this.formatWithFields(featurecaptionprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(AbstractFeatureCaptionProviderWithLabel featurecaptionprovider, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.formatFeatureSpecifications(featurecaptionprovider.getFeatureTexts(), document);
            this.formatFeatureSpecifications(featurecaptionprovider.getFeatureLabels(), document);
        };
        this.formatWithFields(featurecaptionprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FeatureAssociatedExpression featureassociatedexpression, @Extension IFormattableDocument document) {
        this.format(featureassociatedexpression.getParameterType(), document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.regionFor(featureassociatedexpression).keyword(":"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.surround(this.regionFor(featureassociatedexpression).keyword("->"), _function_1);
        this.format(featureassociatedexpression.getExpression(), document);
    }

    public void _format(AbstractFeatureProvider featuresprovider, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            Provider _function_1 = () -> featuresprovider.getFeatures().getFeatureSpecifications();
            this.indentBlockAndFormatAndSeparateElementsWithNewlines(featuresprovider.getFeatures(), document, _function_1);
        };
        this.formatWithFields(featuresprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FeatureSpecification featurespecification, @Extension IFormattableDocument document) {
        this.format(featurespecification.getParameterType(), document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.regionFor(featurespecification).keyword("->"), _function);
        List _keywords = this.regionFor(featurespecification).keywords(new String[]{","});
        for (ISemanticRegion comma : _keywords) {
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            document.append(document.prepend(comma, _function_1), _function_2);
        }
    }

    public void _format(AbstractControlFactory controlfactory, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            Provider _function_1 = () -> controlfactory.getControls().getSpecifications();
            this.indentBlockAndFormatAndSeparateElementsWithNewlines(controlfactory.getControls(), document, _function_1);
        };
        this.formatWithFields(controlfactory, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(ControlFactorySpecification controlfactoryspecification, @Extension IFormattableDocument document) {
        this.format(controlfactoryspecification.getParameterType(), document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.regionFor(controlfactoryspecification).keyword(":"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.surround(this.regionFor(controlfactoryspecification).keyword("->"), _function_1);
        this.format(controlfactoryspecification.getExpression(), document);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.surround(this.regionFor(controlfactoryspecification).keyword("target"), _function_2);
        this.format(controlfactoryspecification.getTarget(), document);
    }

    public void _format(ProposalCreator proposalcreator, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> this.formatAndSeparateElementsWithNewlines((List)proposalcreator.getProposalsSpecifications(), document);
        this.formatWithFields(proposalcreator, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(MenuBuilder menubuilder, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.formatSpecifications(menubuilder.getMenus(), document);
            this.formatSpecifications(menubuilder.getEmfMenus(), document);
        };
        this.formatWithFields(menubuilder, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(Configurator configurator, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.formatSpecifications(configurator.getResourceURI(), document);
            this.formatSpecifications(configurator.getEClassSpec(), document);
        };
        this.formatWithFields(configurator, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(ViewerContentProvider viewercontentprovider, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.formatSpecifications(viewercontentprovider.getElements(), document);
            this.formatSpecifications(viewercontentprovider.getChildren(), document);
        };
        this.formatWithFields(viewercontentprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(TableViewerContentProvider tableviewercontentprovider, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> this.formatSpecifications(tableviewercontentprovider.getElements(), document);
        this.formatWithFields(tableviewercontentprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(ResourceManager resourcemanager, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            this.format(resourcemanager.getInitializeBody(), document);
            this.format(resourcemanager.getSaveBody(), document);
        };
        this.formatWithFields(resourcemanager, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(SimpleMethodSpecification simplemethodspecification, @Extension IFormattableDocument document) {
        this.formatAndSeparateWithNewlines(simplemethodspecification.getBody(), document);
    }

    public void _format(PartsSpecifications partsspecifications, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> this.formatAndSeparateElementsWithNewlines((List)partsspecifications.getParts(), document);
        this.indentBlock(partsspecifications, document, _function);
    }

    public void _format(ViewSpecification viewspecification, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            boolean _tripleNotEquals;
            Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
            document.append(this.regionFor(viewspecification).keyword("viewpart"), _function_1);
            Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
            document.append(this.regionFor(viewspecification).keyword("viewname"), _function_2);
            Procedures.Procedure1 _function_3 = it_1 -> it_1.setNewLines(1, 1, 2);
            document.append(this.regionFor(viewspecification).feature((EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__VIEW_NAME), _function_3);
            Procedures.Procedure1 _function_4 = it_1 -> it_1.oneSpace();
            document.append(this.regionFor(viewspecification).keyword("viewclass"), _function_4);
            this.format(viewspecification.getType(), document);
            Procedures.Procedure1 _function_5 = it_1 -> it_1.setNewLines(1, 1, 2);
            document.append((EObject)viewspecification.getType(), _function_5);
            String _category = viewspecification.getCategory();
            boolean bl = _tripleNotEquals = _category != null;
            if (_tripleNotEquals) {
                Procedures.Procedure1 _function_6 = it_1 -> it_1.oneSpace();
                document.append(this.regionFor(viewspecification).keyword("viewcategory"), _function_6);
                Procedures.Procedure1 _function_7 = it_1 -> it_1.setNewLines(1, 1, 2);
                document.append(this.regionFor(viewspecification).feature((EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__CATEGORY), _function_7);
            }
        };
        this.indentBlock(viewspecification, document, _function);
    }

    private WithExtendsClause formatWithFields(WithFields e, @Extension IFormattableDocument document, Procedures.Procedure1<? super WithFields> elementsFormatter) {
        Procedures.Procedure1 _function = it -> {
            this.formatFields(e, document);
            elementsFormatter.apply((Object)e);
        };
        return this.formatWithExtendsClause(e, document, (Procedures.Procedure1<? super WithExtendsClause>)_function);
    }

    private WithExtendsClause formatWithExtendsClause(WithExtendsClause e, @Extension IFormattableDocument document, Procedures.Procedure1<? super WithExtendsClause> elementsFormatter) {
        WithExtendsClause _xblockexpression = null;
        this.format(e.getExtendsClause(), document);
        Procedures.Procedure1 _function = it -> elementsFormatter.apply((Object)e);
        this.indentBlock(e, document, _function);
        _xblockexpression = this.separateElementsWithNewlines(e, document);
        return _xblockexpression;
    }

    private void formatFields(WithFields withFields, @Extension IFormattableDocument document) {
        this.formatAndSeparateElementsWithNewlines((List)withFields.getFields(), document);
    }

    private <T extends EObject> EObject formatSpecifications(WithExpressions e, @Extension IFormattableDocument document) {
        Provider _function = () -> e.getSpecifications();
        return this.indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
    }

    private <T extends EObject> EObject formatFeatureSpecifications(WithFeatureAssociatedExpressions e, @Extension IFormattableDocument document) {
        Provider _function = () -> e.getSpecifications();
        return this.indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
    }

    private <T extends EObject> EObject indentBlockAndFormatAndSeparateElementsWithNewlines(EObject parent, @Extension IFormattableDocument document, Provider<List<? extends T>> elementsProvider) {
        EObject _xifexpression = null;
        if (parent != null) {
            EObject _xblockexpression = null;
            List list = (List)elementsProvider.get();
            Procedures.Procedure1 _function = it -> this.formatAndSeparateElementsWithNewlines(list, document);
            this.indentBlock(parent, document, _function);
            _xifexpression = _xblockexpression = this.separateElementsWithNewlines(parent, document);
        }
        return _xifexpression;
    }

    private <T extends EObject> void formatAndSeparateElementsWithNewlines(List<? extends T> elements, @Extension IFormattableDocument document) {
        for (EObject e : elements) {
            this.formatAndSeparateWithNewlines(e, document);
        }
    }

    private <T extends EObject> T formatAndSeparateWithNewlines(T e, IFormattableDocument document) {
        T _xblockexpression = null;
        this.format(e, document);
        _xblockexpression = this.separateElementsWithNewlines(e, document);
        return _xblockexpression;
    }

    private <T extends EObject> ISemanticRegion oneSpaceAfterKeyword(T element, String k, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        return document.append(this.regionFor(element).keyword(k), _function);
    }

    private <T extends EObject> T separateElementsWithNewlines(T element, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(1, 1, 2);
        return (T)document.append(element, _function);
    }

    private <T extends EObject> void indentBlock(T element, @Extension IFormattableDocument document, Procedures.Procedure1<? super T> elementsFormatter) {
        ISemanticRegion open = this.regionFor(element).keyword("{");
        ISemanticRegion close = this.regionFor(element).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(open, _function);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.interior(open, close, _function_1);
        elementsFormatter.apply(element);
    }
}

