/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.eclipse.actf.visualization.eval.html.IHtmlEventHandlerAttributes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTagUtil
implements IHtmlEventHandlerAttributes {
    public static final String ATTR_HREF = "href";
    public static final String ATTR_ALT = "alt";
    public static final String ATTR_SRC = "src";
    public static final String ATTR_TITLE = "title";
    public static final String FLASH_OBJECT = "clsid:d27cdb6e-ae6d-11cf-96b8-444553540000";
    public static final String FLASH_CODEBASE = "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab";
    public static final String FLASH_TYPE = "application/x-shockwave-flash";
    public static final String FLASH_PLUGINSPAGE = "http://www.macromedia.com/go/getflashplayer";
    private static final String[] BLOCK_ELEMENT = new String[]{"address", "blockquote", "center", "dir", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "isindex", "menu", "noframes", "noscript", "ol", "p", "pre", "table", "ul", "dd", "frameset", "li", "tbody", "td", "tfoot", "th", "thead", "tr"};

    public static Set<String> getBlockElementSet() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < BLOCK_ELEMENT.length) {
            hashSet.add(BLOCK_ELEMENT[n]);
            ++n;
        }
        return hashSet;
    }

    public static boolean hasAncestor(Node node, String string) {
        boolean bl = false;
        Node node2 = node;
        while (node2 != null) {
            if (node2.getNodeName().equals(string)) {
                bl = true;
                break;
            }
            node2 = node2.getParentNode();
        }
        return bl;
    }

    public static Node getAncestor(Node node, String string) {
        Node node2 = node;
        while (node2 != null) {
            if (node2.getNodeName().equals(string)) {
                return node2;
            }
            node2 = node2.getParentNode();
        }
        return null;
    }

    public static String getNoScriptText(Node node) {
        Element element;
        StringBuffer stringBuffer = new StringBuffer();
        if (node.getNodeType() == 1 && (element = (Element)node).getElementsByTagName("script").getLength() > 0) {
            NodeList nodeList = element.getElementsByTagName("noscript");
            int n = 0;
            while (n < nodeList.getLength()) {
                stringBuffer.append(HtmlTagUtil.getTextAltDescendant(nodeList.item(n)));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String getTextAltDescendant(Node node) {
        Node node2 = node.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer(512);
        Stack<Node> stack = new Stack<Node>();
        while (node2 != null) {
            if (node2.getNodeType() == 3) {
                stringBuffer.append(String.valueOf(node2.getNodeValue().trim()) + " ");
            } else if (node2.getNodeName().equalsIgnoreCase("img")) {
                stringBuffer.append(String.valueOf(((Element)node2).getAttribute(ATTR_ALT).trim()) + " ");
            }
            if (node2.hasChildNodes()) {
                stack.push(node2);
                node2 = node2.getFirstChild();
                continue;
            }
            if (node2.getNextSibling() != null) {
                node2 = node2.getNextSibling();
                continue;
            }
            node2 = null;
            while (node2 == null && stack.size() > 0) {
                node2 = (Node)stack.pop();
                node2 = node2.getNextSibling();
            }
        }
        return stringBuffer.toString();
    }

    public static String getTextDescendant(Node node) {
        Node node2 = node.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer(512);
        Stack<Node> stack = new Stack<Node>();
        while (node2 != null) {
            if (node2.getNodeType() == 3) {
                stringBuffer.append(node2.getNodeValue());
            }
            if (node2.hasChildNodes()) {
                stack.push(node2);
                node2 = node2.getFirstChild();
                continue;
            }
            if (node2.getNextSibling() != null) {
                node2 = node2.getNextSibling();
                continue;
            }
            node2 = null;
            while (node2 == null && stack.size() > 0) {
                node2 = (Node)stack.pop();
                node2 = node2.getNextSibling();
            }
        }
        return stringBuffer.toString();
    }

    public static boolean hasTextDescendant(Node node) {
        Node node2 = node.getFirstChild();
        Stack<Node> stack = new Stack<Node>();
        while (node2 != null) {
            if (node2.getNodeType() == 3) {
                return true;
            }
            if (node2.hasChildNodes()) {
                stack.push(node2);
                node2 = node2.getFirstChild();
                continue;
            }
            if (node2.getNextSibling() != null) {
                node2 = node2.getNextSibling();
                continue;
            }
            node2 = null;
            while (node2 == null && stack.size() > 0) {
                node2 = (Node)stack.pop();
                node2 = node2.getNextSibling();
            }
        }
        return false;
    }

    public static List<Element> getImgElementsFromMap(Document document, Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        String string = element.getAttribute("name");
        NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//img[@usemap='#" + string + "']", (Node)document);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            arrayList.add(element2);
            ++n;
        }
        return arrayList;
    }

    public static boolean isTextControl(Element element) {
        String string = element.getTagName().toLowerCase();
        return string.equals("textarea") || string.equals("input") && element.getAttribute("type").toLowerCase().matches("|text|password");
    }

    public static boolean isButtonControl(Element element) {
        String string = element.getTagName().toLowerCase();
        return string.equals("button") && element.getAttribute("type").toLowerCase().matches("submit|reset|button") || string.equals("input") && element.getAttribute("type").toLowerCase().matches("submit|reset|button|image");
    }

    public static boolean isBlankString(String string) {
        return string.matches("[\\p{Space}\u3000\u00a0]*");
    }
}

