/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHFormCtrlElement;
import org.eclipse.actf.model.internal.dom.html.impl.SHOptionElement;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

public class SHSelectElement
extends SHFormCtrlElement
implements HTMLSelectElement {
    private static final long serialVersionUID = 7615986491286782573L;

    protected SHSelectElement(String string, SHDocument sHDocument) {
        super(string, sHDocument);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public int getSelectedIndex() {
        NodeList nodeList = this.getElementsByTagName("OPTION");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (((SHOptionElement)nodeList.item(n)).getSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setSelectedIndex(int n) {
        NodeList nodeList = this.getElementsByTagName("OPTION");
        if (n < 0 || nodeList.getLength() <= n) {
            return;
        }
        ((SHOptionElement)nodeList.item(n)).setAttribute("selected", "selected");
    }

    public String getValue() {
        NodeList nodeList = this.getElementsByTagName("OPTION");
        int n = 0;
        while (n < nodeList.getLength()) {
            SHOptionElement sHOptionElement = (SHOptionElement)nodeList.item(n);
            if (sHOptionElement.getSelected()) {
                return sHOptionElement.getValue();
            }
            ++n;
        }
        return null;
    }

    public void setValue(String string) {
        NodeList nodeList = this.getElementsByTagName("OPTION");
        int n = 0;
        while (n < nodeList.getLength()) {
            SHOptionElement sHOptionElement = (SHOptionElement)nodeList.item(n);
            if (sHOptionElement.getValue().equals(string)) {
                sHOptionElement.setAttribute("selected", "selected");
            }
            ++n;
        }
    }

    public int getLength() {
        return this.getElementsByTagName("OPTION").getLength();
    }

    public HTMLCollection getOptions() {
        NodeList nodeList = this.getElementsByTagName("OPTION");
        return ((SHDocument)this.getOwnerDocument()).createCollection(nodeList);
    }

    public boolean getMultiple() {
        String string = this.getAttribute("multiple");
        return string != null && string.length() != 0;
    }

    public void setMultiple(boolean bl) {
        this.setAttribute("multiple", bl ? "multiple" : null);
    }

    public int getSize() {
        String string = this.getAttribute("size");
        if (string != null && string.length() > 0) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public void setSize(int n) {
        this.setAttribute("size", Integer.toString(n));
    }

    public void add(HTMLElement hTMLElement, HTMLElement hTMLElement2) {
        if (hTMLElement2 == null) {
            this.insertBefore(hTMLElement, this.getFirstChild());
        } else {
            this.insertBefore(hTMLElement, hTMLElement2);
        }
    }

    public void remove(int n) {
        NodeList nodeList = this.getElementsByTagName("OPTION");
        if (n < 0 || nodeList.getLength() <= n) {
            return;
        }
        HTMLOptionElement hTMLOptionElement = (HTMLOptionElement)nodeList.item(n);
        hTMLOptionElement.getParentNode().removeChild(hTMLOptionElement);
    }

    public void blur() {
    }

    public void focus() {
    }
}

