/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLText;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HTMLErrorHandler
implements IErrorHandler {
    private boolean keepForm = true;

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean handleError(int n, IParser iParser, Node node) throws ParseException, IOException, SAXException {
        if (n == 4) {
            return false;
        }
        String string = node.getNodeName();
        Element element = iParser.getContext();
        Node node2 = element.getParentNode();
        String string2 = element.getNodeName();
        if (node instanceof Element) {
            ElementDefinition elementDefinition = ((ISGMLParser)iParser).getDTD().getElementDefinition(string);
            if (elementDefinition == null) {
                return false;
            }
            if (string.equalsIgnoreCase("LINK") || string.equalsIgnoreCase("STYLE") || string.equalsIgnoreCase("META") || string.equalsIgnoreCase("BASE") || string.equalsIgnoreCase("ISINDEX")) {
                Element element2 = iParser.getDocument().getDocumentElement();
                Node node3 = element2.getLastChild();
                while (node3 != null) {
                    if (node3 instanceof Element && node3.getNodeName().equalsIgnoreCase("HEAD")) {
                        node3.insertBefore(node, null);
                        iParser.error(n, node + " must be under " + node3);
                        return true;
                    }
                    node3 = node3.getPreviousSibling();
                }
            } else {
                if (string.equalsIgnoreCase("BODY")) {
                    Element element3 = iParser.getDocument().getDocumentElement();
                    Node node4 = element3.getFirstChild();
                    while (node4 != null) {
                        if (node4 instanceof Element && (node4.getNodeName().equalsIgnoreCase("BODY") || node4.getNodeName().equalsIgnoreCase("FRAMESET"))) {
                            return false;
                        }
                        node4 = node4.getNextSibling();
                    }
                    element3.insertBefore(node, null);
                    iParser.setContext((Element)node);
                    iParser.error(n, node + " must be under " + element3);
                    return true;
                }
                if (string.equalsIgnoreCase("HEAD")) {
                    NodeList nodeList;
                    Document document = iParser.getDocument();
                    if (element.getElementsByTagName("HEAD").getLength() == 0 && ((nodeList = document.getElementsByTagName("BODY")).getLength() > 0 || (nodeList = document.getElementsByTagName("FRAMESET")).getLength() > 0)) {
                        Element element4 = (Element)nodeList.item(0);
                        element4.getParentNode().insertBefore(node, element4);
                        iParser.setContext((Element)node);
                        iParser.error(n, node + " must be before " + element4);
                        return true;
                    }
                    if (document.getElementsByTagName("BODY").getLength() > 0 || document.getElementsByTagName("FRAMESET").getLength() > 0) {
                        iParser.error(n, "HTMLErrorHandler makes parser ignore " + node);
                        return true;
                    }
                } else if (string2.equalsIgnoreCase("HTML")) {
                    Node node5 = element.getLastChild();
                    while (node5 != null) {
                        if (node5 instanceof Element && node5.getNodeName().equalsIgnoreCase("BODY")) {
                            iParser.error(n, "BODY context is already closed.  Reopen it.");
                            iParser.reopenContext(1);
                            iParser.getContext().insertBefore(node, null);
                            iParser.setContext((Element)node);
                            return true;
                        }
                        if (node5 instanceof Comment || node5 instanceof ProcessingInstruction || node5 instanceof Text && this.whitespaceText((Text)node5)) {
                            node5 = node5.getPreviousSibling();
                            continue;
                        }
                        break;
                    }
                } else if (string.equalsIgnoreCase(string2) && elementDefinition.endTagOmittable() && node2 instanceof Element) {
                    node2.insertBefore(node, null);
                    iParser.setContext((Element)node);
                    return true;
                }
            }
        } else if (n == 6) {
            try {
                Vector vector = (Vector)iParser.getExtraErrInfo();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    EndTag endTag = (EndTag)enumeration.nextElement();
                    String string3 = endTag.getNodeName();
                    if (string3.equalsIgnoreCase("TABLE")) {
                        return true;
                    }
                    if (!this.keepForm || !string3.equalsIgnoreCase("FORM") || !string.equalsIgnoreCase("TD") && !string.equalsIgnoreCase("TR")) continue;
                    return true;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return false;
    }

    void setKeepForm(boolean bl) {
        this.keepForm = bl;
    }

    private boolean whitespaceText(Text text) {
        if (text instanceof SGMLText) {
            return ((SGMLText)text).getIsWhitespaceInElementContent();
        }
        char[] cArray = text.getData().toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isWhitespace(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

