/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.flash;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.IFlashMSAANode;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.DocumentImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashTerms;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashTopNodeImpl;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.util.dom.EmptyNodeListImpl;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.win32.comclutch.ComPlugin;
import org.eclipse.actf.util.win32.keyhook.ISendEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

class FlashNodeImpl
implements IFlashNode,
IFlashConst {
    private final ASAccInfo accInfo;
    private final String target;
    private final IFlashNode parent;
    private final boolean hasChildren;
    private FlashTopNodeImpl swf;
    private DocumentImpl doc;
    private final IASNode flashNode;
    private final IASBridge flashPlayer;
    private static ISendEvent sendEvent;

    public int hashCode() {
        return this.target.intern().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FlashNodeImpl) {
            FlashNodeImpl flashNodeImpl = (FlashNodeImpl)object;
            return ((Object)((Object)this.swf)).equals((Object)flashNodeImpl.swf) && this.target.equals(flashNodeImpl.target);
        }
        return false;
    }

    private FlashNodeImpl(IASNode iASNode, IFlashNode iFlashNode) {
        this.flashNode = iASNode;
        this.flashPlayer = iASNode.getPlayer();
        this.target = iASNode.getTarget();
        this.accInfo = iASNode.getAccInfo();
        this.hasChildren = !iASNode.isOpaqueObject();
        this.parent = iFlashNode;
    }

    FlashNodeImpl(FlashNodeImpl flashNodeImpl, IASNode iASNode) {
        this(iASNode, flashNodeImpl);
        this.swf = flashNodeImpl.swf;
        this.doc = flashNodeImpl.doc;
    }

    FlashNodeImpl(FlashTopNodeImpl flashTopNodeImpl, IASNode iASNode) {
        this(iASNode, flashTopNodeImpl);
        this.swf = flashTopNodeImpl;
        this.doc = (DocumentImpl)flashTopNodeImpl.getOwnerDocument();
    }

    private Object getProperty(String string) {
        return this.flashPlayer.getProperty(this.getTarget(), string);
    }

    private void setProperty(String string, Object object) {
        this.flashPlayer.setProperty(this.getTarget(), string, object);
    }

    private ISendEvent getSendEvent() {
        if (sendEvent == null) {
            sendEvent = ComPlugin.getDefault().newSendEvent();
        }
        return sendEvent;
    }

    public String getNodeName() {
        return "#flashNode:" + this.getTarget();
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public short getNodeType() {
        return 1;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        if (!this.hasChildren) {
            return EmptyNodeListImpl.getInstance();
        }
        IFlashNode[] iFlashNodeArray = this.getSWFChildNodes();
        return new NodeListImpl(iFlashNodeArray);
    }

    public Node getFirstChild() {
        if (!this.hasChildren) {
            return null;
        }
        IFlashNode[] iFlashNodeArray = this.getSWFChildNodes();
        if (iFlashNodeArray == null) {
            return null;
        }
        if (iFlashNodeArray.length == 0) {
            return null;
        }
        return iFlashNodeArray[0];
    }

    public Node getLastChild() {
        if (!this.hasChildren) {
            return null;
        }
        IFlashNode[] iFlashNodeArray = this.getSWFChildNodes();
        if (iFlashNodeArray == null) {
            return null;
        }
        if (iFlashNodeArray.length == 0) {
            return null;
        }
        return iFlashNodeArray[iFlashNodeArray.length - 1];
    }

    public Node getPreviousSibling() {
        throw new UnsupportedOperationException();
    }

    public Node getNextSibling() {
        throw new UnsupportedOperationException();
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public Node removeChild(Node node) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public Node appendChild(Node node) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean hasChildNodes() {
        if (!this.hasChildren) {
            return false;
        }
        IFlashNode[] iFlashNodeArray = this.getSWFChildNodes();
        if (iFlashNodeArray == null) {
            return false;
        }
        return iFlashNodeArray.length != 0;
    }

    public Node cloneNode(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        String string = this.getTarget();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        return this.extractString();
    }

    public void setTextContent(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean isSameNode(Node node) {
        return false;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return false;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public boolean isEqualNode(Node node) {
        return false;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String string) {
        throw new UnsupportedOperationException();
    }

    private String decodeString(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public String extractString() {
        String string = null;
        if (this.accInfo != null) {
            string = this.accInfo.getName();
        }
        if (string == null) {
            string = this.flashNode.getText(false);
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public short getHeadingLevel() {
        return 0;
    }

    public String getLinkURI() {
        return null;
    }

    public void setText(String string) {
        this.setProperty("text", string);
    }

    public String getText() {
        Object object = this.getProperty("text");
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    private boolean doHardwareClick() {
        long l = this.swf.getHWND();
        int n = (int)this.flashNode.getX();
        int n2 = (int)this.flashNode.getY();
        int n3 = (int)this.flashNode.getWidth();
        int n4 = (int)this.flashNode.getHeight();
        int n5 = n + n3 / 4;
        int n6 = n2 + n4 / 4;
        this.getSendEvent().focusWindow(l);
        this.setFocus();
        this.getSendEvent().postMouse(n5, n6, false);
        boolean bl = this.getSendEvent().postMouse(n5, n6, true);
        return bl;
    }

    String getClickableTarget(String string) {
        while (string.length() > 0) {
            String string2 = String.valueOf(string) + ".onRelease";
            if (this.swf.getNodeFromPath(string2) != null) {
                return string;
            }
            String string3 = String.valueOf(string) + ".onPress";
            if (this.swf.getNodeFromPath(string3) != null) {
                return string;
            }
            int n = string.lastIndexOf(46);
            if (n <= 0) break;
            string = string.substring(0, n);
        }
        return null;
    }

    public boolean doClick() {
        String string = this.getTarget();
        if (string.length() > 0) {
            String string2 = String.valueOf(string) + ".onRelease";
            if (this.swf.getNodeFromPath(string2) != null) {
                this.flashPlayer.callMethod(this.flashNode, "onRelease");
                return true;
            }
            String string3 = String.valueOf(string) + ".onPress";
            if (this.swf.getNodeFromPath(string3) != null) {
                this.flashPlayer.callMethod(this.flashNode, "onPress");
                return true;
            }
        }
        return this.doHardwareClick();
    }

    public boolean highlight() {
        this.flashPlayer.callMethod(this.flashNode, "onRollOver");
        boolean bl = this.swf.highlight();
        boolean bl2 = this.flashNode.setMarker();
        return bl && bl2;
    }

    public boolean unhighlight() {
        this.flashPlayer.callMethod(this.flashNode, "onRollOut");
        boolean bl = this.swf.unhighlight();
        boolean bl2 = this.flashPlayer.unsetMarker();
        return bl && bl2;
    }

    public boolean setFocus() {
        if (!this.swf.setFocus()) {
            return false;
        }
        return this.flashPlayer.setFocus(this.getTarget());
    }

    public int getNth() {
        return 0;
    }

    public String getTarget() {
        return this.target;
    }

    public IFlashNode getNodeFromPath(String string) {
        return this.swf.getNodeFromPath(string);
    }

    public IFlashNode getNodeAtDepth(int n) {
        IASNode iASNode = this.flashPlayer.getNodeAtDepthWithPath(this.getTarget(), n);
        if (iASNode == null) {
            return null;
        }
        return new FlashNodeImpl(this.swf, iASNode);
    }

    private IFlashNode[] createIFlashNodeArray(IASNode[] iASNodeArray) {
        IFlashNode[] iFlashNodeArray = new IFlashNode[iASNodeArray.length];
        int n = 0;
        while (n < iASNodeArray.length) {
            iFlashNodeArray[n] = new FlashNodeImpl(this, iASNodeArray[n]);
            ++n;
        }
        return iFlashNodeArray;
    }

    public IFlashNode[] getInnerNodes() {
        return this.createIFlashNodeArray(this.flashNode.getChildren(true));
    }

    public IFlashNode[] getSWFChildNodes() {
        return this.createIFlashNodeArray(this.flashNode.getChildren(false));
    }

    public int getDepth() {
        return this.flashNode.getDepth();
    }

    public int getCurrentFrame() {
        return this.flashNode.getCurrentFrame();
    }

    public IFlashNode[] translate() {
        return this.createIFlashNodeArray(this.flashPlayer.translateWithPath(this.getTarget()));
    }

    public INodeEx getBaseNode() {
        return this.swf;
    }

    boolean isInputable() {
        return this.flashNode.isInputable();
    }

    boolean isSilent() {
        return this.accInfo.isSilent();
    }

    public AnalyzedResult analyze(AnalyzedResult analyzedResult) {
        return analyzedResult;
    }

    public AbstractTerms getTerms() {
        return FlashTerms.getInstance();
    }

    public Rectangle getLocation() {
        return this.swf.getLocation();
    }

    public IFlashMSAANode getMSAA() {
        return null;
    }

    public void repairFlash() {
    }

    public String[] getStillPictureData() {
        return new String[3];
    }

    public char getAccessKey() {
        return '\u0000';
    }

    private static class NodeListImpl
    implements NodeList {
        private final IFlashNode[] nodes;

        public Node item(int n) {
            if (n < 0 || n >= this.nodes.length) {
                return null;
            }
            return this.nodes[n];
        }

        public int getLength() {
            return this.nodes.length;
        }

        NodeListImpl(IFlashNode[] iFlashNodeArray) {
            this.nodes = iFlashNodeArray;
        }
    }
}

