/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Bytes {
    private static final boolean bigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private Bytes() {
    }

    private static boolean equals(int a, int b) {
        return a == b;
    }

    private static short toShort(byte[] array, int offset) {
        return (short)((array[offset] & 0xFF) << 8 | array[offset + 1] & 0xFF);
    }

    private static int toInt(byte[] array, int offset) {
        return (array[offset] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | array[offset + 3] & 0xFF;
    }

    public static RegionComparator capturedComparator(byte[] array, int offset, int len) {
        if (len <= 0) {
            return (firstByte, b) -> true;
        }
        switch (len) {
            case 1: {
                return Bytes.comparatorLen1(array, offset);
            }
            case 2: {
                return Bytes.comparatorLen2(array, offset);
            }
            case 3: {
                return Bytes.comparatorLen3(array, offset);
            }
            case 4: {
                return Bytes.comparatorLen4(array, offset);
            }
            case 5: {
                return Bytes.comparatorLen5(array, offset);
            }
            case 6: {
                return Bytes.comparatorLen6(array, offset);
            }
            case 7: {
                return Bytes.comparatorLen7(array, offset);
            }
            case 8: {
                return Bytes.comparatorLen8(array, offset);
            }
            case 9: {
                return Bytes.comparatorLen9(array, offset);
            }
            case 10: {
                return Bytes.comparatorLen10(array, offset);
            }
            case 11: {
                return Bytes.comparatorLen11(array, offset);
            }
            case 12: {
                return Bytes.comparatorLen12(array, offset);
            }
            case 13: {
                return Bytes.comparatorLen13(array, offset);
            }
            case 14: {
                return Bytes.comparatorLen14(array, offset);
            }
            case 15: {
                return Bytes.comparatorLen15(array, offset);
            }
            case 16: {
                return Bytes.comparatorLen16(array, offset);
            }
            case 17: {
                return Bytes.comparatorLen17(array, offset);
            }
            case 18: {
                return Bytes.comparatorLen18(array, offset);
            }
            case 19: {
                return Bytes.comparatorLen19(array, offset);
            }
            case 20: {
                return Bytes.comparatorLen20(array, offset);
            }
        }
        return Bytes.comparatorGeneric(array, offset, len);
    }

    private static RegionComparator comparatorLen1(byte[] array, int offset) {
        return (firstByte, b) -> Bytes.equals(array[offset], firstByte);
    }

    private static RegionComparator comparatorLen2(byte[] array, int offset) {
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            return Bytes.equals(array[offset + 1], b.get());
        };
    }

    private static RegionComparator comparatorLen3(byte[] array, int offset) {
        short expected = Bytes.toShort(array, offset + 1);
        short expectedEndian = bigEndian ? expected : Short.reverseBytes(expected);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            return Bytes.equals(expectedEndian, b.getShort());
        };
    }

    private static RegionComparator comparatorLen4(byte[] array, int offset) {
        int expected = Bytes.toInt(array, offset);
        int expectedEndian = bigEndian ? expected : Integer.reverseBytes(expected);
        return (firstByte, b) -> {
            b.position(b.position() - 1);
            return Bytes.equals(expectedEndian, b.getInt());
        };
    }

    private static RegionComparator comparatorLen5(byte[] array, int offset) {
        int expected = Bytes.toInt(array, offset + 1);
        int expectedEndian = bigEndian ? expected : Integer.reverseBytes(expected);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            return Bytes.equals(expectedEndian, b.getInt());
        };
    }

    private static RegionComparator comparatorLen6(byte[] array, int offset) {
        int expected = Bytes.toInt(array, offset + 1);
        int expectedEndian = bigEndian ? expected : Integer.reverseBytes(expected);
        byte tail = array[offset + 5];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expectedEndian, b.getInt())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorLen7(byte[] array, int offset) {
        int expected = Bytes.toInt(array, offset + 1);
        int expectedEndian = bigEndian ? expected : Integer.reverseBytes(expected);
        short expectedTail = Bytes.toShort(array, offset + 5);
        short expectedTailEndian = bigEndian ? expectedTail : Short.reverseBytes(expectedTail);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expectedEndian, b.getInt())) {
                return false;
            }
            return Bytes.equals(expectedTailEndian, b.getShort());
        };
    }

    private static RegionComparator comparatorLen8(byte[] array, int offset) {
        int expected = Bytes.toInt(array, offset + 1);
        int expectedEndian = bigEndian ? expected : Integer.reverseBytes(expected);
        short expectedShort = Bytes.toShort(array, offset + 5);
        short expectedShortEndian = bigEndian ? expectedShort : Short.reverseBytes(expectedShort);
        byte tail = array[offset + 7];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expectedEndian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expectedShortEndian, b.getShort())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorLen9(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(expected2Endian, b.getInt());
        };
    }

    private static RegionComparator comparatorLen10(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        byte tail = array[offset + 9];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorLen11(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        short expectedShort = Bytes.toShort(array, offset + 9);
        short expectedShortEndian = bigEndian ? expectedShort : Short.reverseBytes(expectedShort);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(expectedShortEndian, b.getShort());
        };
    }

    private static RegionComparator comparatorLen12(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        short expectedShort = Bytes.toShort(array, offset + 9);
        short expectedShortEndian = bigEndian ? expectedShort : Short.reverseBytes(expectedShort);
        byte tail = array[offset + 11];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expectedShortEndian, b.getShort())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorLen13(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(expected3Endian, b.getInt());
        };
    }

    private static RegionComparator comparatorLen14(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        byte tail = array[offset + 13];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected3Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorLen15(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        short expectedShort = Bytes.toShort(array, offset + 13);
        short expectedShortEndian = bigEndian ? expectedShort : Short.reverseBytes(expectedShort);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected3Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(expectedShortEndian, b.getShort());
        };
    }

    private static RegionComparator comparatorLen16(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        short expectedShort = Bytes.toShort(array, offset + 13);
        short expectedShortEndian = bigEndian ? expectedShort : Short.reverseBytes(expectedShort);
        byte tail = array[offset + 15];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected3Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expectedShortEndian, b.getShort())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorLen17(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        int expected4 = Bytes.toInt(array, offset + 13);
        int expected4Endian = bigEndian ? expected4 : Integer.reverseBytes(expected4);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected3Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(expected4Endian, b.getInt());
        };
    }

    private static RegionComparator comparatorLen18(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        int expected4 = Bytes.toInt(array, offset + 13);
        int expected4Endian = bigEndian ? expected4 : Integer.reverseBytes(expected4);
        byte tail = array[offset + 17];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected3Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected4Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorLen19(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        int expected4 = Bytes.toInt(array, offset + 13);
        int expected4Endian = bigEndian ? expected4 : Integer.reverseBytes(expected4);
        short expectedShort = Bytes.toShort(array, offset + 17);
        short expectedShortEndian = bigEndian ? expectedShort : Short.reverseBytes(expectedShort);
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected3Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected4Endian, b.getInt())) {
                return false;
            }
            return Bytes.equals(expectedShortEndian, b.getShort());
        };
    }

    private static RegionComparator comparatorLen20(byte[] array, int offset) {
        int expected1 = Bytes.toInt(array, offset + 1);
        int expected1Endian = bigEndian ? expected1 : Integer.reverseBytes(expected1);
        int expected2 = Bytes.toInt(array, offset + 5);
        int expected2Endian = bigEndian ? expected2 : Integer.reverseBytes(expected2);
        int expected3 = Bytes.toInt(array, offset + 9);
        int expected3Endian = bigEndian ? expected3 : Integer.reverseBytes(expected3);
        int expected4 = Bytes.toInt(array, offset + 13);
        int expected4Endian = bigEndian ? expected4 : Integer.reverseBytes(expected4);
        short expectedShort = Bytes.toShort(array, offset + 17);
        short expectedShortEndian = bigEndian ? expectedShort : Short.reverseBytes(expectedShort);
        byte tail = array[offset + 19];
        return (firstByte, b) -> {
            if (!Bytes.equals(array[offset], firstByte)) {
                return false;
            }
            if (!Bytes.equals(expected1Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected2Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected3Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expected4Endian, b.getInt())) {
                return false;
            }
            if (!Bytes.equals(expectedShortEndian, b.getShort())) {
                return false;
            }
            return Bytes.equals(tail, b.get());
        };
    }

    private static RegionComparator comparatorGeneric(byte[] array, int offset, int len) {
        int start = offset;
        int end = offset + len;
        return (firstByte, b) -> {
            if (!Bytes.equals(array[start], firstByte)) {
                return false;
            }
            for (int idx = start + 1; idx < end; ++idx) {
                if (Bytes.equals(array[idx], b.get())) continue;
                return false;
            }
            return true;
        };
    }

    @FunctionalInterface
    public static interface RegionComparator {
        public boolean equals(byte var1, ByteBuffer var2);
    }
}

