/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.GetNodes;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.data.objects.Tree;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class GetNodesService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        GetNodes gn = (GetNodes)command;
        String name = gn.getName();
        int pos = gn.getPos();
        int len = gn.getLen();
        EObject object = gn.getObject();
        if (!(object instanceof Tree)) {
            return EclDataPlugin.createErr("This type of object is not supported by the command", new Object[0]);
        }
        Tree tree = (Tree)object;
        EList<EObject> nodes = this.getNodesFromTree(tree, name);
        if (nodes.size() == 0) {
            return Status.OK_STATUS;
        }
        int maxPos = this.getAndValidateMaxPosIndex(pos, len, nodes.size());
        while (pos < maxPos) {
            context.getOutput().write(nodes.get(pos));
            ++pos;
        }
        return Status.OK_STATUS;
    }

    private EList<EObject> getNodesFromTree(Tree tree, String name) {
        BasicEList nodes = new BasicEList();
        if (name != null && !name.equals("")) {
            for (Tree child : tree.getChildren()) {
                if (!child.getName().equals(name)) continue;
                nodes.add((Object)child);
            }
            return nodes;
        }
        for (Tree child : tree.getChildren()) {
            nodes.add((Object)child);
        }
        return nodes;
    }

    private int getAndValidateMaxPosIndex(int pos, int len, int size) throws CoreException {
        if (pos < 0 || pos >= size) {
            throw new CoreException(EclDataPlugin.createErr("Invalid value of the 'pos' parameter. It should be in the range [%d, %d].", 0, size - 1));
        }
        int maxLen = size - pos;
        if (len == -1) {
            len = maxLen;
        }
        if (len < 0 || len > maxLen) {
            throw new CoreException(EclDataPlugin.createErr("Invalid value of the 'len' parameter. It should be in the range [%d, %d].", 0, maxLen));
        }
        int maxPos = len + pos;
        return maxPos;
    }
}

