/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal.keys;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.field.FiniteField;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.keys.ObjectIds;
import org.eclipse.jgit.util.sha1.SHA1;

public final class KeyGrip {
    private KeyGrip() {
    }

    @NonNull
    public static byte[] getKeyGrip(PGPPublicKey publicKey) throws PGPException {
        SHA1 grip = SHA1.newInstance();
        grip.setDetectCollision(false);
        switch (publicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                BigInteger modulus = ((RSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey()).getModulus();
                KeyGrip.hash(grip, modulus.toByteArray());
                break;
            }
            case 17: {
                DSAPublicBCPGKey dsa = (DSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                KeyGrip.hash(grip, dsa.getP().toByteArray(), 'p', true);
                KeyGrip.hash(grip, dsa.getQ().toByteArray(), 'q', true);
                KeyGrip.hash(grip, dsa.getG().toByteArray(), 'g', true);
                KeyGrip.hash(grip, dsa.getY().toByteArray(), 'y', true);
                break;
            }
            case 16: 
            case 20: {
                ElGamalPublicBCPGKey eg = (ElGamalPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                KeyGrip.hash(grip, eg.getP().toByteArray(), 'p', true);
                KeyGrip.hash(grip, eg.getG().toByteArray(), 'g', true);
                KeyGrip.hash(grip, eg.getY().toByteArray(), 'y', true);
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 27: {
                ECPublicBCPGKey ec = (ECPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                ASN1ObjectIdentifier curveOID = ec.getCurveOID();
                if (ObjectIds.isEd25519(curveOID)) {
                    return KeyGrip.hashEd25519(grip, ec.getEncodedPoint());
                }
                if (ObjectIds.isCurve25519(curveOID)) {
                    return KeyGrip.hashCurve25519(grip, ec.getEncodedPoint());
                }
                X9ECParameters params = KeyGrip.getX9Parameters(curveOID);
                if (params == null) {
                    throw new PGPException(MessageFormat.format(BCText.get().unknownCurve, curveOID.getId()));
                }
                BigInteger q = ec.getEncodedPoint();
                byte[] g = params.getG().getEncoded(false);
                BigInteger a = params.getCurve().getA().toBigInteger();
                BigInteger b = params.getCurve().getB().toBigInteger();
                BigInteger n = params.getN();
                BigInteger p = null;
                FiniteField field = params.getCurve().getField();
                if (ECAlgorithms.isFpField((FiniteField)field)) {
                    p = field.getCharacteristic();
                }
                if (p == null) {
                    throw new PGPException(MessageFormat.format(BCText.get().unknownCurveParameters, curveOID.getId()));
                }
                KeyGrip.hash(grip, p.toByteArray(), 'p', false);
                KeyGrip.hash(grip, a.toByteArray(), 'a', false);
                KeyGrip.hash(grip, b.toByteArray(), 'b', false);
                KeyGrip.hash(grip, g, 'g', false);
                KeyGrip.hash(grip, n.toByteArray(), 'n', false);
                int algorithm = publicKey.getAlgorithm();
                if (algorithm == 22 || algorithm == 27) {
                    KeyGrip.hashQ25519(grip, q);
                    break;
                }
                KeyGrip.hash(grip, q.toByteArray(), 'q', false);
                break;
            }
            default: {
                throw new PGPException(MessageFormat.format(BCText.get().unknownKeyType, Integer.toString(publicKey.getAlgorithm())));
            }
        }
        return grip.digest();
    }

    private static void hash(SHA1 grip, byte[] data) {
        int i = 0;
        while (i < data.length && data[i] == 0) {
            ++i;
        }
        int length = data.length - i;
        if (i < data.length) {
            if ((data[i] & 0x80) != 0) {
                grip.update((byte)0);
            }
            grip.update(data, i, length);
        }
    }

    private static void hash(SHA1 grip, byte[] data, char id, boolean zeroPad) {
        int i = 0;
        while (i < data.length && data[i] == 0) {
            ++i;
        }
        int length = data.length - i;
        boolean addZero = false;
        if (i < data.length && zeroPad && (data[i] & 0x80) != 0) {
            addZero = true;
        }
        String prefix = "(1:" + id + (addZero ? length + 1 : length) + ":";
        grip.update(prefix.getBytes(StandardCharsets.US_ASCII));
        if (addZero) {
            grip.update((byte)0);
        }
        if (i < data.length) {
            grip.update(data, i, length);
        }
        grip.update((byte)41);
    }

    private static void hashQ25519(SHA1 grip, BigInteger q) throws PGPException {
        byte[] data = q.toByteArray();
        switch (data[0]) {
            case 4: {
                if (data.length != 65) {
                    throw new PGPException(MessageFormat.format(BCText.get().corrupt25519Key, Hex.toHexString((byte[])data)));
                }
                throw new PGPException(MessageFormat.format(BCText.get().uncompressed25519Key, Hex.toHexString((byte[])data)));
            }
            case 64: {
                if (data.length != 33) {
                    throw new PGPException(MessageFormat.format(BCText.get().corrupt25519Key, Hex.toHexString((byte[])data)));
                }
                KeyGrip.hash(grip, Arrays.copyOfRange(data, 1, data.length), 'q', false);
                break;
            }
            default: {
                if (data.length != 32) {
                    throw new PGPException(MessageFormat.format(BCText.get().corrupt25519Key, Hex.toHexString((byte[])data)));
                }
                KeyGrip.hash(grip, data, 'q', false);
            }
        }
    }

    static byte[] hashEd25519(SHA1 grip, BigInteger q) throws PGPException {
        KeyGrip.hash(grip, Hex.decodeStrict((String)"7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFED"), 'p', false);
        KeyGrip.hash(grip, new byte[]{1}, 'a', false);
        KeyGrip.hash(grip, Hex.decodeStrict((String)"2DFC9311D490018C7338BF8688861767FF8FF5B2BEBE27548A14B235ECA6874A"), 'b', false);
        KeyGrip.hash(grip, Hex.decodeStrict((String)"04216936D3CD6E53FEC0A4E231FDD6DC5C692CC7609525A7B2C9562D608F25D51A6666666666666666666666666666666666666666666666666666666666666658"), 'g', false);
        KeyGrip.hash(grip, Hex.decodeStrict((String)"1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"), 'n', false);
        KeyGrip.hashQ25519(grip, q);
        return grip.digest();
    }

    static byte[] hashCurve25519(SHA1 grip, BigInteger q) throws PGPException {
        KeyGrip.hash(grip, Hex.decodeStrict((String)"7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFED"), 'p', false);
        KeyGrip.hash(grip, new byte[]{1, -37, 65}, 'a', false);
        KeyGrip.hash(grip, new byte[]{1}, 'b', false);
        KeyGrip.hash(grip, Hex.decodeStrict((String)"04000000000000000000000000000000000000000000000000000000000000000920AE19A1B8A086B4E01EDD2C7748D14C923D4D7E6D7C61B229E9C5A27ECED3D9"), 'g', false);
        KeyGrip.hash(grip, Hex.decodeStrict((String)"1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"), 'n', false);
        KeyGrip.hashQ25519(grip, q);
        return grip.digest();
    }

    private static X9ECParameters getX9Parameters(ASN1ObjectIdentifier curveOID) {
        X9ECParameters params = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)curveOID);
        if (params == null) {
            params = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOID);
        }
        return params;
    }
}

