/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Button implements Enumerator
{
    NONE(0, "none", "none"),
    BUTTON1(1, "button1", "button1"),
    BUTTON2(2, "button2", "button2"),
    BUTTON3(3, "button3", "button3");

    public static final int NONE_VALUE = 0;
    public static final int BUTTON1_VALUE = 1;
    public static final int BUTTON2_VALUE = 2;
    public static final int BUTTON3_VALUE = 3;
    private static final Button[] VALUES_ARRAY;
    public static final List<Button> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Button[]{NONE, BUTTON1, BUTTON2, BUTTON3};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Button get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Button result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Button getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Button result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Button get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return BUTTON1;
            }
            case 2: {
                return BUTTON2;
            }
            case 3: {
                return BUTTON3;
            }
        }
        return null;
    }

    private Button(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

