/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.hover;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ExpressionInformationControlCreator
implements IInformationControlCreator {
    public IInformationControl createInformationControl(Shell parent) {
        return new ExpressionInformationControl(parent, false);
    }

    class ExpressionInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private static final String HEIGHT = "HEIGHT";
        private static final String WIDTH = "WIDTH";
        private static final String SASH_WEIGHT_TREE = "SashWeightTree";
        private static final String SASH_WEIGHT_DETAILS = "SashWeightDetails";
        private IVariable fVariable;
        private IPresentationContext fContext;
        private TreeModelViewer fViewer;
        private SashForm fSashForm;
        private Composite fDetailPaneComposite;
        private DetailPaneProxy fDetailPane;
        private Tree fTree;

        ExpressionInformationControl(Shell parentShell, boolean resize) {
            super(parentShell, resize);
            this.create();
        }

        public Point computeSizeHint() {
            int y;
            int x;
            IDialogSettings settings = this.getDialogSettings(false);
            if (settings != null && (x = this.getIntSetting(settings, WIDTH)) > 0 && (y = this.getIntSetting(settings, HEIGHT)) > 0) {
                return new Point(x, y);
            }
            return super.computeSizeHint();
        }

        private IDialogSettings getDialogSettings(boolean create) {
            IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ExpressionInformationControlCreator.class)).getDialogSettings();
            IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
            if (section == null && create) {
                section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
            }
            return section;
        }

        private int getIntSetting(IDialogSettings settings, String key) {
            try {
                return settings.getInt(key);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        public void dispose() {
            this.persistSettings(this.getShell());
            this.fContext.dispose();
            super.dispose();
        }

        private void persistSettings(Shell shell) {
            if (shell != null && !shell.isDisposed() && this.isResizable()) {
                IDialogSettings settings = this.getDialogSettings(true);
                Point size = shell.getSize();
                settings.put(WIDTH, size.x);
                settings.put(HEIGHT, size.y);
                int[] weights = this.fSashForm.getWeights();
                settings.put(SASH_WEIGHT_TREE, weights[0]);
                settings.put(SASH_WEIGHT_DETAILS, weights[1]);
            }
        }

        public void setVisible(boolean visible) {
            if (!visible) {
                this.persistSettings(this.getShell());
            }
            super.setVisible(visible);
        }

        protected void createContent(Composite parent) {
            StructuredViewer structuredViewer;
            int n;
            int n2;
            String[] stringArray;
            this.fSashForm = new SashForm(parent, parent.getStyle());
            this.fSashForm.setOrientation(512);
            AbstractDebugView view = this.getViewToEmulate();
            this.fContext = new PresentationContext("org.eclipse.debug.ui.VariableView");
            if (view != null) {
                IPresentationContext copy = ((TreeModelViewer)view.getViewer()).getPresentationContext();
                stringArray = copy.getProperties();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String key = stringArray[n];
                    this.fContext.setProperty(key, copy.getProperty(key));
                    ++n;
                }
            }
            this.fViewer = new TreeModelViewer((Composite)this.fSashForm, 0x1000000A, this.fContext);
            this.fViewer.setAutoExpandLevel(1);
            if (view != null && (structuredViewer = (StructuredViewer)view.getViewer()) != null) {
                stringArray = structuredViewer.getFilters();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String filter = stringArray[n];
                    this.fViewer.addFilter((ViewerFilter)filter);
                    ++n;
                }
            }
            this.fDetailPaneComposite = SWTFactory.createComposite((Composite)this.fSashForm, 1, 1, 1808);
            Layout layout = this.fDetailPaneComposite.getLayout();
            if (layout instanceof GridLayout) {
                GridLayout gl = (GridLayout)layout;
                gl.marginHeight = 0;
                gl.marginWidth = 0;
            }
            this.fDetailPane = new DetailPaneProxy(new DetailPaneContainer());
            this.fDetailPane.display(null);
            this.fTree = this.fViewer.getTree();
            this.fTree.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ExpressionInformationControl.this.fDetailPane.display((IStructuredSelection)ExpressionInformationControl.this.fViewer.getStructuredSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.initSashWeights();
            this.fViewer.addViewerUpdateListener(new IViewerUpdateListener(){

                @Override
                public void viewerUpdatesComplete() {
                }

                @Override
                public void viewerUpdatesBegin() {
                }

                @Override
                public void updateStarted(IViewerUpdate update) {
                }

                @Override
                public void updateComplete(IViewerUpdate update) {
                    if (update instanceof IChildrenUpdate) {
                        TreeSelection selection = new TreeSelection(new TreePath(new Object[]{ExpressionInformationControl.this.fVariable}));
                        ExpressionInformationControl.this.fViewer.setSelection((ISelection)selection);
                        ExpressionInformationControl.this.fDetailPane.display((IStructuredSelection)selection);
                        ExpressionInformationControl.this.fViewer.removeViewerUpdateListener(this);
                    }
                }
            });
            this.setForegroundColor(this.getShell().getDisplay().getSystemColor(28));
            this.setBackgroundColor(this.getShell().getDisplay().getSystemColor(29));
        }

        private AbstractDebugView getViewToEmulate() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            AbstractDebugView expressionsView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.ExpressionView");
            if (expressionsView != null && expressionsView.isVisible()) {
                return expressionsView;
            }
            AbstractDebugView variablesView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.VariableView");
            if (variablesView != null && variablesView.isVisible()) {
                return variablesView;
            }
            if (expressionsView != null) {
                return expressionsView;
            }
            return variablesView;
        }

        protected void initSashWeights() {
            int details;
            int tree;
            IDialogSettings settings = this.getDialogSettings(false);
            if (settings != null && (tree = this.getIntSetting(settings, SASH_WEIGHT_TREE)) > 0 && (details = this.getIntSetting(settings, SASH_WEIGHT_DETAILS)) > 0) {
                this.fSashForm.setWeights(new int[]{tree, details});
            }
        }

        public void setForegroundColor(Color foreground) {
            super.setForegroundColor(foreground);
            this.fDetailPaneComposite.setForeground(foreground);
            this.fTree.setForeground(foreground);
        }

        public void setBackgroundColor(Color background) {
            super.setBackgroundColor(background);
            this.fDetailPaneComposite.setBackground(background);
            this.fTree.setBackground(background);
        }

        public void setFocus() {
            super.setFocus();
            this.fTree.setFocus();
        }

        public boolean hasContents() {
            return this.fVariable != null;
        }

        public void setInput(Object input) {
            if (input instanceof IVariable) {
                this.fVariable = (IVariable)input;
                this.fViewer.setInput(new TreeRoot());
            }
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return new ExpressionInformationControlCreator(){

                @Override
                public IInformationControl createInformationControl(Shell shell) {
                    return new ExpressionInformationControl(shell, true);
                }
            };
        }

        private class DetailPaneContainer
        implements IDetailPaneContainer {
            private DetailPaneContainer() {
            }

            @Override
            public String getCurrentPaneID() {
                return ExpressionInformationControl.this.fDetailPane.getCurrentPaneID();
            }

            @Override
            public IStructuredSelection getCurrentSelection() {
                return ExpressionInformationControl.this.fViewer.getStructuredSelection();
            }

            @Override
            public void refreshDetailPaneContents() {
                ExpressionInformationControl.this.fDetailPane.display(this.getCurrentSelection());
            }

            @Override
            public Composite getParentComposite() {
                return ExpressionInformationControl.this.fDetailPaneComposite;
            }

            @Override
            public IWorkbenchPartSite getWorkbenchPartSite() {
                return null;
            }

            @Override
            public void paneChanged(String newPaneID) {
                if (newPaneID.equals(DefaultDetailPane.ID)) {
                    ExpressionInformationControl.this.fDetailPane.getCurrentControl().setForeground(ExpressionInformationControl.this.getShell().getDisplay().getSystemColor(28));
                    ExpressionInformationControl.this.fDetailPane.getCurrentControl().setBackground(ExpressionInformationControl.this.getShell().getDisplay().getSystemColor(29));
                }
            }
        }

        private class TreeRoot
        extends ElementContentProvider {
            private TreeRoot() {
            }

            @Override
            protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
                return 1;
            }

            @Override
            protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
                return new Object[]{ExpressionInformationControl.this.fVariable};
            }

            @Override
            protected boolean supportsContextId(String id) {
                return true;
            }
        }
    }
}

