/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.script.impl;

import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.IEclAwareProcessor;
import org.eclipse.rcptt.core.ecl.context.EclContext;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;

public class EclContextProcessor
implements IContextProcessor,
IEclAwareProcessor {
    private boolean applied = false;

    public Context create(EObject param) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void apply(Context context, final ISession session) throws CoreException {
        final EclContext eclContext = (EclContext)context;
        final Exception[] resultE = new Exception[1];
        final Boolean[] finished = new Boolean[]{false};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        session.execute((Command)TeslaFactory.eINSTANCE.createSetupPlayer()).waitFor();
                        Script eclScript = eclContext.getScript() != null ? (Script)EcoreUtil.copy((EObject)eclContext.getScript()) : null;
                        IStatus status = session.execute((Command)eclScript).waitFor();
                        if (!status.isOK() && status instanceof ScriptErrorStatus) {
                            ScriptErrorStatus st = (ScriptErrorStatus)status;
                            String msg = st.getCause().getMessage() + "\nWhile executing context " + eclContext.getName() + " at line:" + st.getLine();
                            ScriptErrorStatus sse = new ScriptErrorStatus(st.getPlugin(), msg, st.getResource(), st.getLine(), st.getColumn(), st.getLength());
                            sse.add(st.getCause());
                            resultE[0] = new CoreException((IStatus)sse);
                        } else if (!status.isOK()) {
                            resultE[0] = new CoreException(status);
                        }
                    }
                    catch (Exception e) {
                        resultE[0] = new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Failed to launch ECL context", (Throwable)e));
                        finished[0] = true;
                        try {
                            IProcess process = session.execute((Command)TeslaFactory.eINSTANCE.createShoutdownPlayer());
                            process.waitFor();
                        }
                        catch (Exception e2) {
                            resultE[0] = new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Failed to launch ECL context", (Throwable)e2));
                        }
                    }
                }
                finally {
                    finished[0] = true;
                    try {
                        IProcess process = session.execute((Command)TeslaFactory.eINSTANCE.createShoutdownPlayer());
                        process.waitFor();
                    }
                    catch (Exception e) {
                        resultE[0] = new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Failed to launch ECL context", (Throwable)e));
                    }
                }
            }
        };
        Thread t = new Thread(r, "ECL Context apply");
        t.start();
        try {
            t.join(TeslaLimits.getContextRunnableTimeout());
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
        if (!finished[0].booleanValue()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Timeout exceeded during Ecl context execution..."));
        }
        if (resultE[0] != null) {
            if (!(resultE[0] instanceof CoreException)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script.impl", resultE[0].getMessage(), (Throwable)resultE[0]));
            }
            throw (CoreException)resultE[0];
        }
        this.applied = true;
    }

    public void apply(Context context, BooleanSupplier isCancelled) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script.impl", "EclContextProcessor is ECL-aware and must be passed a session object", null));
    }

    public boolean isApplied(Context context) {
        return this.applied;
    }
}

