/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MappedList<K, V> {
    protected final HashMap<K, List<V>> internal = new HashMap();
    protected final List<V> empty = Collections.emptyList();

    public void put(K key, V value) {
        List<V> existing = this.internal.get(key);
        if (existing == null) {
            existing = new ArrayList<V>(1);
            existing.add(value);
            this.internal.put(key, existing);
            return;
        }
        int index = this.insertionIndex(existing, value);
        existing.add(index, value);
    }

    protected int insertionIndex(List<V> existing, V value) {
        return existing.size();
    }

    public List<V> remove(K key) {
        return this.get(key, true);
    }

    public List<V> get(K key) {
        return this.get(key, false);
    }

    private List<V> get(K key, boolean remove) {
        List<V> result = remove ? this.internal.remove(key) : this.internal.get(key);
        return result == null ? this.empty : result;
    }

    public int getSize() {
        return this.internal.size();
    }

    public List<V> getAllValues() {
        if (this.getSize() == 0) {
            return this.empty;
        }
        ArrayList<V> results = new ArrayList<V>(this.getSize());
        for (List<V> element : this.internal.values()) {
            results.addAll(element);
        }
        return results;
    }

    public void clear() {
        this.internal.clear();
    }
}

