/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.equinox.LicensedApplication;
import org.eclipse.passage.lic.equinox.access.ConsoleInteraction;
import org.eclipse.passage.lic.equinox.access.Interaction;
import org.eclipse.passage.lic.equinox.access.LicenseCoverageCheck;

final class LicenseProtection {
    private final Logger log = LogManager.getLogger(this.getClass());
    private Optional<GrantLockAttempt> lock = Optional.empty();

    LicenseProtection() {
    }

    boolean check() {
        if (this.licenseCoverageIsNotSufficient()) {
            return false;
        }
        return this.locAcquired();
    }

    private boolean locAcquired() {
        Optional<GrantLockAttempt> attempt = this.acquireLicense();
        if (!attempt.isPresent()) {
            return false;
        }
        if (!attempt.get().successful()) {
            return false;
        }
        this.lock = attempt;
        return true;
    }

    private boolean licenseCoverageIsNotSufficient() {
        return !LicenseCoverageCheck.Result.proceed.equals((Object)new LicenseCoverageCheck((Interaction)new ConsoleInteraction()).run());
    }

    void release() {
        this.lock.ifPresent(acq -> {
            ServiceInvocationResult serviceInvocationResult = new EquinoxPassage().releaseLicense(acq);
        });
    }

    private Optional<GrantLockAttempt> acquireLicense() {
        return this.product().flatMap(this::acquireLicense);
    }

    private Optional<LicensedProduct> product() {
        try {
            return Optional.of(new LicensedApplication().product());
        }
        catch (LicensingException e) {
            this.log.error("Failed to read product credentials", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<GrantLockAttempt> acquireLicense(LicensedProduct product) {
        ServiceInvocationResult response = new EquinoxPassage().acquireLicense(product.identifier());
        if (!this.successful((ServiceInvocationResult<GrantLockAttempt>)response)) {
            this.log.error(String.format("Failed to acquire license \nfor product %s:\n%s\n", product, new DiagnosticExplained(response.diagnostic()).get()));
            return Optional.empty();
        }
        return Optional.of((GrantLockAttempt)response.data().get());
    }

    private boolean successful(ServiceInvocationResult<GrantLockAttempt> response) {
        return response.data().map(GrantLockAttempt::successful).orElse(Boolean.FALSE);
    }
}

