/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFile {
    private final File file;

    public PropertyFile(File file) {
        this.file = file;
    }

    public String getProperty(String key, String defaultValue) {
        Map<String, String> properties = this.loadProperties();
        String value = properties.get(key);
        return value == null ? defaultValue : value;
    }

    public void setProperty(String key, String value) {
        Map<String, String> properties = this.loadProperties();
        this.addAndSaveProperty(properties, key, value);
    }

    public boolean compareAndSetProperty(String key, String value, String ... expectedValues) {
        Map<String, String> properties = this.loadProperties();
        String existingValue = properties.get(key);
        if (expectedValues.length == 0) {
            if (ObjectUtil.equals(existingValue, null)) {
                this.addAndSaveProperty(properties, key, value);
                return true;
            }
        } else {
            String[] stringArray = expectedValues;
            int n = expectedValues.length;
            int n2 = 0;
            while (n2 < n) {
                String expectedValue = stringArray[n2];
                if (ObjectUtil.equals(existingValue, expectedValue)) {
                    this.addAndSaveProperty(properties, key, value);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void removeProperty(String key) {
        Map<String, String> properties = this.loadProperties();
        if (properties.remove(key) != null) {
            this.saveProperties(properties);
        }
    }

    public Map<String, String> loadProperties() {
        try {
            if (this.file.exists()) {
                return PropertiesUtil.loadProperties(this.file);
            }
        }
        catch (RuntimeException runtimeException) {}
        return new LinkedHashMap<String, String>();
    }

    public void saveProperties(Map<String, String> properties) {
        try {
            PropertiesUtil.saveProperties(this.file, properties, true);
        }
        catch (RuntimeException ex) {
            UtilPlugin.INSTANCE.log(ex);
        }
    }

    private void addAndSaveProperty(Map<String, String> properties, String key, String value) {
        properties.put(key, value.toString());
        this.saveProperties(properties);
    }
}

