/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.core;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class P2Util {
    private P2Util() {
    }

    public static synchronized AgentManager getAgentManager() {
        if (AgentManagerImpl.instance == null) {
            AgentManagerImpl.instance = new AgentManagerImpl();
        }
        return AgentManagerImpl.instance;
    }

    public static File getAgentLocation(IProvisioningAgent agent) {
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        return URIUtil.toFile((URI)location.getRootLocation());
    }

    public static IProvisioningAgent getCurrentProvisioningAgent() {
        return P2Util.getAgentManager().getCurrentAgent().getProvisioningAgent();
    }

    public static Agent createAgent(File agentLocation) {
        return new AgentImpl((AgentManagerImpl)P2Util.getAgentManager(), agentLocation);
    }

    public static Set<String> getKnownRepositories(IRepositoryManager<?> manager) {
        HashSet<String> result = new HashSet<String>();
        URI[] uRIArray = manager.getKnownRepositories(2);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            result.add(uri.toString());
            ++n2;
        }
        return result;
    }

    public static File getCacheFile(URI uri) {
        CachingTransport transport;
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
        if (manager instanceof CachingRepositoryManager && (transport = ((CachingRepositoryManager)manager).getTransport()) != null) {
            return transport.getCacheFile(uri);
        }
        return null;
    }

    public static <T> Iterable<T> asIterable(final IQueryResult<T> queryResult) {
        if (queryResult instanceof Iterable) {
            return (Iterable)Iterable.class.cast(queryResult);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return queryResult.iterator();
            }
        };
    }

    public static boolean isSimpleRequiredCapability(IRequirement requirement) {
        return requirement instanceof IRequiredCapability;
    }

    public static String getName(IInstallableUnit iu) {
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (StringUtil.isEmpty((String)name)) {
            return iu.getId();
        }
        return name;
    }

    private static MetadataFactory.InstallableUnitDescription createDescription(IInstallableUnit iu) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId(iu.getId());
        description.setVersion(iu.getVersion());
        Collection artifacts = iu.getArtifacts();
        description.setArtifacts(artifacts.toArray(new IArtifactKey[artifacts.size()]));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        description.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        description.setCopyright(iu.getCopyright());
        IMatchExpression filter = iu.getFilter();
        description.setFilter(filter);
        Collection licenses = iu.getLicenses();
        description.setLicenses(licenses.toArray(new ILicense[licenses.size()]));
        Collection metaRequirements = iu.getMetaRequirements();
        description.setMetaRequirements(metaRequirements.toArray(new IRequirement[metaRequirements.size()]));
        Collection requirements = iu.getRequirements();
        description.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
        description.setSingleton(iu.isSingleton());
        description.setTouchpointType(iu.getTouchpointType());
        description.setUpdateDescriptor(iu.getUpdateDescriptor());
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            description.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (ITouchpointData touchpointData : iu.getTouchpointData()) {
            description.addTouchpointData(touchpointData);
        }
        return description;
    }

    public static interface VersionedIdFilter {
        public boolean matches(IVersionedId var1);
    }
}

