/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class ErrorInfo
extends JobTreeElement {
    private final IStatus errorStatus;
    private final Job job;
    private final long timestamp;

    public ErrorInfo(IStatus status, Job job) {
        this.errorStatus = status;
        this.job = job;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    boolean hasChildren() {
        return false;
    }

    @Override
    Object[] getChildren() {
        return ProgressManagerUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    String getDisplayString() {
        return NLS.bind((String)ProgressMessages.JobInfo_Error, (Object[])new Object[]{this.job.getName(), DateFormat.getDateTimeInstance((int)1, (int)1).format(new Date(this.timestamp))});
    }

    Image getImage() {
        return JFaceResources.getImage((String)"ERROR_JOB");
    }

    @Override
    boolean isJobInfo() {
        return false;
    }

    IStatus getErrorStatus() {
        return this.errorStatus;
    }

    @Override
    boolean isActive() {
        return true;
    }

    public Job getJob() {
        return this.job;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(JobTreeElement other) {
        if (other instanceof ErrorInfo) {
            return Long.compare(this.timestamp, ((ErrorInfo)other).timestamp);
        }
        return super.compareTo(other);
    }
}

