/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.urischeme.internal.registration.Util;

public class DesktopFileWriter {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String EQUAL_SIGN = "=";
    private static final String KEY_MIME_TYPE = "MimeType";
    private static final String KEY_EXEC = "Exec";
    private static final String EXEC_URI_PLACEHOLDER = " %u";
    private Map<String, String> properties;

    public DesktopFileWriter(List<String> lines) {
        this.properties = this.getProperties(lines);
    }

    public boolean isRegistered(String scheme) {
        Util.assertUriSchemeIsLegal(scheme);
        String mimeType = this.properties.get(KEY_MIME_TYPE);
        if (mimeType == null || mimeType.isEmpty()) {
            return false;
        }
        return mimeType.contains(this.getHandlerPlusScheme(scheme));
    }

    public void addScheme(String scheme) {
        Util.assertUriSchemeIsLegal(scheme);
        String handlerPlusScheme = this.getHandlerPlusScheme(scheme);
        if (this.properties.containsKey(KEY_MIME_TYPE)) {
            Object mimeType = this.properties.get(KEY_MIME_TYPE);
            if (!((String)mimeType).contains(handlerPlusScheme)) {
                mimeType = (String)mimeType + handlerPlusScheme;
                this.properties.put(KEY_MIME_TYPE, (String)mimeType);
            }
        } else {
            this.properties.put(KEY_MIME_TYPE, handlerPlusScheme);
        }
    }

    public void removeScheme(String scheme) {
        Util.assertUriSchemeIsLegal(scheme);
        if (this.properties.containsKey(KEY_MIME_TYPE)) {
            String handlerPlusScheme = this.getHandlerPlusScheme(scheme);
            String mimeType = this.properties.get(KEY_MIME_TYPE);
            if ((mimeType = mimeType.replace(handlerPlusScheme, "")).isEmpty()) {
                this.properties.remove(KEY_MIME_TYPE);
            } else {
                this.properties.put(KEY_MIME_TYPE, mimeType);
            }
        }
    }

    public byte[] getResult() {
        this.addUriPlaceholderToExecProperty();
        Function<Map.Entry, String> toList = e -> {
            if (e.getValue() == null) {
                return (String)e.getKey();
            }
            return String.join((CharSequence)EQUAL_SIGN, (CharSequence)e.getKey(), (CharSequence)e.getValue());
        };
        String result = this.properties.entrySet().stream().map(toList).collect(Collectors.joining(LINE_SEPARATOR));
        return result.getBytes();
    }

    public static List<String> getMinimalDesktopFileContent(String eclipseExecutableLocation, String productName) {
        if (eclipseExecutableLocation == null || eclipseExecutableLocation.isEmpty()) {
            return Collections.emptyList();
        }
        String executable = DesktopFileWriter.escapeSpaces(eclipseExecutableLocation);
        return Arrays.asList("[Desktop Entry]", "Name=" + productName, "Exec=" + executable, "NoDisplay=true", "Type=Application");
    }

    private static String escapeSpaces(String path) {
        return path.replace(" ", "\\ ");
    }

    private static String unescapeSpaces(String path) {
        return path.replace("\\ ", " ");
    }

    private void addUriPlaceholderToExecProperty() {
        String execValue;
        if (this.properties.containsKey(KEY_EXEC) && !(execValue = this.properties.get(KEY_EXEC)).contains(EXEC_URI_PLACEHOLDER)) {
            this.properties.put(KEY_EXEC, execValue + EXEC_URI_PLACEHOLDER);
        }
    }

    private Map<String, String> getProperties(List<String> lines) {
        this.assertLinesNotEmpty(lines);
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (String line : lines) {
            if (line.contains(EQUAL_SIGN)) {
                String[] split = line.split(EQUAL_SIGN);
                props.put(split[0], split[1]);
                continue;
            }
            props.put(line, null);
        }
        this.assertDesktopEntryPresent(props);
        return props;
    }

    private void assertDesktopEntryPresent(Map<String, String> props) {
        Iterator<Map.Entry<String, String>> iterator = props.entrySet().iterator();
        String firstLine = iterator.next().getKey();
        if (!"[Desktop Entry]".equals(firstLine)) {
            throw new IllegalStateException("File seems not to be a 'desktop' file");
        }
    }

    private void assertLinesNotEmpty(List<?> lines) {
        if (lines.isEmpty()) {
            throw new IllegalStateException("inputStream is empty");
        }
    }

    private String getHandlerPlusScheme(String scheme) {
        return "x-scheme-handler/" + scheme + ";";
    }

    public String getExecutableLocation() {
        String executableLocation = this.properties.get(KEY_EXEC);
        executableLocation = executableLocation.replace(EXEC_URI_PLACEHOLDER, "");
        return DesktopFileWriter.unescapeSpaces(executableLocation);
    }
}

