/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.ide.IUnassociatedEditorStrategy;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class UnassociatedEditorStrategyRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.ide.unassociatedEditorStrategy";
    private static Map<String, String> idsToLabel;

    public IUnassociatedEditorStrategy getStrategy(String strategyId) {
        if (strategyId == null) {
            return null;
        }
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = extRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (extensions != null) {
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                if (strategyId.equals(this.readAttribute(extension, "id"))) {
                    try {
                        return (IUnassociatedEditorStrategy)extension.createExecutableExtension("class");
                    }
                    catch (CoreException ex) {
                        IDEWorkbenchPlugin.log(ex.getMessage(), ex);
                        return null;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private String readAttribute(IConfigurationElement extension, String attribute) {
        String res = extension.getAttribute(attribute);
        if (res == null) {
            IDEWorkbenchPlugin.log("Missing attribute '" + attribute + "' for extension to org.eclipse.ui.ide.unassociatedEditorStrategy contributed by " + String.valueOf(extension.getContributor()));
        }
        return res;
    }

    public Set<String> retrieveAllStrategies() {
        this.populateIdsToLabel();
        return Collections.unmodifiableSet(idsToLabel.keySet());
    }

    public String getLabel(String id) {
        if (idsToLabel == null || !idsToLabel.containsKey(id)) {
            this.populateIdsToLabel();
        }
        return idsToLabel.get(id);
    }

    private void populateIdsToLabel() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = extRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (extensions != null) {
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                String extId = this.readAttribute(extension, "id");
                String label = this.readAttribute(extension, "label");
                if (extId != null && label != null) {
                    res.put(extId, label);
                }
                ++n2;
            }
        }
        idsToLabel = res;
    }

    public boolean isInteractive(String strategyId) {
        if (strategyId == null) {
            return false;
        }
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = extRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (extensions != null) {
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                if (strategyId.equals(this.readAttribute(extension, "id"))) {
                    return Boolean.parseBoolean(this.readAttribute(extension, "interactive"));
                }
                ++n2;
            }
        }
        IDEWorkbenchPlugin.log("No editor strategy found for " + strategyId);
        return false;
    }
}

