/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.util.PreferencesRecorder;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.impl.PreferenceTaskImpl;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerJob;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.setup.sync.SyncActionType;
import org.eclipse.oomph.setup.sync.SyncDelta;
import org.eclipse.oomph.setup.sync.SyncPolicy;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.Messages;
import org.eclipse.oomph.setup.ui.recorder.PreferenceInitializationDialog;
import org.eclipse.oomph.setup.ui.recorder.RecorderPreferencePage;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.setup.ui.synchronizer.OptOutDialog;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerDialog;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.ui.ButtonAnimator;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.util.ProtocolException;

public final class RecorderManager {
    public static final RecorderManager INSTANCE = new RecorderManager();
    private static final IPersistentPreferenceStore SETUP_UI_PREFERENCES = (IPersistentPreferenceStore)SetupUIPlugin.INSTANCE.getPreferenceStore();
    private static final UserCallback USER_CALLBACK = new UserCallback(){

        public void execInUI(boolean async, Runnable runnable) {
            UIUtil.syncExec((Runnable)runnable);
        }
    };
    private static final URI USER_URI = SetupContext.USER_SETUP_URI.appendFragment("/");
    private static final URI USER_FILE_URI = SetupContext.resolve((URI)SetupCoreUtil.createResourceSet().getURIConverter().normalize(SetupContext.USER_SETUP_URI));
    private static final boolean SYNC_FOLDER_FIXED = PropertiesUtil.isProperty((String)"oomph.setup.sync.folder.fixed");
    private static final boolean SYNC_FOLDER_KEEP = PropertiesUtil.isProperty((String)"oomph.setup.sync.folder.keep");
    private static final boolean SYNC_FOLDER_DEBUG = PropertiesUtil.isProperty((String)"oomph.setup.sync.folder.debug");
    private final EarlySynchronization earlySynchronization = new EarlySynchronization();
    private static ToolItem recordItem;
    private static ToolItem initializeItem;
    private final DisplayListener displayListener = new DisplayListener();
    private Display display;
    private PreferencesRecorder recorder;
    private IEditorPart editor;
    private URI temporaryRecorderTarget;
    private Runnable reset;

    private RecorderManager() {
    }

    public void record(IEditorPart editor) {
        this.editor = editor;
        final boolean wasEnabled = this.isRecorderEnabled();
        this.setRecorderEnabled(true);
        this.reset = new Runnable(){

            @Override
            public void run() {
                RecorderManager.this.editor = null;
                RecorderManager.this.setRecorderEnabled(wasEnabled);
                RecorderManager.this.reset = null;
            }
        };
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, null, null, null);
        dialog.open();
    }

    public void done() {
        this.setTemporaryRecorderTarget(null);
        if (this.reset != null) {
            this.reset.run();
        }
    }

    public boolean isRecorderEnabled() {
        String value = SETUP_UI_PREFERENCES.getString("enable.preference.recorder");
        if (StringUtil.isEmpty((String)value)) {
            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
            SetupContext setupContext = SetupContext.createUserOnly((ResourceSet)resourceSet);
            User user = setupContext.getUser();
            boolean enabled = user.isPreferenceRecorderDefault();
            this.doSetRecorderEnabled(enabled);
            return enabled;
        }
        return Boolean.parseBoolean(value);
    }

    public void setRecorderEnabled(boolean enabled) {
        if (this.isRecorderEnabled() != enabled) {
            try {
                this.doSetRecorderEnabled(enabled);
            }
            finally {
                if (enabled) {
                    if (this.recorder == null) {
                        this.recorder = new PreferencesRecorder();
                    }
                    this.startEarlySynchronization(false);
                } else {
                    this.cancelRecording();
                }
            }
        }
    }

    public Set<String> getInitializedPreferencePages() {
        return this.getIDs("initialized.preference.pages");
    }

    public void setInitializedPreferencePages(Set<String> ids) {
        this.setIDs("initialized.preference.pages", ids);
    }

    public Set<String> getIgnoredPreferencePages() {
        return this.getIDs("ingored.preference.pages");
    }

    public void setIgnoredPreferencePages(Set<String> ids) {
        this.setIDs("ingored.preference.pages", ids);
    }

    private Set<String> getIDs(String key) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String value = SETUP_UI_PREFERENCES.getString(key);
        if (!StringUtil.isEmpty((String)value)) {
            String[] stringArray = value.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                result.add(id);
                ++n2;
            }
        }
        return result;
    }

    private void setIDs(String key, Set<String> ids) {
        StringBuilder result = new StringBuilder();
        for (String id : ids) {
            if (result.length() != 0) {
                result.append(' ');
            }
            result.append(id);
        }
        SETUP_UI_PREFERENCES.setValue(key, result.toString());
        try {
            SETUP_UI_PREFERENCES.save();
        }
        catch (IOException ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
    }

    public void cancelRecording() {
        if (this.recorder != null) {
            this.recorder.done();
            this.recorder = null;
        }
        this.earlySynchronization.stop();
    }

    private void doSetRecorderEnabled(boolean enabled) {
        SETUP_UI_PREFERENCES.setValue("enable.preference.recorder", Boolean.toString(enabled));
        try {
            SETUP_UI_PREFERENCES.save();
        }
        catch (IOException ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
    }

    public Scope getRecorderTargetObject(ResourceSet resourceSet) {
        URI recorderTarget = this.getRecorderTarget();
        return (Scope)resourceSet.getEObject(recorderTarget, true);
    }

    public Scope getRecorderTargetObject() {
        ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
        return this.getRecorderTargetObject(resourceSet);
    }

    public URI getRecorderTarget() {
        if (this.temporaryRecorderTarget != null) {
            return this.temporaryRecorderTarget;
        }
        String value = SETUP_UI_PREFERENCES.getString("preference.recorder.target");
        if (StringUtil.isEmpty((String)value)) {
            return USER_URI;
        }
        URI uri = URI.createURI((String)value);
        return RecorderManager.convertURI(uri);
    }

    public URI setRecorderTarget(URI uri) {
        uri = RecorderManager.convertURI(uri);
        URI oldURI = this.getRecorderTarget();
        if (!ObjectUtil.equals((Object)oldURI, (Object)uri)) {
            SETUP_UI_PREFERENCES.setValue("preference.recorder.target", uri.toString());
            try {
                SETUP_UI_PREFERENCES.save();
            }
            catch (IOException ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
            return oldURI;
        }
        return null;
    }

    public void setTemporaryRecorderTarget(URI temporaryRecorderTarget) {
        this.temporaryRecorderTarget = temporaryRecorderTarget;
    }

    public boolean hasTemporaryRecorderTarget() {
        return this.temporaryRecorderTarget != null;
    }

    public boolean startEarlySynchronization(boolean interactive) {
        return this.earlySynchronization.start(interactive);
    }

    private SyncInfo awaitEarlySynchronization() {
        Scope recorderTarget;
        SyncInfo syncInfo = this.earlySynchronization.await();
        if (syncInfo != null && (recorderTarget = this.getRecorderTargetObject()) instanceof User) {
            return syncInfo;
        }
        return null;
    }

    private void handleRecording(IEditorPart editorPart, Map<URI, Pair<String, String>> values) {
        block42: {
            try {
                if (SynchronizerManager.Availability.AVAILABLE) {
                    SynchronizerManager.INSTANCE.offerFirstTimeConnect(UIUtil.getShell());
                }
                RecorderTransaction transaction = editorPart == null ? RecorderTransaction.open() : RecorderTransaction.open(editorPart);
                transaction.setPreferences(values);
                boolean started = this.startEarlySynchronization(true);
                SyncInfo syncInfo = started ? this.awaitEarlySynchronization() : null;
                Synchronization synchronization = syncInfo == null ? null : syncInfo.getSynchronization();
                boolean dialogNeeded = false;
                Set<URI> preferenceURIs = transaction.getPreferences().keySet();
                Iterator<URI> it = preferenceURIs.iterator();
                while (it.hasNext()) {
                    Boolean localPolicy;
                    URI uri = it.next();
                    String key = PreferencesFactory.eINSTANCE.convertURI(uri);
                    if (synchronization != null) {
                        String syncID = (String)synchronization.getPreferenceIDs().get(key);
                        SyncPolicy remotePolicy = (SyncPolicy)synchronization.getRemotePolicies().get((Object)syncID);
                        if (remotePolicy == SyncPolicy.INCLUDE) {
                            transaction.setPolicy(key, true);
                        }
                    }
                    if ((localPolicy = transaction.getPolicy(key)) == null) {
                        PreferenceTaskImpl.PreferenceHandler handler = PreferenceTaskImpl.PreferenceHandler.getHandler((URI)uri);
                        if (handler.isIgnored()) {
                            it.remove();
                            continue;
                        }
                        transaction.setPolicy(key, true);
                        dialogNeeded = true;
                        continue;
                    }
                    if (localPolicy.booleanValue()) continue;
                    it.remove();
                }
                if (synchronization != null) {
                    try {
                        HashMap<String, SynchronizerDialog.PolicyAndValue> preferenceChanges = new HashMap<String, SynchronizerDialog.PolicyAndValue>();
                        for (URI uri : preferenceURIs) {
                            String key = PreferencesFactory.eINSTANCE.convertURI(uri);
                            if (transaction.getPolicy(key).booleanValue()) {
                                String value = (String)transaction.getPreferences().get(uri).getElement2();
                                preferenceChanges.put(key, new SynchronizerDialog.PolicyAndValue(value));
                                continue;
                            }
                            preferenceChanges.put(key, new SynchronizerDialog.PolicyAndValue());
                        }
                        Set<String> preferenceKeys = SynchronizerDialog.adjustLocalSnapshot(synchronization, preferenceChanges);
                        Map syncActions = synchronization.synchronizeLocal();
                        for (SyncAction syncAction : syncActions.values()) {
                            Map.Entry preference;
                            if (syncAction.getComputedType() != SyncActionType.CONFLICT || (preference = syncAction.getPreference()) == null || !preferenceKeys.contains(preference.getKey())) continue;
                            dialogNeeded = true;
                            break;
                        }
                    }
                    catch (IOException ex) {
                        SetupUIPlugin.INSTANCE.log(ex, 2);
                    }
                }
                if (dialogNeeded && !this.openSynchronizerDialog(transaction, synchronization)) {
                    transaction.close();
                    return;
                }
                if (synchronization != null) {
                    final Map preferenceIDs = synchronization.getPreferenceIDs();
                    transaction.setCommitHandler(new RecorderTransaction.CommitHandler(){

                        @Override
                        public void handlePreferenceTask(PreferenceTask preferenceTask) {
                            String key = preferenceTask.getKey();
                            String syncID = (String)preferenceIDs.get(key);
                            if (syncID != null) {
                                preferenceTask.setID(syncID);
                            }
                        }
                    });
                }
                try {
                    transaction.commit();
                }
                finally {
                    transaction.close();
                }
                if (synchronization == null) break block42;
                Scope recorderTarget = syncInfo.getRecorderTarget();
                File tmpFolder = syncInfo.getTmpFolder();
                if (!dialogNeeded) {
                    EMap remotePolicies = synchronization.getRemotePolicies();
                    boolean remotePoliciesMissing = false;
                    Iterator<PreferenceTask> it2 = transaction.getCommitResult().values().iterator();
                    while (it2.hasNext()) {
                        PreferenceTask preferenceTask = it2.next();
                        String taskID = preferenceTask.getID();
                        if (taskID != null) {
                            SyncPolicy remotePolicy = (SyncPolicy)remotePolicies.get((Object)taskID);
                            if (remotePolicy == null) {
                                remotePoliciesMissing = true;
                                continue;
                            }
                            if (remotePolicy != SyncPolicy.EXCLUDE) continue;
                            it2.remove();
                            continue;
                        }
                        it2.remove();
                    }
                    RecorderManager.copyRecorderTarget(recorderTarget, tmpFolder);
                    if (remotePoliciesMissing) {
                        if (!this.openSynchronizerDialog(transaction, synchronization)) {
                            return;
                        }
                    } else {
                        try {
                            Map syncActions = synchronization.synchronizeLocal();
                            Map preferenceIDs = synchronization.getPreferenceIDs();
                            Iterator it3 = syncActions.entrySet().iterator();
                            block23: while (it3.hasNext()) {
                                Map.Entry entry = it3.next();
                                String syncID = (String)entry.getKey();
                                SyncAction syncAction = (SyncAction)entry.getValue();
                                SyncPolicy remotePolicy = (SyncPolicy)remotePolicies.get((Object)syncID);
                                if (remotePolicy == SyncPolicy.EXCLUDE) {
                                    it3.remove();
                                    continue;
                                }
                                SyncActionType type = syncAction.getComputedType();
                                switch (type) {
                                    case NONE: 
                                    case SET_REMOTE: 
                                    case REMOVE_REMOTE: 
                                    case CONFLICT: 
                                    case EXCLUDE: {
                                        it3.remove();
                                        break;
                                    }
                                    default: {
                                        Map.Entry preference = syncAction.getPreference();
                                        if (preference != null && preferenceIDs.containsKey(preference.getKey())) continue block23;
                                        it3.remove();
                                    }
                                }
                            }
                        }
                        catch (IOException ex) {
                            SetupUIPlugin.INSTANCE.log(ex, 2);
                            ErrorDialog.open((Throwable)ex);
                            this.earlySynchronization.stop();
                            return;
                        }
                    }
                }
                try {
                    this.applyRemotePreferenceChanges(synchronization);
                    synchronization.commit();
                    Synchronizer synchronizer = synchronization.getSynchronizer();
                    synchronizer.copyFilesTo(SynchronizerManager.SYNC_FOLDER);
                    RecorderManager.copyRecorderTargetBack(recorderTarget, tmpFolder);
                }
                catch (DataProvider.NotCurrentException ex) {
                    ErrorDialog.open((Throwable)ex);
                }
                catch (IOException ex) {
                    SetupUIPlugin.INSTANCE.log(ex, 2);
                    ErrorDialog.open((Throwable)ex);
                }
            }
            finally {
                this.earlySynchronization.stop();
            }
        }
    }

    private boolean openSynchronizerDialog(final RecorderTransaction transaction, final Synchronization synchronization) {
        final boolean[] ok = new boolean[]{true};
        UIUtil.syncExec((Display)this.display, (Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = UIUtil.getShell();
                SynchronizerDialog dialog = new SynchronizerDialog(shell, transaction, synchronization);
                int result = dialog.open();
                if (!dialog.isEnableRecorder()) {
                    RecorderManager.this.setRecorderEnabled(false);
                    ok[0] = false;
                } else if (result != 0) {
                    ok[0] = false;
                }
            }
        });
        return ok[0];
    }

    private void applyRemotePreferenceChanges(Synchronization synchronization) {
        Map syncActions = synchronization.getActions();
        if (syncActions != null) {
            for (SyncAction syncAction : syncActions.values()) {
                SyncDelta remoteDelta;
                SetupTask newTask;
                if (syncAction.getEffectiveType() != SyncActionType.SET_REMOTE || !((newTask = (remoteDelta = syncAction.getRemoteDelta()).getNewTask()) instanceof PreferenceTask)) continue;
                PreferenceTask preferenceTask = (PreferenceTask)newTask;
                try {
                    RecorderManager.executePreferenceTask(preferenceTask);
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
            }
        }
    }

    private static URI convertURI(URI uri) {
        URI resourceURI;
        String fragment = uri.fragment();
        if (StringUtil.isEmpty((String)fragment)) {
            fragment = "/";
        }
        if ((resourceURI = uri.trimFragment()).equals(USER_FILE_URI)) {
            resourceURI = SetupContext.USER_SETUP_URI;
        }
        return resourceURI.appendFragment(fragment);
    }

    private static boolean isPreferenceDialog(Shell shell) {
        Object data = shell.getData();
        return data instanceof WorkbenchPreferenceDialog;
    }

    private void hookRecorderToggleButton(final Shell shell) {
        try {
            Control child;
            Composite buttonBar;
            Control[] children;
            final WorkbenchPreferenceDialog dialog = (WorkbenchPreferenceDialog)shell.getData();
            if (dialog.buttonBar instanceof Composite && (children = (buttonBar = (Composite)dialog.buttonBar).getChildren()).length != 0 && (child = children[0]) instanceof ToolBar) {
                final ToolBar toolBar = (ToolBar)child;
                recordItem = new ToolItem(toolBar, 8);
                RecorderManager.updateRecorderToggleButton();
                final PreferenceManager preferenceManager = dialog.getPreferenceManager();
                recordItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean enableRecorder = !RecorderManager.this.isRecorderEnabled();
                        RecorderManager.this.setRecorderEnabled(enableRecorder);
                        RecorderManager.updateRecorderToggleButton();
                        RecorderPreferencePage.updateEnablement();
                        if (enableRecorder) {
                            if (SynchronizerManager.Availability.AVAILABLE) {
                                boolean firstTime = SynchronizerManager.INSTANCE.offerFirstTimeConnect(shell);
                                RecorderManager.this.startEarlySynchronization(firstTime);
                            }
                            RecorderManager.this.createInitializeItem(shell, toolBar, dialog, preferenceManager);
                            buttonBar.layout();
                        } else if (initializeItem != null) {
                            initializeItem.dispose();
                        }
                    }
                });
                recordItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        recordItem = null;
                    }
                });
                if (this.isRecorderEnabled()) {
                    this.createInitializeItem(shell, toolBar, dialog, preferenceManager);
                }
                buttonBar.layout();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void disposeInitializeItem() {
        if (initializeItem != null) {
            initializeItem.dispose();
        }
    }

    private void createInitializeItem(Shell shell, ToolBar toolBar, final WorkbenchPreferenceDialog dialog, final PreferenceManager preferenceManager) {
        if (this.hasPreferencePagesToInitialize(preferenceManager)) {
            initializeItem = new ToolItem(toolBar, 8);
            initializeItem.setImage(SetupUIPlugin.INSTANCE.getSWTImage("bulb0.png"));
            initializeItem.setToolTipText(Messages.RecorderManager_initializeItem_tooltip);
            final class Animator
            extends ButtonAnimator {
                private final /* synthetic */ Shell val$shell;

                public Animator(ToolItem toolItem, Shell shell) {
                    this.val$shell = shell;
                    super((OomphUIPlugin)SetupUIPlugin.INSTANCE, toolItem, "bulb.png", 8);
                }

                public Shell getShell() {
                    return this.val$shell;
                }

                protected boolean doAnimate() {
                    return true;
                }
            }
            new Animator(initializeItem, shell).run();
            initializeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new PreferenceInitializationDialog((PreferenceDialog)dialog, preferenceManager).open();
                }
            });
            initializeItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    initializeItem = null;
                }
            });
        }
    }

    private boolean hasPreferencePagesToInitialize(PreferenceManager preferenceManager) {
        Set<String> preferencePages = this.getInitializedPreferencePages();
        preferencePages.addAll(this.getIgnoredPreferencePages());
        List preferenceNodes = preferenceManager.getElements(0);
        for (IPreferenceNode element : preferenceNodes) {
            String id = element.getId();
            if (preferencePages.contains(id)) continue;
            return true;
        }
        return false;
    }

    static void updateRecorderToggleButton() {
        if (recordItem != null) {
            boolean recorderEnabled = INSTANCE.isRecorderEnabled();
            recordItem.setImage(SetupUIPlugin.INSTANCE.getSWTImage("recorder_" + (recorderEnabled ? "enabled" : "disabled") + ".png"));
            recordItem.setToolTipText(recorderEnabled ? Messages.RecorderManager_recordItem_tooltip_recorderEnabledPushToDisable : Messages.RecorderManager_recordItem_tooltip_recorderDisabledPushToEnabled);
        }
    }

    public static boolean executePreferenceTask(PreferenceTask task) throws Exception {
        return ((PreferenceTaskImpl)task).execute(USER_CALLBACK);
    }

    public static File copyRecorderTarget(Scope recorderTarget, File targetFolder) {
        URI uri = RecorderManager.resolveRecorderTargetURI(recorderTarget);
        File source = new File(uri.toFileString());
        File target = new File(targetFolder, uri.lastSegment());
        IOUtil.copyFile((File)source, (File)target);
        if (SYNC_FOLDER_DEBUG) {
            SetupUIPlugin.INSTANCE.log("Copy recorder target to " + String.valueOf(target));
        }
        return target;
    }

    private static File copyRecorderTargetBack(Scope recorderTarget, File targetFolder) {
        URI uri = RecorderManager.resolveRecorderTargetURI(recorderTarget);
        File source = new File(uri.toFileString());
        File target = new File(targetFolder, uri.lastSegment());
        IOUtil.copyFile((File)target, (File)source);
        if (SYNC_FOLDER_DEBUG) {
            SetupUIPlugin.INSTANCE.log("Copy recorder target back to " + String.valueOf(source));
        }
        return target;
    }

    private static URI resolveRecorderTargetURI(Scope recorderTarget) {
        Resource resource = recorderTarget.eResource();
        URIConverter uriConverter = resource.getResourceSet().getURIConverter();
        URI uri = resource.getURI();
        uri = uriConverter.normalize(uri);
        uri = SetupContext.resolve((URI)uri);
        return uri;
    }

    private final class DisplayListener
    implements Listener {
        private boolean stopped;

        private DisplayListener() {
        }

        public void stop() {
            this.stopped = true;
        }

        public void handleEvent(Event event) {
            Shell shell;
            if (this.stopped) {
                return;
            }
            if (event.widget instanceof Shell && RecorderManager.isPreferenceDialog(shell = (Shell)event.widget) && recordItem == null) {
                UIUtil.asyncExec((Display)RecorderManager.this.display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RecorderManager.this.hookRecorderToggleButton(shell);
                    }
                });
                if (RecorderManager.this.isRecorderEnabled()) {
                    RecorderManager.this.recorder = new PreferencesRecorder();
                    RecorderManager.this.startEarlySynchronization(false);
                }
                shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        final PreferencesRecorder finalRecorder = ((DisplayListener)DisplayListener.this).RecorderManager.this.recorder;
                        if (finalRecorder == null) {
                            return;
                        }
                        UIUtil.timerExec((int)100, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                final Map values = finalRecorder.done();
                                ((DisplayListener)(this).DisplayListener.this).RecorderManager.this.recorder = null;
                                Iterator it = values.keySet().iterator();
                                while (it.hasNext()) {
                                    String lastSegment;
                                    URI uri = (URI)it.next();
                                    String pluginID = uri.segment(0);
                                    if (!SetupUIPlugin.PLUGIN_ID.equals(pluginID) || !"enable.preference.recorder".equals(lastSegment = uri.lastSegment()) && !"preference.recorder.target".equals(lastSegment) && !"ingored.preference.pages".equals(lastSegment) && !"initialized.preference.pages".equals(lastSegment)) continue;
                                    it.remove();
                                }
                                if (values.isEmpty()) {
                                    ((DisplayListener)(this).DisplayListener.this).RecorderManager.this.earlySynchronization.stop();
                                } else {
                                    Job job = new Job(Messages.RecorderManager_storePreferencesJob_name){

                                        protected IStatus run(IProgressMonitor monitor) {
                                            RecorderManager.this.handleRecording(((DisplayListener)((this).this).DisplayListener.this).RecorderManager.this.editor, values);
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    job.setSystem(true);
                                    job.schedule();
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private static final class EarlySynchronization
    implements SynchronizerJob.FinishHandler {
        private Scope recorderTarget;
        private File tmpFolder;
        private SynchronizerJob synchronizerJob;

        public boolean start(boolean interactive) {
            if (!SynchronizerManager.Availability.AVAILABLE || !SynchronizerManager.ENABLED) {
                return false;
            }
            if (this.synchronizerJob == null && SynchronizerManager.INSTANCE.isSyncEnabled()) {
                IStorage storage = SynchronizerManager.INSTANCE.getStorage();
                IStorageService service = storage.getService();
                if (service == null || !interactive && storage.getConnectedness() == IStorage.Connectedness.UNAUTHORIZED) {
                    return false;
                }
                this.recorderTarget = INSTANCE.getRecorderTargetObject();
                if (this.recorderTarget instanceof User) {
                    this.tmpFolder = null;
                    if (SYNC_FOLDER_FIXED) {
                        try {
                            this.tmpFolder = new File(PropertiesUtil.getTmpDir(), "oomph.setup.sync");
                            this.tmpFolder.mkdirs();
                            File[] tmpFiles = this.tmpFolder.listFiles();
                            if (tmpFiles != null) {
                                File[] fileArray = tmpFiles;
                                int n = tmpFiles.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File file = fileArray[n2];
                                    SyncUtil.deleteFile((File)file);
                                    ++n2;
                                }
                            }
                        }
                        catch (IOException ex) {
                            this.tmpFolder = null;
                            SetupUIPlugin.INSTANCE.log(ex);
                        }
                    }
                    if (this.tmpFolder == null) {
                        this.tmpFolder = IOUtil.createTempFolder((String)"sync-", (boolean)true);
                    }
                    if (SYNC_FOLDER_DEBUG) {
                        SetupUIPlugin.INSTANCE.log("Early synchronization in " + String.valueOf(this.tmpFolder));
                    }
                    File target = RecorderManager.copyRecorderTarget(this.recorderTarget, this.tmpFolder);
                    Synchronizer synchronizer = SynchronizerManager.INSTANCE.createSynchronizer(target, this.tmpFolder);
                    synchronizer.copyFilesFrom(SynchronizerManager.SYNC_FOLDER);
                    this.synchronizerJob = new SynchronizerJob(synchronizer, true);
                    this.synchronizerJob.setService(service);
                    if (interactive) {
                        this.synchronizerJob.setFinishHandler((SynchronizerJob.FinishHandler)this);
                    } else {
                        this.synchronizerJob.setCredentialsProvider(ICredentialsProvider.CANCEL);
                    }
                    this.synchronizerJob.schedule();
                }
            }
            return this.synchronizerJob != null;
        }

        public void stop() {
            if (!SynchronizerManager.Availability.AVAILABLE || !SynchronizerManager.ENABLED) {
                return;
            }
            if (this.synchronizerJob != null) {
                this.synchronizerJob.stopSynchronization();
                this.synchronizerJob = null;
                if (!SYNC_FOLDER_KEEP) {
                    boolean deleted = IOUtil.deleteBestEffort((File)this.tmpFolder, (!SYNC_FOLDER_FIXED ? 1 : 0) != 0);
                    if (SYNC_FOLDER_DEBUG) {
                        if (deleted) {
                            SetupUIPlugin.INSTANCE.log("Deleted " + String.valueOf(this.tmpFolder));
                        } else {
                            SetupUIPlugin.INSTANCE.log("Failed to delete " + String.valueOf(this.tmpFolder));
                        }
                    }
                }
            }
        }

        public SyncInfo await() {
            if (!SynchronizerManager.Availability.AVAILABLE || !SynchronizerManager.ENABLED) {
                return null;
            }
            if (this.synchronizerJob != null) {
                SyncInfo result;
                block10: {
                    result = new SyncInfo();
                    result.recorderTarget = this.recorderTarget;
                    result.tmpFolder = this.tmpFolder;
                    result.synchronization = this.synchronizerJob.getSynchronization();
                    if (result.synchronization == null) {
                        Throwable exception;
                        block11: {
                            Throwable earlyException = this.synchronizerJob.getException();
                            if (earlyException instanceof OperationCanceledException) {
                                this.stop();
                                result.synchronization = null;
                                if (!this.start(true)) {
                                    return null;
                                }
                                result.tmpFolder = this.tmpFolder;
                            } else if (earlyException != null) {
                                SynchronizerManager.log(earlyException);
                                return null;
                            }
                            final AtomicBoolean canceled = new AtomicBoolean();
                            final IStorageService service = this.synchronizerJob.getService();
                            final Semaphore authenticationSemaphore = service.getAuthenticationSemaphore();
                            authenticationSemaphore.acquire();
                            UIUtil.syncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Shell shell = UIUtil.getShell();
                                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                                        dialog.run(true, true, new IRunnableWithProgress(){

                                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                                authenticationSemaphore.release();
                                                String serviceLabel = service.getServiceLabel();
                                                result.synchronization = this.await(serviceLabel, monitor);
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException ex) {
                                        SetupUIPlugin.INSTANCE.log(ex);
                                    }
                                    catch (InterruptedException ex) {
                                        canceled.set(true);
                                    }
                                }
                            });
                            if (result.synchronization != null || canceled.get()) break block10;
                            exception = this.synchronizerJob.getException();
                            if (exception != null && !(exception instanceof OperationCanceledException)) break block11;
                            return null;
                        }
                        try {
                            throw exception;
                        }
                        catch (Throwable ex) {
                            SetupUIPlugin.INSTANCE.log(ex);
                        }
                    }
                }
                return result;
            }
            return null;
        }

        private Synchronization await(String serviceLabel, IProgressMonitor monitor) {
            monitor.beginTask(NLS.bind((String)Messages.RecorderManager_requestDataTask_name, (Object)serviceLabel), -1);
            try {
                Synchronization synchronization = this.synchronizerJob.awaitSynchronization(monitor);
                return synchronization;
            }
            finally {
                monitor.done();
            }
        }

        public void handleFinish(Throwable ex) throws Exception {
            ProtocolException protocolException;
            if (ex instanceof ProtocolException && (protocolException = (ProtocolException)ex).getStatusCode() == 401) {
                UIUtil.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OptOutDialog dialog = new OptOutDialog(UIUtil.getShell(), synchronizerJob.getService());
                        dialog.open();
                        if (!dialog.getAnswer()) {
                            SynchronizerManager.INSTANCE.setSyncEnabled(false);
                        }
                    }
                });
            }
        }
    }

    public static class Lifecycle {
        public static void start(Display display) {
            RecorderManager.INSTANCE.display = display;
            display.addListener(45, (Listener)RecorderManager.INSTANCE.displayListener);
        }

        public static void stop() {
            RecorderManager.INSTANCE.displayListener.stop();
            if (RecorderManager.INSTANCE.display != null) {
                UIUtil.asyncExec((Display)RecorderManager.INSTANCE.display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!RecorderManager.INSTANCE.display.isDisposed()) {
                            RecorderManager.INSTANCE.display.removeListener(45, (Listener)RecorderManager.INSTANCE.displayListener);
                        }
                    }
                });
            }
        }
    }

    private static final class SyncInfo {
        private Scope recorderTarget;
        private File tmpFolder;
        private Synchronization synchronization;

        public Scope getRecorderTarget() {
            return this.recorderTarget;
        }

        public File getTmpFolder() {
            return this.tmpFolder;
        }

        public Synchronization getSynchronization() {
            return this.synchronization;
        }

        public String toString() {
            return SyncInfo.class.getSimpleName() + "[" + String.valueOf(EcoreUtil.getURI((EObject)this.recorderTarget)) + " --> " + String.valueOf(SynchronizerManager.SYNC_FOLDER) + "]";
        }
    }
}

