/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class CloseAllHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public CloseAllHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            MApplication application;
            EPartService partService;
            page.closeAllEditors(true);
            Collection<MPart> partsTaggedAsEditor = this.getContributedPartsTaggedAsEditor();
            if (!partsTaggedAsEditor.isEmpty() && (partService = (EPartService)(application = this.getApplicationModel()).getContext().get(EPartService.class)) != null) {
                for (MPart part : partsTaggedAsEditor) {
                    if (!partService.savePart(part, true)) continue;
                    partService.hidePart(part);
                }
                this.getEvaluationService().requestEvaluation("activePart");
            }
        }
        return null;
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    IWorkbenchPage page;
                    IWorkbenchPart part = InternalHandlerUtil.getActivePart(context);
                    Object perspective = InternalHandlerUtil.getVariable(context, "activeWorkbenchWindow.activePerspective");
                    if (part != null && perspective != null && part.getSite() != null && (page = part.getSite().getPage()) != null) {
                        IEditorReference[] refArray = page.getEditorReferences();
                        if (refArray != null && refArray.length > 0) {
                            return EvaluationResult.TRUE;
                        }
                        if (!CloseAllHandler.this.getContributedPartsTaggedAsEditor().isEmpty()) {
                            return EvaluationResult.TRUE;
                        }
                    }
                    return EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activePart");
                    info.addVariableNameAccess("activeWorkbenchWindow.activePerspective");
                }
            };
        }
        return this.enabledWhen;
    }

    private Collection<MPart> getContributedPartsTaggedAsEditor() {
        MApplication application = this.getApplicationModel();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        List partsTaggedAsEditor = modelService != null ? modelService.findElements((MUIElement)application, null, MPart.class, Arrays.asList("Editor")) : Collections.emptyList();
        return partsTaggedAsEditor.stream().filter(p -> !"org.eclipse.e4.ui.compatibility.editor".equals(p.getElementId()) && p.isCloseable() && p.isToBeRendered()).collect(Collectors.toSet());
    }

    private MApplication getApplicationModel() {
        BundleContext bundleContext = FrameworkUtil.getBundle(IWorkbench.class).getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(IWorkbench.class);
        return ((IWorkbench)bundleContext.getService(reference)).getApplication();
    }
}

