/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.url.BundleResourceHandler;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class BundleURLConnection
extends URLConnection
implements BundleReference {
    protected final BundleEntry bundleEntry;
    private final ModuleContainer container;
    protected InputStream in;
    protected String contentType;

    public BundleURLConnection(URL url, ModuleContainer container, BundleEntry bundleEntry) {
        super(url);
        this.container = container;
        this.bundleEntry = bundleEntry;
        this.in = null;
        this.contentType = null;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            if (this.bundleEntry != null) {
                this.in = this.bundleEntry.getInputStream();
                this.connected = true;
            } else {
                throw new IOException(NLS.bind(Msg.RESOURCE_NOT_FOUND_EXCEPTION, this.getURL()));
            }
        }
    }

    @Override
    public long getContentLengthLong() {
        return this.bundleEntry.getSize();
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = BundleURLConnection.guessContentTypeFromName(this.bundleEntry.getName());
            if (this.contentType == null) {
                if (!this.connected) {
                    try {
                        this.connect();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                try {
                    if (this.in.markSupported()) {
                        this.contentType = BundleURLConnection.guessContentTypeFromStream(this.in);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return this.contentType;
    }

    @Override
    public boolean getDoInput() {
        return true;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.in;
    }

    @Override
    public long getLastModified() {
        long lastModified = this.bundleEntry.getTime();
        if (lastModified == -1L) {
            return 0L;
        }
        return lastModified;
    }

    public URL getLocalURL() {
        URL local = this.bundleEntry.getLocalURL();
        return local == null ? this.getURL() : local;
    }

    public URL getFileURL() {
        return this.bundleEntry.getFileURL();
    }

    @Override
    public Bundle getBundle() {
        String host = this.getURL().getHost();
        long bundleId = BundleResourceHandler.parseBundleIDFromURLHost(host);
        Module module = this.container.getModule(bundleId);
        return module != null ? module.getBundle() : null;
    }
}

