/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.CommonNavigatorActionGroup;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.navigator.CommonNavigatorManager;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.LinkHelperService;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class CommonNavigator
extends ViewPart
implements ISetSelectionTarget,
ISaveablePart,
ISaveablesSource,
IShowInTarget {
    private static final String PERF_CREATE_PART_CONTROL = "org.eclipse.ui.navigator/perf/explorer/createPartControl";
    private static final String HELP_CONTEXT = NavigatorPlugin.PLUGIN_ID + ".common_navigator";
    public static final int IS_LINKING_ENABLED_PROPERTY = 65536;
    private CommonViewer commonViewer;
    private CommonNavigatorManager commonManager;
    private ActionGroup commonActionGroup;
    protected IMemento memento;
    private boolean isLinkingEnabled;
    private String LINKING_ENABLED = "CommonNavigator.LINKING_ENABLED";
    private LinkHelperService linkService;

    /*
     * WARNING - void declaration
     */
    public void createPartControl(Composite aParent) {
        ActionGroup actionGroup;
        Object filterService;
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_PART_CONTROL, (Object)((Object)this));
        stats.startRun();
        this.commonViewer = this.createCommonViewer(aParent);
        this.commonViewer.setCommonNavigator(this);
        try {
            ViewerFilter[] visibleFilters;
            this.commonViewer.getControl().setRedraw(false);
            filterService = this.commonViewer.getNavigatorContentService().getFilterService();
            ViewerFilter[] viewerFilterArray = visibleFilters = filterService.getVisibleFilters(true);
            int n = visibleFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter visibleFilter = viewerFilterArray[n2];
                this.commonViewer.addFilter(visibleFilter);
                ++n2;
            }
            this.commonViewer.setSorter((ViewerSorter)new CommonViewerSorter());
            this.commonViewer.setInput(this.getInitialInput());
            this.getSite().setSelectionProvider((ISelectionProvider)this.commonViewer);
            this.setPartName(this.getConfigurationElement().getAttribute("name"));
        }
        finally {
            this.commonViewer.getControl().setRedraw(true);
        }
        this.commonViewer.createFrameList();
        this.commonManager = this.createCommonManager();
        if (this.memento != null) {
            this.commonViewer.getNavigatorContentService().restoreState(this.memento);
        }
        this.commonActionGroup = this.createCommonActionGroup();
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        if (this.memento != null && (actionGroup = this.commonActionGroup) instanceof IMementoAware) {
            void mementoAware;
            filterService = (IMementoAware)actionGroup;
            IMementoAware cfr_ignored_0 = (IMementoAware)actionGroup;
            mementoAware.restoreState(this.memento);
        }
        ISaveablesLifecycleListener saveablesLifecycleListener = new ISaveablesLifecycleListener(){
            ISaveablesLifecycleListener siteSaveablesLifecycleListener;
            {
                this.siteSaveablesLifecycleListener = (ISaveablesLifecycleListener)CommonNavigator.this.getSite().getService(ISaveablesLifecycleListener.class);
            }

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                if (event.getEventType() == 4) {
                    CommonNavigator.this.firePropertyChange(257);
                }
                this.siteSaveablesLifecycleListener.handleLifecycleEvent(event);
            }
        };
        this.commonViewer.getNavigatorContentService().getSaveablesService().init(this, (StructuredViewer)this.getCommonViewer(), saveablesLifecycleListener);
        this.commonViewer.addSelectionChangedListener(event -> this.firePropertyChange(257));
        String helpContext = this.commonViewer.getNavigatorContentService().getViewerDescriptor().getHelpContext();
        if (helpContext == null) {
            helpContext = HELP_CONTEXT;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.commonViewer.getControl(), helpContext);
        boolean enableToolTipSupport = this.commonViewer.getNavigatorContentService().getViewerDescriptor().getBooleanConfigProperty("org.eclipse.ui.navigator.enableTooltipSupport");
        if (enableToolTipSupport) {
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.commonViewer);
        }
        stats.endRun();
    }

    public void updateTitle() {
        Object input = this.commonViewer.getInput();
        if (input == null) {
            this.setTitleToolTip("");
        } else {
            String inputToolTip = this.getFrameToolTipText(input);
            this.setTitleToolTip(inputToolTip);
        }
    }

    public String getFrameToolTipText(Object anElement) {
        if (this.commonViewer == null) {
            return "";
        }
        return ((ILabelProvider)this.commonViewer.getLabelProvider()).getText(anElement);
    }

    public void dispose() {
        if (this.commonManager != null) {
            this.commonManager.dispose();
        }
        if (this.commonActionGroup != null) {
            this.commonActionGroup.dispose();
        }
        super.dispose();
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.memento = aMemento;
        if (this.memento != null) {
            Integer linkingEnabledInteger = this.memento.getInteger(this.LINKING_ENABLED);
            this.setLinkingEnabled(linkingEnabledInteger != null ? linkingEnabledInteger == 1 : false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveState(IMemento aMemento) {
        aMemento.putInteger(this.LINKING_ENABLED, this.isLinkingEnabled ? 1 : 0);
        super.saveState(aMemento);
        this.commonManager.saveState(aMemento);
        this.commonViewer.getNavigatorContentService().saveState(aMemento);
        ActionGroup actionGroup = this.commonActionGroup;
        if (actionGroup instanceof IMementoAware) {
            void mementoAware;
            IMementoAware iMementoAware = (IMementoAware)actionGroup;
            IMementoAware cfr_ignored_0 = (IMementoAware)actionGroup;
            mementoAware.saveState(aMemento);
        }
    }

    public void setFocus() {
        if (this.commonViewer != null) {
            this.commonViewer.getTree().setFocus();
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.commonViewer != null) {
            this.commonViewer.setSelection(selection, true);
        }
    }

    public final void setLinkingEnabled(boolean toEnableLinking) {
        this.isLinkingEnabled = toEnableLinking;
        this.firePropertyChange(65536);
    }

    public final boolean isLinkingEnabled() {
        return this.isLinkingEnabled;
    }

    public CommonViewer getCommonViewer() {
        return this.commonViewer;
    }

    public INavigatorContentService getNavigatorContentService() {
        return this.getCommonViewer().getNavigatorContentService();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommonViewer.class) {
            return adapter.cast((Object)this.getCommonViewer());
        }
        if (adapter == INavigatorContentService.class) {
            return adapter.cast(this.getCommonViewer().getNavigatorContentService());
        }
        if (adapter == IShowInTarget.class) {
            return adapter.cast((Object)this);
        }
        if (adapter == IShowInSource.class) {
            return adapter.cast(this.getShowInSource());
        }
        return (T)super.getAdapter(adapter);
    }

    private IShowInSource getShowInSource() {
        return () -> new ShowInContext(this.getCommonViewer().getInput(), this.getCommonViewer().getSelection());
    }

    public NavigatorActionService getNavigatorActionService() {
        return this.commonManager.getNavigatorActionService();
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer aViewer = this.createCommonViewerObject(aParent);
        this.initListeners(aViewer);
        aViewer.getNavigatorContentService().restoreState(this.memento);
        return aViewer;
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 770);
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addDoubleClickListener(event -> SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            @Override
            public void run() throws Exception {
                CommonNavigator.this.handleDoubleClick(event);
            }
        }));
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IAction openHandler = this.getViewSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.navigator.Open");
        if (openHandler == null) {
            IStructuredSelection selection = (IStructuredSelection)anEvent.getSelection();
            Object element = selection.getFirstElement();
            CommonViewer viewer = this.getCommonViewer();
            if (viewer.isExpandable(element)) {
                viewer.setExpandedState(element, !viewer.getExpandedState(element));
            }
        }
    }

    protected CommonNavigatorManager createCommonManager() {
        return new CommonNavigatorManager(this, this.memento);
    }

    protected ActionGroup createCommonActionGroup() {
        return new CommonNavigatorActionGroup(this, this.commonViewer, this.getLinkHelperService());
    }

    protected Object getInitialInput() {
        return this.getSite().getPage().getInput();
    }

    public Saveable[] getSaveables() {
        Saveable[] saveables = this.getNavigatorContentService().getSaveablesService().getSaveables();
        if (saveables == null) {
            saveables = new Saveable[]{};
        }
        return saveables;
    }

    public Saveable[] getActiveSaveables() {
        Saveable[] activeSaveables = this.getNavigatorContentService().getSaveablesService().getActiveSaveables();
        if (activeSaveables == null) {
            activeSaveables = new Saveable[]{};
        }
        return activeSaveables;
    }

    protected boolean hasSaveablesProvider() {
        return this.getNavigatorContentService().getSaveablesService().hasSaveablesProvider();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        Saveable[] saveables;
        Saveable[] saveableArray = saveables = this.getSaveables();
        int n = saveables.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable saveable = saveableArray[n2];
            if (saveable.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    /*
     * WARNING - void declaration
     */
    public boolean show(ShowInContext context) {
        Object input;
        Object object;
        if (context == null) {
            return false;
        }
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.selectReveal(selection);
            selection = this.commonViewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
        }
        if ((object = (input = context.getInput())) instanceof IEditorInput) {
            void editorInput;
            IEditorInput iEditorInput = (IEditorInput)object;
            IEditorInput cfr_ignored_0 = (IEditorInput)object;
            LinkHelperService lhs = this.getLinkHelperService();
            selection = lhs.getSelectionFor((IEditorInput)editorInput);
            if (selection != null && !selection.isEmpty()) {
                this.selectReveal(selection);
                return true;
            }
        }
        if (input != null) {
            this.selectReveal((ISelection)new StructuredSelection(input));
            return true;
        }
        return false;
    }

    protected synchronized LinkHelperService getLinkHelperService() {
        if (this.linkService == null) {
            this.linkService = new LinkHelperService((NavigatorContentService)this.getCommonViewer().getNavigatorContentService());
        }
        return this.linkService;
    }

    protected IMemento getMemento() {
        return this.memento;
    }

    public void setRootMode(int mode) {
    }

    public int getRootMode() {
        return 0;
    }

    public void setWorkingSetLabel(String label) {
    }

    public String getWorkingSetLabel() {
        return null;
    }
}

