/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.Messages;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.core.util.URIResolver;
import org.eclipse.osgi.util.NLS;

public class UserURIHandlerImpl
extends URIHandlerImpl
implements URIResolver {
    private static final String FEATURE_PATTERN_SUFFIX = "='([^']*)'";
    private static final Pattern CLASS_PATTERN = Pattern.compile("class='([^']*)'");

    @Override
    public boolean canHandle(URI uri) {
        return SetupContext.isUserScheme(uri.scheme());
    }

    @Override
    public URI resolve(URI uri) {
        return SetupContext.GLOBAL_SETUPS_LOCATION_URI.appendSegments(uri.segments()).appendFragment(uri.fragment());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        Resource resource;
        URI normalizedURI = this.resolve(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options) && (resource = this.create(uri, normalizedURI)) != null && normalizedURI.lastSegment().equals("${setup.filename}")) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            resource.save((OutputStream)out, options);
            out.close();
            return new ByteArrayInputStream(out.toByteArray());
        }
        return uriConverter.createInputStream(normalizedURI, options);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.resolve(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        return uriConverter.createOutputStream(normalizedURI, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.resolve(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        uriConverter.delete(normalizedURI, options);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.resolve(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.contentDescription(normalizedURI, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        URI normalizedURI = this.resolve(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        return uriConverter.exists(normalizedURI, options) || this.create(uri, normalizedURI) != null;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        URI normalizedURI = this.resolve(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.getAttributes(normalizedURI, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.resolve(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        uriConverter.setAttributes(normalizedURI, attributes, options);
    }

    private Resource create(URI uri, URI normalizedURI) {
        String query = uri.query();
        if (query != null) {
            EObject instance;
            Resource resource = SetupCoreUtil.createResourceSet().createResource(normalizedURI);
            String decodedQuery = URI.decode((String)query);
            Matcher classMatcher = CLASS_PATTERN.matcher(decodedQuery);
            URI classURI = URI.createURI((String)(classMatcher.find() ? classMatcher.group(1) : "http://www.eclipse.org/oomph/setup/1.0#//Project"));
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(classURI.trimFragment().toString());
            if (ePackage == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.UserURIHandlerImpl_NoPackage_exception, (Object)classURI));
            }
            EObject eObject = ePackage.eResource().getEObject(classURI.fragment());
            if (eObject instanceof EClass) {
                EClass eClass = (EClass)eObject;
                instance = EcoreUtil.create((EClass)eClass);
                for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                    Pattern pattern;
                    Matcher matcher;
                    if (eAttribute.isMany() || !(matcher = (pattern = Pattern.compile(String.valueOf(eAttribute.getName()) + FEATURE_PATTERN_SUFFIX)).matcher(decodedQuery)).find()) continue;
                    String value = matcher.group(1);
                    instance.eSet((EStructuralFeature)eAttribute, EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)value));
                }
                if (instance instanceof ProductCatalog) {
                    ProductCatalog productCatalog = (ProductCatalog)instance;
                    EList setupTasks = productCatalog.getSetupTasks();
                    InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
                    installationTask.setID("installation");
                    setupTasks.add((Object)installationTask);
                }
            } else {
                throw new IllegalArgumentException(NLS.bind((String)Messages.UserURIHandlerImpl_NoClass_exception, (Object)classURI));
            }
            resource.getContents().add((Object)instance);
            return UserURIHandlerImpl.saveResource(resource);
        }
        if (SetupContext.USER_SETUP_URI.equals(uri)) {
            User user = SetupContext.createUser();
            Resource resource = SetupCoreUtil.createResourceSet().createResource(normalizedURI);
            resource.getContents().add((Object)user);
            return UserURIHandlerImpl.saveResource(resource);
        }
        return null;
    }

    private static Resource saveResource(Resource resource) {
        if (resource.getURI().lastSegment().equals("${setup.filename}")) {
            return resource;
        }
        try {
            resource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
            return resource;
        }
        catch (IOException ex) {
            SetupCorePlugin.INSTANCE.log(ex);
            return null;
        }
    }
}

