/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.internal.workbench.swt.DialogSettingsProviderService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.IDialogSettingsProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.testing.TestableObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class PlatformUI {
    public static final String PLUGIN_ID = "org.eclipse.ui";
    public static final int RETURN_OK = 0;
    public static final int RETURN_RESTART = 1;
    public static final int RETURN_UNSTARTABLE = 2;
    public static final int RETURN_EMERGENCY_CLOSE = 3;
    public static final Supplier<RuntimeException> NO_WORKBENCH = () -> new IllegalStateException(WorkbenchMessages.PlatformUI_NoWorkbench);

    private PlatformUI() {
    }

    public static IWorkbench getWorkbench() {
        if (Workbench.getInstance() == null) {
            throw new IllegalStateException(WorkbenchMessages.PlatformUI_NoWorkbench);
        }
        return Workbench.getInstance();
    }

    public static boolean isWorkbenchRunning() {
        return Workbench.getInstance() != null && Workbench.getInstance().isRunning();
    }

    public static int createAndRunWorkbench(Display display, WorkbenchAdvisor advisor) {
        return Workbench.createAndRunWorkbench(display, advisor);
    }

    public static Display createDisplay() {
        return Workbench.createDisplay();
    }

    public static TestableObject getTestableObject() {
        TestableObject testableObject = WorkbenchPlugin.getDefault().getTestableObject();
        if (testableObject == null) {
            return Workbench.getWorkbenchTestable();
        }
        return testableObject;
    }

    public static IPreferenceStore getPreferenceStore() {
        return PrefUtil.getAPIPreferenceStore();
    }

    public static IDialogSettingsProvider getDialogSettingsProvider(Bundle bundle) {
        return DialogSettingsProviderService.instance.getProvider(bundle);
    }

    public static IPreferenceStore createPreferenceStore(Class<?> clazz) {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, FrameworkUtil.getBundle(clazz).getSymbolicName());
    }

    public static Optional<MApplication> getApplication() {
        Workbench instance = Workbench.getInstance();
        if (instance != null && instance.isRunning()) {
            return Optional.of(instance.getApplication());
        }
        WorkbenchPlugin plugin = WorkbenchPlugin.getDefault();
        if (plugin == null) {
            return Optional.empty();
        }
        BundleContext bundleContext = plugin.getBundleContext();
        if (bundleContext == null) {
            return Optional.empty();
        }
        ServiceReference reference = bundleContext.getServiceReference(org.eclipse.e4.ui.workbench.IWorkbench.class);
        if (reference == null) {
            return Optional.empty();
        }
        org.eclipse.e4.ui.workbench.IWorkbench service = (org.eclipse.e4.ui.workbench.IWorkbench)bundleContext.getService(reference);
        if (service == null) {
            return Optional.empty();
        }
        bundleContext.ungetService(reference);
        return Optional.ofNullable(service.getApplication());
    }
}

