/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.TimeTriggeredProgressMonitorDialog;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class OperationHistoryActionHandler
extends Action
implements ActionFactory.IWorkbenchAction,
IAdaptable {
    private static final int MAX_LABEL_LENGTH = 33;
    private boolean pruning = false;
    private IPartListener partListener = new PartListener();
    private IOperationHistoryListener historyListener = new HistoryListener();
    private TimeTriggeredProgressMonitorDialog progressDialog;
    private IUndoContext undoContext = null;
    IWorkbenchPartSite site;

    OperationHistoryActionHandler(IWorkbenchPartSite site, IUndoContext context) {
        super("");
        this.site = site;
        this.undoContext = context;
        site.getPage().addPartListener(this.partListener);
        this.getHistory().addOperationHistoryListener(this.historyListener);
        this.update();
    }

    @Override
    public void dispose() {
        IOperationHistory history = this.getHistory();
        if (history != null) {
            history.removeOperationHistoryListener(this.historyListener);
        }
        if (this.isInvalid()) {
            return;
        }
        this.site.getPage().removePartListener(this.partListener);
        this.site = null;
        this.progressDialog = null;
        this.undoContext = null;
    }

    abstract void flush();

    abstract String getCommandString();

    abstract String getTooltipString();

    abstract String getSimpleCommandString();

    abstract String getSimpleTooltipString();

    IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    abstract IUndoableOperation getOperation();

    public final void run() {
        if (this.isInvalid()) {
            return;
        }
        Shell parent = this.getWorkbenchWindow().getShell();
        this.progressDialog = new TimeTriggeredProgressMonitorDialog(parent, this.getWorkbenchWindow().getWorkbench().getProgressService().getLongOperationTime());
        IRunnableWithProgress runnable = pm -> {
            try {
                this.runCommand(pm);
            }
            catch (ExecutionException e) {
                if (this.pruning) {
                    this.flush();
                }
                throw new InvocationTargetException(e);
            }
        };
        try {
            try {
                boolean runInBackground = false;
                if (this.getOperation() instanceof IAdvancedUndoableOperation2) {
                    runInBackground = ((IAdvancedUndoableOperation2)this.getOperation()).runInBackground();
                }
                this.progressDialog.run(runInBackground, true, runnable);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t == null) {
                    this.reportException(e);
                } else {
                    this.reportException(t);
                }
                this.progressDialog = null;
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                this.progressDialog = null;
            }
        }
        finally {
            this.progressDialog = null;
        }
    }

    abstract IStatus runCommand(IProgressMonitor var1) throws ExecutionException;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IUndoContext.class)) {
            return adapter.cast(this.undoContext);
        }
        if (adapter.equals(IProgressMonitor.class) && this.progressDialog != null) {
            return adapter.cast(this.progressDialog.getProgressMonitor());
        }
        if (this.site != null) {
            if (adapter.equals(Shell.class)) {
                return adapter.cast(this.getWorkbenchWindow().getShell());
            }
            if (adapter.equals(IWorkbenchWindow.class)) {
                return adapter.cast(this.getWorkbenchWindow());
            }
            if (adapter.equals(IWorkbenchPart.class)) {
                return adapter.cast(this.site.getPart());
            }
            IWorkbenchPart part = this.site.getPart();
            if (part != null) {
                return (T)Adapters.adapt((Object)part, adapter);
            }
        }
        return null;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        if (this.site != null) {
            return this.site.getWorkbenchWindow();
        }
        return null;
    }

    abstract boolean shouldBeEnabled();

    public void setContext(IUndoContext context) {
        if (context == this.undoContext) {
            return;
        }
        this.undoContext = context;
        this.update();
    }

    public void setPruneHistory(boolean prune) {
        this.pruning = prune;
    }

    public void update() {
        String text;
        String tooltipText;
        if (this.isInvalid()) {
            return;
        }
        boolean enabled = this.shouldBeEnabled();
        if (enabled) {
            tooltipText = NLS.bind((String)this.getTooltipString(), (Object)this.getOperation().getLabel());
            text = String.valueOf(NLS.bind((String)this.getCommandString(), (Object)LegacyActionTools.escapeMnemonics((String)this.shortenText(this.getOperation().getLabel())))) + '@';
        } else {
            tooltipText = NLS.bind((String)WorkbenchMessages.Operations_undoRedoCommandDisabled, (Object)this.getSimpleTooltipString());
            text = this.getSimpleCommandString();
            if (this.undoContext != null && this.pruning) {
                this.flush();
            }
        }
        this.setText(text);
        this.setToolTipText(tooltipText);
        this.setEnabled(enabled);
    }

    private String shortenText(String message) {
        int length = message.length();
        if (length > 33) {
            StringBuilder result = new StringBuilder();
            int end = 15;
            result.append(message.substring(0, end));
            result.append("...");
            result.append(message.substring(length - end));
            return result.toString();
        }
        return message;
    }

    final void reportException(Throwable t) {
        String exceptionMessage = t.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = WorkbenchMessages.WorkbenchWindow_exceptionMessage;
        }
        IStatus status = StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, exceptionMessage, t);
        WorkbenchPlugin.log(exceptionMessage, status);
        StatusUtil.handleStatus(status, 2);
    }

    final boolean isInvalid() {
        return this.undoContext == null || this.site == null;
    }

    final IUndoContext getUndoContext() {
        return this.undoContext;
    }

    private class HistoryListener
    implements IOperationHistoryListener {
        private HistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            IWorkbenchWindow workbenchWindow = OperationHistoryActionHandler.this.getWorkbenchWindow();
            if (workbenchWindow == null) {
                return;
            }
            Display display = workbenchWindow.getWorkbench().getDisplay();
            if (display == null) {
                return;
            }
            switch (event.getEventType()) {
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    if (!event.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(() -> OperationHistoryActionHandler.this.update());
                    break;
                }
                case 7: {
                    if (!event.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(() -> {
                        if (OperationHistoryActionHandler.this.pruning) {
                            IStatus status = event.getStatus();
                            if (status == null || status.getSeverity() != 8) {
                                OperationHistoryActionHandler.this.flush();
                            }
                            OperationHistoryActionHandler.this.update();
                        } else {
                            OperationHistoryActionHandler.this.update();
                        }
                    });
                    break;
                }
                case 6: {
                    if (event.getOperation() != OperationHistoryActionHandler.this.getOperation()) break;
                    display.asyncExec(() -> OperationHistoryActionHandler.this.update());
                }
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
        }

        @Override
        public void partBroughtToTop(IWorkbenchPart part) {
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            if (OperationHistoryActionHandler.this.site != null && part.equals(OperationHistoryActionHandler.this.site.getPart())) {
                OperationHistoryActionHandler.this.dispose();
            } else if (OperationHistoryActionHandler.this.site instanceof MultiPageEditorSite && part.equals(((MultiPageEditorSite)OperationHistoryActionHandler.this.site).getMultiPageEditor())) {
                OperationHistoryActionHandler.this.dispose();
            }
        }

        @Override
        public void partDeactivated(IWorkbenchPart part) {
        }

        @Override
        public void partOpened(IWorkbenchPart part) {
        }
    }
}

