/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.ScopeType;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.UserCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetupTaskImpl
extends ModelElementImpl
implements SetupTask {
    protected static final String ID_EDEFAULT = null;
    protected String iD = ID_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final ScopeType SCOPE_TYPE_EDEFAULT = ScopeType.NONE;
    protected Set<Trigger> excludedTriggers;
    protected static final boolean DISABLED_EDEFAULT = false;
    protected boolean disabled = false;
    protected EList<SetupTask> predecessors;
    protected EList<SetupTask> successors;
    protected EList<Scope> restrictions;
    protected static final String FILTER_EDEFAULT = null;
    protected String filter = FILTER_EDEFAULT;

    protected SetupTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.SETUP_TASK;
    }

    @Override
    public String getID() {
        return this.iD;
    }

    @Override
    public void setID(String newID) {
        String oldID = this.iD;
        this.iD = newID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldID, (Object)this.iD));
        }
    }

    @Override
    public EList<SetupTask> getPredecessors() {
        if (this.predecessors == null) {
            this.predecessors = new EObjectResolvingEList(SetupTaskImpl.class, (InternalEObject)this, 6);
        }
        return this.predecessors;
    }

    @Override
    public EList<SetupTask> getSuccessors() {
        if (this.successors == null) {
            this.successors = new EObjectResolvingEList(SetupTaskImpl.class, (InternalEObject)this, 7);
        }
        return this.successors;
    }

    @Override
    public EList<Scope> getRestrictions() {
        if (this.restrictions == null) {
            this.restrictions = new EObjectResolvingEList(Scope.class, (InternalEObject)this, 8);
        }
        return this.restrictions;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String newFilter) {
        String oldFilter = this.filter;
        this.filter = newFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldFilter, (Object)this.filter));
        }
    }

    @Override
    public final ScopeType getScopeType() {
        return this.getScope((EObject)this);
    }

    @Override
    public Set<Trigger> getExcludedTriggers() {
        return this.excludedTriggers == null ? Collections.emptySet() : this.excludedTriggers;
    }

    public void setExcludedTriggersGen(Set<Trigger> newExcludedTriggers) {
        Set<Trigger> oldExcludedTriggers = this.excludedTriggers;
        this.excludedTriggers = newExcludedTriggers;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldExcludedTriggers, this.excludedTriggers));
        }
    }

    @Override
    public void setExcludedTriggers(Set<Trigger> newExcludedTriggers) {
        this.setExcludedTriggersGen(newExcludedTriggers == null || newExcludedTriggers.isEmpty() ? null : newExcludedTriggers);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public Scope getScope() {
        EObject container = this.eContainer();
        while (container != null) {
            if (container instanceof Scope) {
                return (Scope)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean newDisabled) {
        boolean oldDisabled = this.disabled;
        this.disabled = newDisabled;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldDisabled, this.disabled));
        }
    }

    private ScopeType getScope(EObject object) {
        if (object instanceof Scope) {
            return ((Scope)object).getType();
        }
        EObject container = object.eContainer();
        if (container == null) {
            return ScopeType.NONE;
        }
        return this.getScope(container);
    }

    @Override
    public boolean requires(SetupTask setupTask) {
        return this.visitPredecessors(setupTask, new HashSet<SetupTask>()) || ((SetupTaskImpl)setupTask).visitSuccessors(this, new HashSet<SetupTask>());
    }

    public boolean requiresFast(SetupTask setupTask) {
        return this.visitPredecessorsFast(setupTask, new HashSet<SetupTask>()) || ((SetupTaskImpl)setupTask).visitSuccessorsFast(this, new HashSet<SetupTask>());
    }

    @Override
    public final Set<Trigger> getValidTriggers() {
        return SetupUtil.getTriggers(this.eClass());
    }

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public final Set<Trigger> getTriggers() {
        Set<Trigger> excludedTriggers = this.getExcludedTriggers();
        if (excludedTriggers == null || excludedTriggers.isEmpty()) {
            return this.getValidTriggers();
        }
        HashSet<Trigger> result = new HashSet<Trigger>(this.getValidTriggers());
        result.removeAll(excludedTriggers);
        return Trigger.intern(result);
    }

    private boolean visitPredecessorsFast(SetupTask setupTask, Set<SetupTask> visited) {
        if (visited.add(this)) {
            SetupTaskImpl[] data;
            if (setupTask == this) {
                return true;
            }
            if (this.predecessors != null && (data = (SetupTaskImpl[])((BasicEList)this.predecessors).data()) != null) {
                int i = 0;
                int length = data.length;
                while (i < length) {
                    SetupTaskImpl requirement = data[i];
                    if (requirement == null) break;
                    if (requirement.visitPredecessorsFast(setupTask, visited)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean visitSuccessorsFast(SetupTask setupTask, Set<SetupTask> visited) {
        if (visited.add(this)) {
            SetupTaskImpl[] data;
            if (setupTask == this) {
                return true;
            }
            if (this.successors != null && (data = (SetupTaskImpl[])((BasicEList)this.successors).data()) != null) {
                int i = 0;
                int length = data.length;
                while (i < length) {
                    SetupTaskImpl requirement = data[i];
                    if (requirement == null) break;
                    if (requirement.visitSuccessorsFast(setupTask, visited)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean visitPredecessors(SetupTask setupTask, Set<SetupTask> visited) {
        if (visited.add(this)) {
            if (setupTask == this) {
                return true;
            }
            if (this.predecessors != null && !this.predecessors.isEmpty()) {
                for (SetupTask requirement : this.getPredecessors()) {
                    if (!((SetupTaskImpl)requirement).visitPredecessors(setupTask, visited)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean visitSuccessors(SetupTask setupTask, Set<SetupTask> visited) {
        if (visited.add(this)) {
            if (setupTask == this) {
                return true;
            }
            if (this.successors != null && !this.successors.isEmpty()) {
                for (SetupTask requirement : this.successors) {
                    if (!((SetupTaskImpl)requirement).visitSuccessors(setupTask, visited)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected final Object createToken(String value) {
        return new TypedStringToken(this.eClass(), value);
    }

    @Override
    public Object getOverrideToken() {
        return this;
    }

    @Override
    public void overrideFor(SetupTask overriddenSetupTask) {
        EList<Scope> overriddenRestrictions;
        EList<SetupTask> overriddenSuccessors;
        EList<SetupTask> overriddenPredecessors = overriddenSetupTask.getPredecessors();
        if (!overriddenPredecessors.isEmpty()) {
            this.getPredecessors().addAll(overriddenPredecessors);
        }
        if (!(overriddenSuccessors = overriddenSetupTask.getSuccessors()).isEmpty()) {
            this.getSuccessors().addAll(overriddenSuccessors);
        }
        if (!(overriddenRestrictions = overriddenSetupTask.getRestrictions()).isEmpty()) {
            this.getRestrictions().addAll(overriddenRestrictions);
        }
    }

    @Override
    public void consolidate() {
    }

    @Override
    public int getProgressMonitorWork() {
        return 1;
    }

    @Override
    public void dispose() {
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getID();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.getScopeType();
            }
            case 4: {
                return this.getExcludedTriggers();
            }
            case 5: {
                return this.isDisabled();
            }
            case 6: {
                return this.getPredecessors();
            }
            case 7: {
                return this.getSuccessors();
            }
            case 8: {
                return this.getRestrictions();
            }
            case 9: {
                return this.getFilter();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setID((String)newValue);
                return;
            }
            case 2: {
                this.setDescription((String)newValue);
                return;
            }
            case 4: {
                this.setExcludedTriggers((Set)newValue);
                return;
            }
            case 5: {
                this.setDisabled((Boolean)newValue);
                return;
            }
            case 6: {
                this.getPredecessors().clear();
                this.getPredecessors().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getSuccessors().clear();
                this.getSuccessors().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getRestrictions().clear();
                this.getRestrictions().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setFilter((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setID(ID_EDEFAULT);
                return;
            }
            case 2: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 4: {
                this.setExcludedTriggers(null);
                return;
            }
            case 5: {
                this.setDisabled(false);
                return;
            }
            case 6: {
                this.getPredecessors().clear();
                return;
            }
            case 7: {
                this.getSuccessors().clear();
                return;
            }
            case 8: {
                this.getRestrictions().clear();
                return;
            }
            case 9: {
                this.setFilter(FILTER_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return ID_EDEFAULT == null ? this.iD != null : !ID_EDEFAULT.equals(this.iD);
            }
            case 2: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 3: {
                return this.getScopeType() != SCOPE_TYPE_EDEFAULT;
            }
            case 4: {
                return this.excludedTriggers != null;
            }
            case 5: {
                return this.disabled;
            }
            case 6: {
                return this.predecessors != null && !this.predecessors.isEmpty();
            }
            case 7: {
                return this.successors != null && !this.successors.isEmpty();
            }
            case 8: {
                return this.restrictions != null && !this.restrictions.isEmpty();
            }
            case 9: {
                return FILTER_EDEFAULT == null ? this.filter != null : !FILTER_EDEFAULT.equals(this.filter);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (iD: ");
        result.append(this.iD);
        result.append(", description: ");
        result.append(this.description);
        result.append(", excludedTriggers: ");
        result.append(this.excludedTriggers);
        result.append(", disabled: ");
        result.append(this.disabled);
        result.append(", filter: ");
        result.append(this.filter);
        result.append(')');
        return result.toString();
    }

    protected URI createResolvedURI(String uri) {
        Resource resource;
        URI baseURI;
        if (uri == null) {
            return null;
        }
        URI result = URI.createURI((String)uri);
        if (result.isRelative() && result.hasRelativePath() && (baseURI = (resource = this.eResource()).getURI()) != null && baseURI.isHierarchical() && !baseURI.isRelative()) {
            return result.resolve(baseURI);
        }
        return result;
    }

    protected final void performUI(final SetupTaskContext context, final RunnableWithContext runnable) throws Exception {
        final Exception[] exception = new Exception[1];
        UserCallback callback = context.getPrompter().getUserCallback();
        callback.execInUI(false, new Runnable(){

            public void run() {
                try {
                    runnable.run(context);
                }
                catch (Exception ex) {
                    exception[0] = ex;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    protected static interface RunnableWithContext {
        public void run(SetupTaskContext var1) throws Exception;
    }

    protected static final class TypedStringToken {
        private final Object type;
        private final String value;

        public TypedStringToken(Object type, String value) {
            this.type = type;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypedStringToken other = (TypedStringToken)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

