/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MBindings;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.osgi.service.event.Event;

public class BindingProcessingAddon {
    private static final String[] DEFAULT_SCHEMES = new String[]{"org.eclipse.ui.defaultAcceleratorConfiguration"};
    @Inject
    private MApplication application;
    @Inject
    private ContextManager contextManager;
    @Inject
    private BindingTableManager bindingTables;
    @Inject
    @Optional
    private BindingManager bindingManager;
    @Inject
    private ECommandService commandService;
    @Inject
    private EBindingService bindingService;

    @PostConstruct
    public void init() {
        Scheme activeScheme;
        String[] schemes = DEFAULT_SCHEMES;
        if (this.bindingManager != null && (activeScheme = this.bindingManager.getActiveScheme()) != null) {
            schemes = this.getSchemeIds(activeScheme.getId());
        }
        this.bindingTables.setActiveSchemes(schemes);
        this.defineBindingTables();
        this.activateContexts(this.application);
    }

    private final String[] getSchemeIds(String schemeId) {
        ArrayList<String> strings = new ArrayList<String>();
        while (schemeId != null) {
            strings.add(schemeId);
            try {
                schemeId = this.getScheme(schemeId).getParentId();
            }
            catch (NotDefinedException notDefinedException) {
                return new String[0];
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    private final Scheme getScheme(String schemeId) {
        return this.bindingManager.getScheme(schemeId);
    }

    private void activateContexts(Object me) {
        if (me instanceof MBindings) {
            MContext contextModel = (MContext)me;
            MBindings container = (MBindings)me;
            List bindingContexts = container.getBindingContexts();
            IEclipseContext context = contextModel.getContext();
            if (context != null && !bindingContexts.isEmpty()) {
                EContextService cs = (EContextService)context.get(EContextService.class);
                for (MBindingContext element : bindingContexts) {
                    cs.activateContext(element.getElementId());
                }
            }
        }
        if (me instanceof MElementContainer) {
            List children = ((MElementContainer)me).getChildren();
            for (MUIElement e : children) {
                this.activateContexts(e);
            }
        }
    }

    private void defineBindingTables() {
        if (Policy.DEBUG_CMDS) {
            WorkbenchSWTActivator.trace("/trace/commands", "Initialize binding tables from model", null);
        }
        for (MBindingTable bindingTable : this.application.getBindingTables()) {
            this.defineBindingTable(bindingTable);
        }
    }

    private void defineBindingTable(MBindingTable bindingTable) {
        Assert.isNotNull((Object)bindingTable.getBindingContext(), (String)("Binding context referred to by the binding table \"" + bindingTable.getElementId() + "\""));
        Assert.isNotNull((Object)bindingTable.getBindingContext().getElementId(), (String)("Element ID of binding table \"" + bindingTable.getElementId() + "\"."));
        Context bindingContext = this.contextManager.getContext(bindingTable.getBindingContext().getElementId());
        BindingTable table = this.bindingTables.getTable(bindingTable.getBindingContext().getElementId());
        if (table == null) {
            table = new BindingTable(bindingContext);
            this.bindingTables.addTable(table);
        }
        for (MKeyBinding binding : bindingTable.getBindings()) {
            this.defineBinding(table, bindingContext, binding);
        }
    }

    private void defineBinding(BindingTable bindingTable, Context bindingContext, MKeyBinding binding) {
        Binding keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
        if (keyBinding != null && !binding.getTags().contains("deleted")) {
            bindingTable.addBinding(keyBinding);
        }
    }

    private Binding createBinding(Context bindingContext, MCommand cmdModel, List<MParameter> modelParms, String keySequence, MKeyBinding binding) {
        Binding keyBinding = null;
        if (binding.getTransientData().get("binding") != null) {
            try {
                return (Binding)binding.getTransientData().get("binding");
            }
            catch (ClassCastException classCastException) {
                System.err.println("Invalid type stored in transient data with the key binding");
                return null;
            }
        }
        if (cmdModel == null) {
            Platform.getLog(this.getClass()).error("binding with no command: " + binding);
            return null;
        }
        HashMap<String, String> parameters = null;
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = this.commandService.createCommand(cmdModel.getElementId(), parameters);
        TriggerSequence sequence = null;
        sequence = this.bindingService.createSequence(keySequence);
        if (cmd == null) {
            System.err.println("Failed to find command for binding: " + binding);
        } else if (sequence == null) {
            System.err.println("Failed to map binding: " + binding);
        } else {
            try {
                String schemeId = null;
                String locale = null;
                String platform = null;
                HashMap<String, String> attrs = new HashMap<String, String>();
                List tags = binding.getTags();
                for (String tag : tags) {
                    if (tag.startsWith("schemeId")) {
                        schemeId = tag.substring(9);
                        attrs.put("schemeId", schemeId);
                        continue;
                    }
                    if (tag.startsWith("locale")) {
                        locale = tag.substring(7);
                        attrs.put("locale", locale);
                        continue;
                    }
                    if (tag.startsWith("platform")) {
                        platform = tag.substring(9);
                        attrs.put("platform", platform);
                        continue;
                    }
                    if (!tag.startsWith("type")) continue;
                    attrs.put("type", "user");
                }
                keyBinding = this.bindingService.createBinding(sequence, cmd, bindingContext.getId(), attrs);
                binding.getTransientData().put("binding", keyBinding);
            }
            catch (IllegalArgumentException e) {
                if (Policy.DEBUG_MENUS) {
                    WorkbenchSWTActivator.trace("/trace/menus", "failed to create: " + binding, e);
                }
                return null;
            }
        }
        return keyBinding;
    }

    private void updateBinding(MKeyBinding binding, boolean add, Object eObj) {
        Object parentObj = ((EObject)binding).eContainer();
        if (!(parentObj instanceof MBindingTable) && eObj instanceof MBindingTable) {
            parentObj = eObj;
        }
        if (parentObj == null) {
            return;
        }
        MBindingTable bt = (MBindingTable)parentObj;
        Context bindingContext = this.contextManager.getContext(bt.getBindingContext().getElementId());
        BindingTable table = this.bindingTables.getTable(bindingContext.getId());
        if (table == null) {
            Platform.getLog(this.getClass()).error("Trying to create '" + binding + "' without binding table " + bindingContext.getId());
            return;
        }
        Binding keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
        if (keyBinding != null) {
            if (add) {
                table.addBinding(keyBinding);
            } else {
                table.removeBinding(keyBinding);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeBindingTableContainerTopicBindingTables(@UIEventTopic(value="org/eclipse/e4/ui/model/commands/BindingTableContainer/bindingTables/*") Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        if (!(elementObj instanceof MApplication)) {
            return;
        }
        if (UIEvents.isADD((Event)event)) {
            for (Object newObj : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                if (!(newObj instanceof MBindingTable)) continue;
                MBindingTable bt = (MBindingTable)newObj;
                Context bindingContext = this.contextManager.getContext(bt.getBindingContext().getElementId());
                BindingTable table = new BindingTable(bindingContext);
                this.bindingTables.addTable(table);
                List bindings = bt.getBindings();
                for (MKeyBinding binding : bindings) {
                    Binding keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
                    if (keyBinding == null) continue;
                    table.addBinding(keyBinding);
                }
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicBinding(@UIEventTopic(value="org/eclipse/e4/ui/model/commands/BindingTable/bindings/*") Event event) {
        block4: {
            Object elementObj;
            block3: {
                elementObj = event.getProperty("ChangedElement");
                if (!(elementObj instanceof MBindingTable)) {
                    return;
                }
                if (!UIEvents.isADD((Event)event)) break block3;
                for (Object newObj : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                    if (!(newObj instanceof MKeyBinding)) continue;
                    MKeyBinding binding = (MKeyBinding)newObj;
                    this.updateBinding(binding, true, elementObj);
                }
                break block4;
            }
            if (!UIEvents.isREMOVE((Event)event)) break block4;
            for (Object oldObj : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                if (!(oldObj instanceof MKeyBinding)) continue;
                MKeyBinding binding = (MKeyBinding)oldObj;
                this.updateBinding(binding, false, elementObj);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicCommand(@UIEventTopic(value="org/eclipse/e4/ui/model/commands/KeyBinding/command/*") Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        if (!(elementObj instanceof MKeyBinding)) {
            return;
        }
        MKeyBinding binding = (MKeyBinding)elementObj;
        Object oldObj = event.getProperty("OldValue");
        MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
        oldBinding.setCommand((MCommand)oldObj);
        this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
        this.updateBinding(binding, true, null);
    }

    @Inject
    @Optional
    private void subscribeTopicKeySequence(@UIEventTopic(value="org/eclipse/e4/ui/model/commands/KeySequence/keySequence/*") Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        if (!(elementObj instanceof MKeyBinding)) {
            return;
        }
        MKeyBinding binding = (MKeyBinding)elementObj;
        Object oldObj = event.getProperty("OldValue");
        MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
        oldBinding.setKeySequence((String)oldObj);
        this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
        this.updateBinding(binding, true, null);
    }

    @Inject
    @Optional
    private void subscribeTopicParameters(@UIEventTopic(value="org/eclipse/e4/ui/model/commands/KeyBinding/parameters/*") Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        if (!(elementObj instanceof MKeyBinding)) {
            return;
        }
        MKeyBinding binding = (MKeyBinding)elementObj;
        if (UIEvents.isADD((Event)event)) {
            Object newObj = event.getProperty("NewValue");
            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
            if ("ADD_MANY".equals(event.getProperty("EventType"))) {
                oldBinding.getParameters().removeAll((Collection)newObj);
            } else {
                oldBinding.getParameters().remove(newObj);
            }
            this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
            this.updateBinding(binding, true, null);
        } else if (UIEvents.isREMOVE((Event)event)) {
            Object oldObj = event.getProperty("OldValue");
            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
            if ("REMOVE_MANY".equals(event.getProperty("EventType"))) {
                Collection parms = (Collection)oldObj;
                oldBinding.getParameters().addAll(parms);
            } else {
                oldBinding.getParameters().add((MParameter)oldObj);
            }
            this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
            this.updateBinding(binding, true, null);
        }
    }

    @Inject
    @Optional
    private void subscribeAppElemTopicTags(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        if (!(elementObj instanceof MKeyBinding)) {
            return;
        }
        MKeyBinding binding = (MKeyBinding)elementObj;
        List tags = binding.getTags();
        if (tags.contains("deleted")) {
            this.updateBinding(binding, false, elementObj);
        } else {
            this.updateBinding(binding, true, elementObj);
        }
    }

    @Inject
    @Optional
    private void subscribeContextTopicContext(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/Context/context/*") Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        Object newObj = event.getProperty("NewValue");
        if (!(newObj instanceof IEclipseContext)) {
            return;
        }
        this.activateContexts(elementObj);
    }
}

