/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceSetItemProvider;
import org.eclipse.oomph.base.util.ArchiveResourceFactoryImpl;
import org.eclipse.oomph.internal.ui.OomphDropAdapter;
import org.eclipse.oomph.internal.ui.OomphEditingDomain;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.AddToResourceCommand;
import org.eclipse.oomph.setup.ui.LoadResourceCommand;
import org.eclipse.oomph.setup.ui.ResourceCommand;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupTransferSupport {
    public static final List<? extends OomphTransferDelegate> USER_RESOLVING_DELEGATES;
    public static final List<? extends Transfer> USER_RESOLVING_TRANSFERS;
    private final List<DropListener> dropListeners = new UniqueEList();
    private final List<DropTarget> dropTargets = new ArrayList<DropTarget>();
    private final OomphEditingDomain editingDomain;
    private final OomphDropAdapter dropListener;
    private List<Resource> resources = null;

    static {
        List delegates = OomphTransferDelegate.merge((Collection)OomphTransferDelegate.DELEGATES, (OomphTransferDelegate[])new OomphTransferDelegate[]{new OomphTransferDelegate.FileTransferDelegate(){

            protected void gather(EditingDomain domain, URI uri) {
                super.gather(domain, SetupContext.isUserScheme((String)uri.scheme()) ? SetupContext.resolve((URI)uri) : uri);
            }
        }, new OomphTransferDelegate.URLTransferDelegate(){

            protected void gather(EditingDomain domain, URI uri) {
                super.gather(domain, SetupContext.isUserScheme((String)uri.scheme()) ? SetupContext.resolve((URI)uri) : uri);
            }
        }});
        USER_RESOLVING_DELEGATES = Collections.unmodifiableList(delegates);
        USER_RESOLVING_TRANSFERS = OomphTransferDelegate.asTransfers(USER_RESOLVING_DELEGATES);
    }

    public static Transfer[] userResolvingTransfers() {
        return USER_RESOLVING_TRANSFERS.toArray(new Transfer[USER_RESOLVING_TRANSFERS.size()]);
    }

    public SetupTransferSupport() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        composedAdapterFactory.insertAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory(){

            public Adapter createResourceSetAdapter() {
                return new ResourceSetItemProvider((AdapterFactory)this){

                    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
                        return this.createDragAndDropCommand(domain, commandParameter.getOwner(), 0.0f, 0, 0, commandParameter.getCollection());
                    }

                    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
                        ResourceCommand result = new AddToResourceCommand(domain, collection);
                        if (!result.canExecute()) {
                            result = new LoadResourceCommand(domain, collection);
                        }
                        return result;
                    }
                };
            }
        });
        final BasicCommandStack commandStack = new BasicCommandStack(){

            protected void handleError(Exception exception) {
            }
        };
        this.editingDomain = new OomphEditingDomain((AdapterFactory)composedAdapterFactory, (CommandStack)commandStack, null, USER_RESOLVING_DELEGATES){

            public Command createCommand(Class<? extends Command> commandClass, CommandParameter commandParameter) {
                if (commandClass == CopyCommand.class) {
                    return new IdentityCommand(commandParameter.getOwner());
                }
                return super.createCommand(commandClass, commandParameter);
            }
        };
        final ResourceSet resourceSet = this.editingDomain.getResourceSet();
        SetupCoreUtil.configureResourceSet((ResourceSet)resourceSet);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("zip", new ArchiveResourceFactoryImpl());
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Command mostRecentCommand = commandStack.getMostRecentCommand();
                if (mostRecentCommand != null) {
                    LinkedHashSet<Resource> droppedResources = new LinkedHashSet<Resource>();
                    Collection affectedObjects = mostRecentCommand.getAffectedObjects();
                    for (Object object : affectedObjects) {
                        if (!(object instanceof Resource)) continue;
                        Resource resource = (Resource)object;
                        droppedResources.add(resource);
                    }
                    resourceSet.getResources().clear();
                    if (SetupTransferSupport.this.resources == null) {
                        SetupTransferSupport.this.resourcesDropped(droppedResources);
                    } else {
                        SetupTransferSupport.this.resources.addAll(droppedResources);
                    }
                }
            }
        });
        this.dropListener = new OomphDropAdapter((EditingDomain)this.editingDomain, null, USER_RESOLVING_DELEGATES);
    }

    public void addControl(Control control) {
        int dndOperations = 7;
        DropTarget dropTarget = new DropTarget(control, dndOperations);
        dropTarget.setTransfer(SetupTransferSupport.userResolvingTransfers());
        dropTarget.addDropListener((DropTargetListener)this.dropListener);
        this.dropTargets.add(dropTarget);
    }

    public void excludeControl(Control control) {
        int dndOperations = 7;
        DropTarget dropTarget = new DropTarget(control, dndOperations);
        dropTarget.setTransfer(SetupTransferSupport.userResolvingTransfers());
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 0;
            }
        });
        this.dropTargets.add(dropTarget);
    }

    public void removeControls() {
        for (DropTarget dropTarget : this.dropTargets) {
            dropTarget.dispose();
        }
        this.dropTargets.clear();
    }

    public Collection<? extends Resource> getResources() {
        try {
            this.resources = new ArrayList<Resource>();
            Command command = this.editingDomain.createCommand(PasteFromClipboardCommand.class, new CommandParameter((Object)this.editingDomain.getResourceSet()));
            this.editingDomain.getCommandStack().execute(command);
            List<Resource> list = this.resources;
            return list;
        }
        catch (RuntimeException runtimeException) {
            List<Resource> list = this.resources;
            return list;
        }
        finally {
            this.resources = null;
        }
    }

    public void addDropListener(DropListener dropListener) {
        this.dropListeners.add(dropListener);
    }

    public void removeDropListener(DropListener dropListener) {
        this.dropListeners.remove(dropListener);
    }

    public void resourcesDropped(Collection<? extends Resource> resources) {
        for (DropListener dropListener : this.dropListeners) {
            dropListener.resourcesDropped(resources);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DropListener {
        public void resourcesDropped(Collection<? extends Resource> var1);
    }
}

