/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Dictionary;
import org.eclipse.equinox.internal.util.UtilActivator;
import org.eclipse.equinox.internal.util.security.PrivilegedRunner;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class SecurityUtil
implements PrivilegedRunner.PrivilegedDispatcher {
    private Object controlContext;
    private static final int SYSTEM_GET_PROPERTY = 41;
    private static final int CREATE_THREAD = 42;
    private static final int CLASS_FOR_NAME = 43;
    private static final int SYSTEM_SET_PROPERTY = 44;
    private static final int FILE_BASE = 50;
    private static final int FILE_GET_INPUT_STREAM = 50;
    private static final int FILE_GET_OUTPUT_STREAM = 51;
    private static final int FILE_LENGTH = 52;
    private static final int FILE_EXISTS = 53;
    private static final int FILE_ISDIR = 54;
    private static final int FILE_LAST_MODIFIED = 55;
    private static final int FILE_LIST = 56;
    private static final int FILE_DELETE = 57;
    private static final int FILE_RENAME = 58;
    private static final int FILE_GET_RANDOM_ACCESS_FILE = 59;
    private static final int SERVICE_BASE = 60;
    private static final int SERVICE_GET_REFERENCE = 60;
    private static final int SERVICE_GET_SERVICE = 61;
    private static final int SERVICE_REG_CLASS = 62;
    private static final int SERVICE_REG_CLASSES = 63;
    private static final int BUNDLE_BASE = 70;
    private static final int BUNDLE_GET_LOCATION = 70;
    private static final int BUNDLE_GET_HEADERS = 71;
    private static final int BUNDLE_START = 72;
    private static final int BUNDLE_STOP = 73;
    private static final int BUNDLE_UNINSTALL = 74;
    private static final int BUNDLE_UPDATE = 75;
    private static final int BUNDLE_UPDATE_IS = 76;

    public SecurityUtil() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.controlContext = sm.getSecurityContext();
        }
    }

    public Thread createThread(Runnable target, String name) {
        try {
            return (Thread)PrivilegedRunner.doPrivileged(this.controlContext, this, 42, target, name, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        try {
            return (Class)PrivilegedRunner.doPrivileged(this.controlContext, this, 43, name, null, null, null);
        }
        catch (ClassNotFoundException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public String getProperty(String property) {
        String ret;
        if (property == null) {
            throw new NullPointerException("property is null");
        }
        try {
            ret = (String)PrivilegedRunner.doPrivileged(this.controlContext, this, 41, property, null, null, null);
        }
        catch (Exception exception) {
            ret = null;
        }
        return ret;
    }

    public String getProperty(String property, String def) {
        String ret = this.getProperty(property);
        return ret != null ? ret : def;
    }

    public boolean getBooleanProperty(String property) {
        String ret = this.getProperty(property);
        return ret != null ? Boolean.valueOf(ret) : false;
    }

    public String setProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("key is null");
        }
        try {
            return (String)PrivilegedRunner.doPrivileged(this.controlContext, this, 44, key, value, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        try {
            return (FileInputStream)PrivilegedRunner.doPrivileged(this.controlContext, this, 50, file, null, null, null);
        }
        catch (FileNotFoundException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public RandomAccessFile getRandomAccessFile(File file, String mode) throws FileNotFoundException {
        try {
            return (RandomAccessFile)PrivilegedRunner.doPrivileged(this.controlContext, this, 59, file, mode, null, null);
        }
        catch (FileNotFoundException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public FileOutputStream getFileOutputStream(File file, boolean append) throws FileNotFoundException {
        try {
            return (FileOutputStream)PrivilegedRunner.doPrivileged(this.controlContext, this, 51, file, append ? Boolean.TRUE : Boolean.FALSE, null, null);
        }
        catch (FileNotFoundException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public boolean exists(File file) {
        try {
            return (Boolean)PrivilegedRunner.doPrivileged(this.controlContext, this, 53, file, null, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public boolean isDirectory(File file) {
        try {
            return (Boolean)PrivilegedRunner.doPrivileged(this.controlContext, this, 54, file, null, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public long length(File file) {
        try {
            return (Long)PrivilegedRunner.doPrivileged(this.controlContext, this, 52, file, null, null, null);
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public long lastModified(File file) {
        try {
            return (Long)PrivilegedRunner.doPrivileged(this.controlContext, this, 55, file, null, null, null);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public String[] list(File file) {
        try {
            return (String[])PrivilegedRunner.doPrivileged(this.controlContext, this, 56, file, null, null, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean delete(File file) {
        try {
            return (Boolean)PrivilegedRunner.doPrivileged(this.controlContext, this, 57, file, null, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public boolean renameTo(File source, File target) {
        try {
            return (Boolean)PrivilegedRunner.doPrivileged(this.controlContext, this, 58, source, target, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public Object getService(ServiceReference<?> reference, BundleContext context) {
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        if (reference == null) {
            throw new NullPointerException("Reference is null");
        }
        try {
            return PrivilegedRunner.doPrivileged(this.controlContext, this, 61, context, reference, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public ServiceReference<?>[] getServiceReferences(String clazz, String filter, BundleContext context) throws InvalidSyntaxException {
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        if (clazz == null && filter == null) {
            throw new NullPointerException("Either filter or clazz parameter should not be null");
        }
        try {
            return (ServiceReference[])PrivilegedRunner.doPrivileged(this.controlContext, this, 60, context, clazz, filter, null);
        }
        catch (InvalidSyntaxException e) {
            throw e;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<?, ?> properties, BundleContext context) {
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        if (service == null) {
            throw new NullPointerException("Service is null");
        }
        if (clazz == null) {
            throw new NullPointerException("Class name is null");
        }
        try {
            return (ServiceRegistration)PrivilegedRunner.doPrivileged(this.controlContext, this, 62, context, clazz, service, properties);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public ServiceRegistration<?> registerService(String[] classes, Object service, Dictionary<?, ?> properties, BundleContext context) {
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        if (service == null) {
            throw new NullPointerException("Service is null");
        }
        if (classes == null) {
            throw new NullPointerException("Class names are null");
        }
        try {
            return (ServiceRegistration)PrivilegedRunner.doPrivileged(this.controlContext, this, 63, context, classes, service, properties);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public String getLocation(Bundle bundle) {
        try {
            return (String)PrivilegedRunner.doPrivileged(this.controlContext, this, 70, bundle, null, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public Dictionary<?, ?> getHeaders(Bundle bundle) {
        try {
            return (Dictionary)PrivilegedRunner.doPrivileged(this.controlContext, this, 71, bundle, null, null, null);
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public void start(Bundle bundle) throws BundleException {
        try {
            PrivilegedRunner.doPrivileged(this.controlContext, this, 72, bundle, null, null, null);
        }
        catch (BundleException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public void stop(Bundle bundle) throws BundleException {
        try {
            PrivilegedRunner.doPrivileged(this.controlContext, this, 73, bundle, null, null, null);
        }
        catch (BundleException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public void uninstall(Bundle bundle) throws BundleException {
        try {
            PrivilegedRunner.doPrivileged(this.controlContext, this, 74, bundle, null, null, null);
        }
        catch (BundleException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public void update(Bundle bundle) throws BundleException {
        try {
            PrivilegedRunner.doPrivileged(this.controlContext, this, 75, bundle, null, null, null);
        }
        catch (BundleException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public void update(Bundle bundle, InputStream is) throws BundleException {
        try {
            PrivilegedRunner.doPrivileged(this.controlContext, this, 76, bundle, is, null, null);
        }
        catch (BundleException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public Object doPrivileged(PrivilegedRunner.PrivilegedDispatcher dispatcher, int type, Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        return PrivilegedRunner.doPrivileged(this.controlContext, dispatcher, type, arg1, arg2, arg3, arg4);
    }

    public Object doPrivileged(PrivilegedRunner.PrivilegedDispatcher dispatcher, int type, Object arg1, Object arg2, Object arg3) throws Exception {
        return PrivilegedRunner.doPrivileged(this.controlContext, dispatcher, type, arg1, arg2, arg3, null);
    }

    public Object doPrivileged(PrivilegedRunner.PrivilegedDispatcher dispatcher, int type, Object arg1, Object arg2) throws Exception {
        return PrivilegedRunner.doPrivileged(this.controlContext, dispatcher, type, arg1, arg2, null, null);
    }

    public Object doPrivileged(PrivilegedRunner.PrivilegedDispatcher dispatcher, int type, Object arg1) throws Exception {
        return PrivilegedRunner.doPrivileged(this.controlContext, dispatcher, type, arg1, null, null, null);
    }

    @Override
    public Object dispatchPrivileged(int type, Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        switch (type) {
            case 41: {
                return UtilActivator.bc.getProperty((String)arg1);
            }
            case 42: {
                return new Thread((Runnable)arg1, (String)arg2);
            }
            case 43: {
                return Class.forName((String)arg1);
            }
            case 44: {
                return System.getProperties().put(arg1, arg2);
            }
            case 50: {
                return new FileInputStream((File)arg1);
            }
            case 51: {
                return new FileOutputStream(((File)arg1).getAbsolutePath(), (boolean)((Boolean)arg2));
            }
            case 52: {
                return ((File)arg1).length();
            }
            case 53: {
                return ((File)arg1).exists() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 54: {
                return ((File)arg1).isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 55: {
                return ((File)arg1).lastModified();
            }
            case 56: {
                return ((File)arg1).list();
            }
            case 57: {
                return ((File)arg1).delete() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 58: {
                return ((File)arg1).renameTo((File)arg2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 59: {
                return new RandomAccessFile((File)arg1, (String)arg2);
            }
            case 60: {
                return ((BundleContext)arg1).getServiceReferences((String)arg2, (String)arg3);
            }
            case 61: {
                return ((BundleContext)arg1).getService((ServiceReference)arg2);
            }
            case 62: {
                return ((BundleContext)arg1).registerService((String)arg2, arg3, (Dictionary)arg4);
            }
            case 63: {
                return ((BundleContext)arg1).registerService((String[])arg2, arg3, (Dictionary)arg4);
            }
            case 70: {
                return ((Bundle)arg1).getLocation();
            }
            case 71: {
                return ((Bundle)arg1).getHeaders();
            }
            case 72: {
                ((Bundle)arg1).start();
                break;
            }
            case 73: {
                ((Bundle)arg1).stop();
                break;
            }
            case 74: {
                ((Bundle)arg1).uninstall();
                break;
            }
            case 75: {
                ((Bundle)arg1).update();
                break;
            }
            case 76: {
                ((Bundle)arg1).update((InputStream)arg2);
            }
        }
        return null;
    }
}

