/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSPanel;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSStatusBar;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSTrackingArea;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanel;
import org.eclipse.swt.internal.cocoa.SWTWindow;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    NSWindow window;
    SWTWindowDelegate windowDelegate;
    long hostWindowClass;
    NSWindow hostWindow;
    long tooltipOwner;
    long tooltipTag;
    long tooltipUserData;
    int glContextCount;
    boolean opened;
    boolean moved;
    boolean resized;
    boolean fullScreen;
    boolean center;
    boolean deferFlushing;
    boolean scrolling;
    boolean isPopup;
    Control lastActive;
    Rectangle normalBounds;
    boolean keyInputHappened;
    NSRect currentFrame;
    NSRect fullScreenFrame;
    ToolBar toolBar;
    Map windowEmbedCounts;
    MenuItem escMenuItem;
    static int DEFAULT_CLIENT_WIDTH = -1;
    static int DEFAULT_CLIENT_HEIGHT = -1;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0L, false);
    }

    Shell(Display display, Shell parent, int style, long handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        if (!Display.getSheetEnabled()) {
            this.center = parent != null && (style & 0x10000000) != 0;
        }
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        if (handle != 0L) {
            if (embedded) {
                this.view = new NSView(handle);
            } else {
                this.window = new NSWindow(handle);
                this.state |= 0x20000;
            }
        }
        this.reskinWidget();
        this.createWidget();
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0L, false);
    }

    public static Shell internal_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, false);
    }

    public static Shell cocoa_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, true);
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        if (((style &= 0xBFFFFFFF) & 0x10000000) != 0) {
            if (Display.getSheetEnabled()) {
                style &= 0xFFFFFB1F;
                if (parent == null) {
                    style &= 0xEFFFFFFF;
                    style |= 0x4F0;
                }
            } else {
                style &= 0xEFFFFFFF;
                style |= parent == null ? 1264 : 2144;
            }
            if ((style & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    @Override
    boolean accessibilityIsIgnored(long id2, long sel) {
        if (id2 == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void attachObserversToWindow(NSWindow newWindow) {
        Integer embedCount;
        if (newWindow == null || newWindow.id == 0L) {
            return;
        }
        long newHostWindowClass = OS.object_getClass(newWindow.id);
        long sendEventImpl = OS.class_getMethodImplementation(newHostWindowClass, OS.sel_sendEvent_);
        if (sendEventImpl == Display.windowCallback3.getAddress()) {
            return;
        }
        this.hostWindow = newWindow;
        this.hostWindow.retain();
        long embeddedSubclass = this.display.createWindowSubclass(newHostWindowClass, "SWTAWTWindow", true);
        OS.object_setClass(this.hostWindow.id, embeddedSubclass);
        this.display.addWidget(this.hostWindow, this);
        this.hostWindowClass = newHostWindowClass;
        if (this.windowEmbedCounts == null) {
            this.windowEmbedCounts = new HashMap();
        }
        if ((embedCount = (Integer)this.windowEmbedCounts.get(this.hostWindow)) == null) {
            embedCount = 0;
        }
        embedCount = embedCount + 1;
        this.windowEmbedCounts.put(this.hostWindow, embedCount);
        NSNotificationCenter defaultCenter = NSNotificationCenter.defaultCenter();
        defaultCenter.addObserver(this.windowDelegate, OS.sel_windowDidBecomeKey_, OS.NSWindowDidBecomeKeyNotification, this.hostWindow);
        defaultCenter.addObserver(this.windowDelegate, OS.sel_windowDidDeminiaturize_, OS.NSWindowDidDeminiaturizeNotification, this.hostWindow);
        defaultCenter.addObserver(this.windowDelegate, OS.sel_windowDidMiniaturize_, OS.NSWindowDidMiniaturizeNotification, this.hostWindow);
        defaultCenter.addObserver(this.windowDelegate, OS.sel_windowDidMove_, OS.NSWindowDidMoveNotification, this.hostWindow);
        defaultCenter.addObserver(this.windowDelegate, OS.sel_windowDidResize_, OS.NSWindowDidResizeNotification, this.hostWindow);
        defaultCenter.addObserver(this.windowDelegate, OS.sel_windowDidResignKey_, OS.NSWindowDidResignKeyNotification, this.hostWindow);
        defaultCenter.addObserver(this.windowDelegate, OS.sel_windowWillClose_, OS.NSWindowWillCloseNotification, this.hostWindow);
    }

    @Override
    void becomeKeyWindow(long id2, long sel) {
        Shell modal = this.getModalShell();
        if (modal != null && modal.window != null) {
            modal.window.makeKeyAndOrderFront(null);
            return;
        }
        Display display = this.display;
        display.keyWindow = this.view.window();
        super.becomeKeyWindow(id2, sel);
        display.checkFocus();
        display.keyWindow = null;
    }

    @Override
    void bringToTop(boolean force) {
        if (this.getMinimized()) {
            return;
        }
        if (force) {
            this.forceActive();
        } else {
            this.setActive();
        }
    }

    @Override
    boolean canBecomeKeyWindow(long id2, long sel) {
        if (this.isPopup) {
            return false;
        }
        if (this.window != null) {
            NSView view;
            NSView contentView;
            NSEvent nsEvent;
            if ((this.style & 0x80000) != 0 && (nsEvent = NSApplication.sharedApplication().currentEvent()) != null && nsEvent.type() == 1L && (contentView = this.window.contentView()) != null && (view = contentView.hitTest(nsEvent.locationInWindow())) == contentView) {
                return false;
            }
            long styleMask = this.window.styleMask();
            if (styleMask == 0L || (styleMask & 0xC8L) != 0L) {
                return true;
            }
        }
        return super.canBecomeKeyWindow(id2, sel);
    }

    @Override
    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        Rectangle parentRect = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int x = Math.max(parentRect.x, parentRect.x + (parentRect.width - rect.width) / 2);
        int y = Math.max(parentRect.y, parentRect.y + (parentRect.height - rect.height) / 2);
        Rectangle monitorRect = this.parent.getMonitor().getClientArea();
        x = x + rect.width > monitorRect.x + monitorRect.width ? Math.max(monitorRect.x, monitorRect.x + monitorRect.width - rect.width) : Math.max(x, monitorRect.x);
        y = y + rect.height > monitorRect.y + monitorRect.height ? Math.max(monitorRect.y, monitorRect.y + monitorRect.height - rect.height) : Math.max(y, monitorRect.y);
        this.setLocation(x, y);
    }

    @Override
    void clearDeferFlushing(long id2, long sel) {
        this.deferFlushing = false;
        this.scrolling = false;
        if (this.window != null) {
            this.window.flushWindowIfNeeded();
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget(false);
    }

    void closeWidget(boolean force) {
        if (this.display.isDisposed()) {
            return;
        }
        Event event = new Event();
        this.sendEvent(21, event);
        if ((force || event.doit) && !this.isDisposed()) {
            this.dispose();
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (this.toolBar != null && wHint == -1 && this.toolBar.itemCount > 0) {
            Point tbSize = this.toolBar.computeSize(-1, -1);
            size.x = Math.max(tbSize.x, size.x);
        }
        return size;
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        NSRect rect = new NSRect();
        rect.x = trim.x;
        rect.y = trim.y;
        rect.width = trim.width;
        rect.height = trim.height;
        if (this.window != null && !this._getFullScreen() && !this.fixResize()) {
            double h = rect.height;
            rect = this.window.frameRectForContentRect(rect);
            rect.y += h - rect.height;
        }
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    @Override
    void createHandle() {
        NSText id2;
        NSWindow fieldEditorWindow;
        this.state |= 0x10;
        if (this.window == null && this.view == null) {
            int styleMask = 0;
            if ((this.style & 0x10000004) != 0) {
                this.window = (NSWindow)new SWTPanel().alloc();
                styleMask = (this.style & 0x10000000) != 0 ? (styleMask |= 0x40) : (styleMask |= 0x90);
            } else {
                this.window = (NSWindow)new SWTWindow().alloc();
            }
            if ((this.style & 8) == 0) {
                if ((this.style & 0x20) != 0) {
                    styleMask |= 1;
                }
                if ((this.style & 0x40) != 0) {
                    styleMask |= 2;
                }
                if ((this.style & 0x80) != 0) {
                    styleMask |= 4;
                }
                if ((this.style & 0x400) != 0) {
                    styleMask |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    styleMask |= 8;
                }
            }
            NSScreen screen = null;
            NSScreen primaryScreen = new NSScreen(NSScreen.screens().objectAtIndex(0L));
            if (this.parent != null) {
                screen = this.parentWindow().screen();
            }
            if (screen == null) {
                screen = primaryScreen;
            }
            this.window = this.window.initWithContentRect(new NSRect(), styleMask, 2L, (this.style & 0x4000) != 0, screen);
            if ((this.style & 0xCF8) == 0 || (this.style & 0x10000004) != 0) {
                this.window.setHasShadow(true);
            }
            if ((this.style & 0x800000) != 0 && OS.VERSION_MMB >= OS.VERSION_MMB(10, 6, 0)) {
                this.window.setMovable(false);
            }
            if ((this.style & 4) != 0) {
                ((NSPanel)this.window).setFloatingPanel(false);
                ((NSPanel)this.window).setHidesOnDeactivate(false);
                ((NSPanel)this.window).setBecomesKeyOnlyIfNeeded(false);
            }
            this.window.setReleasedWhenClosed(true);
            if ((this.style & 8) == 0) {
                NSSize size = this.window.minSize();
                size.width = NSWindow.minFrameWidthWithTitle(NSString.string(), styleMask);
                this.window.setMinSize(size);
            }
            if (this.fixResize() && this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.display.cascadeWindow(this.window, screen);
            NSRect screenFrame = screen.frame();
            double width = screenFrame.width * 5.0 / 8.0;
            double height = screenFrame.height * 5.0 / 8.0;
            NSRect frame = this.window.frame();
            NSRect primaryFrame = primaryScreen.frame();
            frame.y = primaryFrame.height - (primaryFrame.height - (frame.y + frame.height) + height);
            frame.width = width;
            frame.height = height;
            this.window.setFrame(frame, false);
            if ((this.style & 0x4000) != 0) {
                this.window.setLevel(25L);
            }
            super.createHandle();
            this.topView().setHidden(true);
        } else {
            this.state &= 0xFFFFFFEF;
            if (this.window != null) {
                this.view = this.window.contentView();
                if (this.view == null) {
                    super.createHandle();
                } else {
                    this.view.retain();
                }
            } else {
                NSView parentView = this.view;
                super.createHandle();
                parentView.addSubview(this.topView());
            }
            this.style |= 0x40000;
        }
        this.windowDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        if (this.window == null) {
            NSWindow hostWindow = this.view.window();
            this.attachObserversToWindow(hostWindow);
        } else {
            int behavior = 0;
            if (this.parent != null) {
                behavior |= 2;
            }
            if (OS.VERSION >= 4208 && this.parent == null) {
                behavior = (this.style & 4) != 0 ? 256 : 128;
            }
            if (behavior != 0) {
                this.window.setCollectionBehavior(behavior);
            }
            this.window.setAcceptsMouseMovedEvents(true);
            this.window.setDelegate(this.windowDelegate);
        }
        if (OS.VERSION < 4192 && this.window != null) {
            this.window.windowRef();
        }
        if ((fieldEditorWindow = this.window) == null) {
            fieldEditorWindow = this.view.window();
        }
        if ((id2 = fieldEditorWindow.fieldEditor(true, null)) != null) {
            OS.object_setClass(id2.id, OS.objc_getClass("SWTEditorView"));
            new NSTextView(id2).setAllowsUndo(true);
        }
    }

    void deferFlushing() {
        this.deferFlushing = true;
        this.view.performSelector(OS.sel_clearDeferFlushing, null, 0.0, this.display.runLoopModes());
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.window != null) {
            this.display.removeWidget(this.window);
        }
        if (this.windowDelegate != null) {
            this.display.removeWidget(this.windowDelegate);
        }
    }

    @Override
    void destroyWidget() {
        NSWindow window = this.window;
        if (window != null) {
            window.retain();
        }
        Display display = this.display;
        NSView view = this.topView();
        if (view != null) {
            view.retain();
        }
        boolean sheet = (this.style & 0x10000000) != 0;
        this.releaseHandle();
        if (window != null) {
            if (sheet) {
                NSApplication application = NSApplication.sharedApplication();
                application.endSheet(window, 0L);
            }
            window.close();
        } else if (view != null) {
            view.removeFromSuperview();
        }
        if (view != null) {
            view.release();
        }
        if (window != null) {
            if (!display.isDisposed() && display.getShells().length == 0) {
                display.setMenuBar(null);
            }
            window.release();
        }
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        if (this.regionPath != null && this.background == null) {
            context.saveGraphicsState();
            NSColor.windowBackgroundColor().setFill();
            NSBezierPath.fillRect(rect);
            context.restoreGraphicsState();
            return;
        }
        super.drawBackground(id2, context, rect);
    }

    @Override
    Control findBackgroundControl() {
        return this.background != null || this.backgroundImage != null ? this : null;
    }

    @Override
    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    @Override
    Cursor findCursor() {
        return this.cursor;
    }

    boolean fixResize() {
        if (this.window == null) {
            return false;
        }
        return (this.style & 8) == 0 && (this.style & 0x10) != 0 && (this.style & 0x100004E0) == 0;
    }

    void fixShell(Shell newShell, Control control) {
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        if (this.window == null) {
            return;
        }
        this.makeKeyAndOrderFront();
        NSApplication application = NSApplication.sharedApplication();
        application.activateIgnoringOtherApps(true);
    }

    public int getAlpha() {
        this.checkWidget();
        if (this.window == null) {
            return 255;
        }
        return (int)(this.window.alphaValue() * 255.0);
    }

    @Override
    public Rectangle getBounds() {
        this.checkWidget();
        if (this.window != null) {
            NSRect frame = this.window.frame();
            double y = this.display.getPrimaryFrame().height - (double)((int)(frame.y + frame.height));
            return new Rectangle((int)frame.x, (int)y, (int)frame.width, (int)frame.height);
        }
        NSRect frame = this.view.frame();
        NSPoint pt = new NSPoint();
        NSRect primaryFrame = this.display.getPrimaryFrame();
        if (!this.view.isFlipped()) {
            pt.y = this.view.bounds().height - pt.y;
        }
        pt = this.view.convertPoint_toView_(pt, null);
        pt = this.view.window().convertBaseToScreen(pt);
        pt.y = primaryFrame.height - pt.y;
        return new Rectangle((int)pt.x, (int)pt.y, (int)frame.width, (int)frame.height);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect rect = this.window != null ? (!this.fixResize() ? this.window.contentView().frame() : this.window.frame()) : this.topView().frame();
        int width = (int)rect.width;
        int height = (int)rect.height;
        if (this.scrollView != null) {
            NSSize size = new NSSize();
            size.width = width;
            size.height = height;
            size = NSScrollView.contentSizeForFrameSize(size, (this.style & 0x100) != 0, (this.style & 0x200) != 0, 0L);
            width = (int)size.width;
            height = (int)size.height;
        }
        return new Rectangle(0, 0, width, height);
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this._getFullScreen();
    }

    boolean _getFullScreen() {
        if ((this.window.collectionBehavior() & 0x80L) != 0L) {
            return (this.window.styleMask() & 0x4000L) != 0L;
        }
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    @Override
    public Point getLocation() {
        this.checkWidget();
        if (this.window != null) {
            NSRect frame = this.window.frame();
            double y = this.display.getPrimaryFrame().height - (double)((int)(frame.y + frame.height));
            return new Point((int)frame.x, (int)y);
        }
        NSPoint pt = new NSPoint();
        NSRect primaryFrame = this.display.getPrimaryFrame();
        if (!this.view.isFlipped()) {
            pt.y = this.view.bounds().height - pt.y;
        }
        pt = this.view.convertPoint_toView_(pt, null);
        pt = this.view.window().convertBaseToScreen(pt);
        pt.y = primaryFrame.height - pt.y;
        return new Point((int)pt.x, (int)pt.y);
    }

    @Override
    public boolean getMaximized() {
        this.checkWidget();
        if (this.window == null) {
            return false;
        }
        return !this._getFullScreen() && this.window.isZoomed();
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Composite control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return modal;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return modal;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.window.isDocumentEdited();
    }

    @Override
    public boolean getMinimized() {
        this.checkWidget();
        if (!this.getVisible()) {
            return super.getMinimized();
        }
        if (this.window == null) {
            return false;
        }
        return this.window.isMiniaturized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        if (this.window == null) {
            return new Point(0, 0);
        }
        NSSize size = this.window.minSize();
        return new Point((int)size.width, (int)size.height);
    }

    @Override
    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    @Override
    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    @Override
    public Point getSize() {
        this.checkWidget();
        NSRect frame = this.window != null ? this.window.frame() : this.view.frame();
        return new Point((int)frame.width, (int)frame.height);
    }

    @Override
    float getThemeAlpha() {
        return 1.0f;
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        if ((this.style & 8) == 0 && this.toolBar == null) {
            this.toolBar = new ToolBar(this, 65792, true);
        }
        return this.toolBar;
    }

    @Override
    boolean hasBorder() {
        return false;
    }

    @Override
    boolean hasRegion() {
        return this.region != null;
    }

    @Override
    void helpRequested(long id2, long sel, long theEvent) {
        Control control = this.display.getFocusControl();
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                break;
            }
            control = control.parent;
        }
    }

    @Override
    void invalidateVisibleRegion() {
        this.resetVisibleRegion();
        if (this.toolBar != null) {
            this.toolBar.resetVisibleRegion();
        }
        this.invalidateChildrenVisibleRegion();
    }

    @Override
    boolean isDrawing() {
        return this.getDrawing();
    }

    @Override
    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    @Override
    boolean isEnabledCursor() {
        return true;
    }

    @Override
    boolean isResizing() {
        return (this.state & 0x80000) != 0;
    }

    @Override
    boolean isTransparent() {
        return false;
    }

    @Override
    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    boolean makeFirstResponder(long id2, long sel, long responder) {
        Display display = this.display;
        boolean result = super.makeFirstResponder(id2, sel, responder);
        if (!display.isDisposed()) {
            display.checkFocus();
        }
        return result;
    }

    void makeKeyAndOrderFront() {
        NSWindow parentWindow;
        if (this.parent != null && (parentWindow = this.parentWindow()).isMiniaturized()) {
            parentWindow.deminiaturize(null);
        }
        this.window.makeKeyAndOrderFront(null);
    }

    @Override
    void mouseMoved(long id2, long sel, long theEvent) {
        super.mouseMoved(id2, sel, theEvent);
        if (id2 == this.view.id && this.window == null) {
            this.view.window().mouseMoved(new NSEvent(theEvent));
        }
    }

    @Override
    void noResponderFor(long id2, long sel, long selector) {
        if (selector != OS.sel_keyDown_) {
            super.noResponderFor(id2, sel, selector);
        }
    }

    public void open() {
        this.checkWidget();
        int mask = 229376;
        if ((this.style & mask) != 0) {
            this.display.setModalShell(this);
        } else {
            this.updateModal();
        }
        this.bringToTop(false);
        this.setWindowVisible(true, true);
        if (this.isDisposed()) {
            return;
        }
        if (!(this.restoreFocus() || this.traverseGroup(true) || this.parent != null && this.parentWindow().isMiniaturized())) {
            this.setFocus();
        }
    }

    NSWindow parentWindow() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.view.window();
    }

    @Override
    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    @Override
    void register() {
        super.register();
        if (this.window != null) {
            this.display.addWidget(this.window, this);
        }
        if (this.windowDelegate != null) {
            this.display.addWidget(this.windowDelegate, this);
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        if (this.window != null) {
            this.window.setDelegate(null);
        }
        this.removeObserversFromWindow();
        if (this.windowDelegate != null) {
            this.windowDelegate.release();
        }
        this.windowDelegate = null;
        super.releaseHandle();
        this.window = null;
    }

    @Override
    void releaseParent() {
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.toolBar != null) {
            this.toolBar.dispose();
            this.toolBar = null;
        }
        if (this.tooltipTag != 0L) {
            this.view.window().contentView().removeToolTip(this.tooltipTag);
            this.tooltipTag = 0L;
        }
        this.display.clearModal(this);
        this.updateParent(false);
        this.display.updateQuitMenu();
        this.lastActive = null;
    }

    void removeObserversFromWindow() {
        NSNotificationCenter.defaultCenter().removeObserver(this.windowDelegate);
        if (this.hostWindow != null) {
            Integer embedCount = (Integer)this.windowEmbedCounts.get(this.hostWindow);
            if (embedCount == null) {
                embedCount = 0;
            }
            embedCount = embedCount - 1;
            this.windowEmbedCounts.put(this.hostWindow, embedCount);
            if (embedCount <= 0) {
                this.windowEmbedCounts.remove(this.hostWindow);
                if (this.hostWindowClass != 0L) {
                    OS.object_setClass(this.hostWindow.id, this.hostWindowClass);
                }
                this.display.removeWidget(this.hostWindow);
                this.hostWindow.release();
                this.hostWindow = null;
                this.hostWindowClass = 0L;
            }
        }
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(27, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
    }

    @Override
    public void requestLayout() {
        this.layout(null, 4);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.toolBar != null) {
            this.toolBar.reskin(flags);
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null) {
                shell.reskin(flags);
            }
            ++i;
        }
        super.reskinChildren(flags);
    }

    void sendToolTipEvent(boolean enter) {
        if (!this.isVisible()) {
            return;
        }
        NSWindow eventWindow = this.view.window();
        if (this.tooltipTag == 0L) {
            NSView view = eventWindow.contentView();
            this.tooltipTag = view.addToolTipRect(new NSRect(), eventWindow, 0L);
            if (this.tooltipTag != 0L) {
                NSDictionary userInfo;
                NSTrackingArea trackingArea = new NSTrackingArea(this.tooltipTag);
                id owner = trackingArea.owner();
                if (owner != null) {
                    this.tooltipOwner = owner.id;
                }
                if ((userInfo = trackingArea.userInfo()) != null) {
                    this.tooltipUserData = userInfo.id;
                } else {
                    long[] value = new long[1];
                    OS.object_getInstanceVariable(this.tooltipTag, new byte[]{95, 117, 115, 101, 114, 73, 110, 102, 111}, value);
                    this.tooltipUserData = value[0];
                }
            }
        }
        if (this.tooltipTag == 0L || this.tooltipOwner == 0L || this.tooltipUserData == 0L) {
            return;
        }
        NSPoint pt = eventWindow.convertScreenToBase(NSEvent.mouseLocation());
        NSEvent event = NSEvent.enterExitEventWithType(enter ? 8 : 9, pt, 0L, 0.0, eventWindow.windowNumber(), null, 0L, this.tooltipTag, this.tooltipUserData);
        OS.objc_msgSend(this.tooltipOwner, enter ? OS.sel_mouseEntered_ : OS.sel_mouseExited_, event.id);
    }

    public void setActive() {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.makeKeyAndOrderFront();
    }

    void setActiveControl(Control control) {
        this.setActiveControl(control, 0);
    }

    void setActiveControl(Control control, int type) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                Event event = new Event();
                event.detail = type;
                activate[i].sendEvent(26, event);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        this.window.setAlphaValue((float)(alpha &= 0xFF) / 255.0f);
    }

    @Override
    void setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean sheet;
        if (this.window == null) {
            if (move) {
                return;
            }
            if (resize) {
                NSSize frameSize = new NSSize();
                frameSize.width = width;
                frameSize.height = height;
                this.view.setFrameSize(frameSize);
                return;
            }
        }
        if (this._getFullScreen()) {
            this.setFullScreen(false);
        }
        if ((sheet = this.window.isSheet()) && move && !resize) {
            return;
        }
        int screenHeight = (int)this.display.getPrimaryFrame().height;
        NSRect frame = this.window.frame();
        if (!move) {
            x = (int)frame.x;
            y = screenHeight - (int)(frame.y + frame.height);
        }
        if (resize) {
            NSSize minSize = this.window.minSize();
            width = Math.max(width, (int)minSize.width);
            height = Math.max(height, (int)minSize.height);
        } else {
            width = (int)frame.width;
            height = (int)frame.height;
        }
        if (sheet) {
            y = screenHeight - (int)(frame.y + frame.height);
            NSRect parentRect = this.parent.getShell().window.frame();
            frame.width = width;
            frame.height = height;
            frame.x = parentRect.x + (parentRect.width - frame.width) / 2.0;
            frame.y = screenHeight - (int)((double)y + frame.height);
            this.window.setFrame(frame, this.isVisible(), true);
        } else {
            frame.x = x;
            frame.y = screenHeight - (y + height);
            frame.width = width;
            frame.height = height;
            this.window.setFrame(frame, this.isVisible());
        }
    }

    @Override
    void setClipRegion(NSView view) {
        if (this.regionPath != null) {
            NSView rgnView = this.topView();
            if (!rgnView.isFlipped()) {
                rgnView = this.eventView();
            }
            NSPoint pt = view.convertPoint_toView_(new NSPoint(), rgnView);
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(-pt.x, -pt.y);
            this.regionPath.transformUsingAffineTransform(transform);
            this.regionPath.addClip();
            transform.translateXBy(2.0 * pt.x, 2.0 * pt.y);
            this.regionPath.transformUsingAffineTransform(transform);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        super.setEnabled(enabled);
        if (enabled && this.window != null && this.window.isMainWindow() && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if (this.window == null) {
            return;
        }
        if (this._getFullScreen() == fullScreen) {
            return;
        }
        if ((this.window.collectionBehavior() & 0x80L) != 0L) {
            OS.objc_msgSend(this.window.id, OS.sel_toggleFullScreen_, 0);
            return;
        }
        this.fullScreen = fullScreen;
        if (fullScreen) {
            this.currentFrame = this.window.frame();
            this.window.setShowsResizeIndicator(false);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.fullScreenFrame = NSScreen.mainScreen().frame();
            if (this.getMonitor().equals(this.display.getPrimaryMonitor())) {
                if (this.menuBar != null) {
                    double menuBarHt = NSStatusBar.systemStatusBar().thickness();
                    this.fullScreenFrame.height -= menuBarHt;
                    OS.SetSystemUIMode(2, 0);
                } else {
                    OS.SetSystemUIMode(3, 0);
                }
            }
            this.window.setFrame(this.fullScreenFrame, true);
            NSRect contentViewFrame = new NSRect();
            contentViewFrame.width = this.fullScreenFrame.width;
            contentViewFrame.height = this.fullScreenFrame.height;
            this.window.contentView().setFrame(contentViewFrame);
        } else {
            this.window.setShowsResizeIndicator(true);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 1);
            }
            OS.SetSystemUIMode(0, 0);
            this.window.setFrame(this.currentFrame, true);
        }
    }

    @Override
    public void setMenuBar(Menu menu) {
        this.checkWidget();
        super.setMenuBar(menu);
        if (this.display.getActiveShell() == this) {
            this.display.setMenuBar(this.menuBar);
        }
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    @Override
    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (this.window == null) {
            return;
        }
        if (this.window.isZoomed() == maximized) {
            return;
        }
        this.window.zoom(null);
    }

    @Override
    public void setMinimized(boolean minimized) {
        this.checkWidget();
        super.setMinimized(minimized);
        if (this.window == null) {
            return;
        }
        if (!this.getVisible()) {
            return;
        }
        if (minimized) {
            this.window.miniaturize(null);
        } else {
            this.window.deminiaturize(null);
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        if (this.window == null) {
            return;
        }
        NSSize size = new NSSize();
        size.width = width;
        size.height = height;
        this.window.setMinSize(size);
        NSRect frame = this.window.frame();
        if ((double)width > frame.width || (double)height > frame.height) {
            width = (int)((double)width > frame.width ? (double)width : frame.width);
            height = (int)((double)height > frame.height ? (double)height : frame.height);
            this.setBounds(0, 0, width, height, false, true);
        }
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.window.setDocumentEdited(modified);
    }

    @Override
    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.window == null) {
            return;
        }
        if (region != null) {
            if (region.isDisposed()) {
                this.error(5);
            }
            Rectangle bounds = region.getBounds();
            this.setSize(bounds.x + bounds.width, bounds.y + bounds.height);
        }
        this.region = region;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = this.getPath(region);
        if (region != null) {
            this.window.setBackgroundColor(NSColor.clearColor());
        } else {
            this.window.setBackgroundColor(NSColor.windowBackgroundColor());
        }
        this.updateOpaque();
        this.window.contentView().setNeedsDisplay(true);
        if (this.isVisible() && this.window.hasShadow()) {
            this.window.display();
            this.window.invalidateShadow();
        }
    }

    void setScrolling() {
        this.scrolling = true;
        this.view.performSelector(OS.sel_clearDeferFlushing, null, 0.0, this.display.runLoopModes());
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.window == null) {
            return;
        }
        super.setText(string);
        NSString str = NSString.stringWith(string);
        this.window.setTitle(str);
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkWidget();
        int mask = 229376;
        if ((this.style & mask) != 0) {
            if (visible) {
                this.display.setModalShell(this);
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (this.window == null) {
            super.setVisible(visible);
        } else {
            this.setWindowVisible(visible, false);
        }
    }

    void setWindowVisible(boolean visible, boolean key) {
        Control trimControl;
        NSApplication application;
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (this.window != null && this.window.isVisible() == visible) {
            return;
        }
        if (visible) {
            this.display.clearPool();
            if (this.center && !this.moved) {
                if (this.isDisposed()) {
                    return;
                }
                this.center();
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.topView().setHidden(false);
            this.invalidateVisibleRegion();
            if (this.window != null) {
                if ((this.style & 0x10000000) != 0) {
                    application = NSApplication.sharedApplication();
                    application.beginSheet(this.window, this.parentWindow(), null, 0L, 0L);
                    if (OS.VERSION <= 4192 && this.window.respondsToSelector(OS.sel__setNeedsToUseHeartBeatWindow_)) {
                        OS.objc_msgSend(this.window.id, OS.sel__setNeedsToUseHeartBeatWindow_, 0);
                    }
                } else {
                    boolean parentMinimized;
                    boolean bl = parentMinimized = this.parent != null && this.parentWindow().isMiniaturized();
                    if (!parentMinimized) {
                        if (key && (this.style & 0x80000) == 0) {
                            this.makeKeyAndOrderFront();
                        } else {
                            this.window.orderFront(null);
                        }
                        if (this.isDisposed()) {
                            return;
                        }
                        if (this.minimized != this.window.isMiniaturized()) {
                            if (this.minimized) {
                                this.window.miniaturize(null);
                            } else {
                                this.window.deminiaturize(null);
                            }
                        }
                    }
                }
            }
            if (this.isDisposed()) {
                return;
            }
            this.updateParent(visible);
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.updateParent(visible);
            if (this.window != null) {
                if ((this.style & 0x10000000) != 0) {
                    application = NSApplication.sharedApplication();
                    application.endSheet(this.window, 0L);
                }
                this.window.orderOut(null);
            }
            if (this.isDisposed()) {
                return;
            }
            this.topView().setHidden(true);
            this.invalidateVisibleRegion();
            this.sendEvent(23);
        }
        if (this.isDisposed()) {
            return;
        }
        this.display.updateQuitMenu();
        if (this.isDisposed()) {
            return;
        }
        NSView[] hitView = new NSView[1];
        Control control = this.display.findControl(false, hitView);
        if (!(control == null || control.isActive() && control.isEnabled())) {
            control = null;
        }
        if ((trimControl = control) != null && trimControl.isTrim(hitView[0])) {
            trimControl = null;
        }
        this.display.checkEnterExit(trimControl, null, false);
    }

    @Override
    void setZOrder() {
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
        if (this.window == null) {
            return;
        }
        this.window.setContentView(this.scrollView != null ? this.scrollView : this.view);
        if (this.fixResize()) {
            NSRect rect = this.window.frame();
            rect.y = 0.0;
            rect.x = 0.0;
            this.window.contentView().setFrame(rect);
        }
    }

    @Override
    void setZOrder(Control control, boolean above) {
        if (this.window == null) {
            return;
        }
        if (!this.getVisible()) {
            return;
        }
        if (control == null) {
            if (above) {
                this.window.orderFront(null);
            } else {
                this.window.orderBack(null);
            }
        } else {
            NSWindow otherWindow = control.getShell().window;
            this.window.orderWindow(above ? 1 : -1, otherWindow.windowNumber());
        }
    }

    @Override
    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    @Override
    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.toolBar != null) {
            this.toolBar.updateCursorRects(enabled);
        }
    }

    void updateModal() {
    }

    void updateOpaque() {
        if (this.window == null) {
            return;
        }
        this.window.setOpaque(this.region == null && this.glContextCount == 0);
    }

    void updateParent(boolean visible) {
        if (this.window != null) {
            NSWindow parentWindow;
            if (visible) {
                if (this.parent != null && this.parent.getVisible()) {
                    parentWindow = this.display.modalPanel != null ? this.display.modalPanel : this.parentWindow();
                    parentWindow.addChildWindow(this.window, 1L);
                    if ((this.style & 0x4000) != 0) {
                        this.window.setLevel(25L);
                    } else if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0)) {
                        Shell parentShell = (Shell)this.parent;
                        while (parentShell.parent != null) {
                            parentShell = (Shell)parentShell.parent;
                            if (!parentShell._getFullScreen()) continue;
                            this.window.setLevel(3L);
                            break;
                        }
                    }
                }
            } else {
                parentWindow = this.window.parentWindow();
                if (parentWindow != null) {
                    parentWindow.removeChildWindow(this.window);
                }
            }
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell.parent == this && shell.getVisible()) {
                shell.updateParent(visible);
            }
            ++i;
        }
    }

    void updateSystemUIMode() {
        if ((this.window.collectionBehavior() & 0x80L) != 0L) {
            return;
        }
        if (!this.getMonitor().equals(this.display.getPrimaryMonitor())) {
            return;
        }
        int mode = this.display.systemUIMode;
        int options = this.display.systemUIOptions;
        if (this.fullScreen) {
            mode = 3;
            if (this.menuBar != null) {
                mode = 2;
            }
            options = 0;
        }
        int[] uiMode = new int[1];
        int[] uiOptions = new int[1];
        OS.GetSystemUIMode(uiMode, uiOptions);
        if (uiMode[0] != mode || uiOptions[0] != options) {
            OS.SetSystemUIMode(mode, options);
        }
        if (this.fullScreen) {
            this.window.setFrame(this.fullScreenFrame, true);
        }
    }

    @Override
    long view_stringForToolTip_point_userData(long id2, long sel, long view, long tag, long point, long userData) {
        NSPoint pt = new NSPoint();
        OS.memmove(pt, point, (long)NSPoint.sizeof);
        Control control = this.display.findControl(false);
        if (control == null) {
            return 0L;
        }
        Widget target = control.findTooltip(new NSView(view).convertPoint_toView_(pt, null));
        String string = target.tooltipText();
        if (string == null) {
            return 0L;
        }
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int length = this.fixMnemonic(chars);
        return NSString.stringWithCharacters((char[])chars, (long)((long)length)).id;
    }

    @Override
    void viewWillMoveToWindow(long id2, long sel, long newWindow) {
        if (this.window == null) {
            long currentWindow;
            long l = currentWindow = this.hostWindow != null ? this.hostWindow.id : 0L;
            if (currentWindow != 0L) {
                this.removeObserversFromWindow();
            }
            if (newWindow != 0L) {
                this.attachObserversToWindow(new NSWindow(newWindow));
            }
        }
    }

    @Override
    void windowDidBecomeKey(long id2, long sel, long notification) {
        if (this.window != null) {
            Display display = this.display;
            display.setMenuBar(this.menuBar);
        }
        this.sendEvent(26);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
        if (this.isDisposed()) {
            return;
        }
        if ((this.window.collectionBehavior() & 0x80L) == 0L) {
            Shell parentShell = this;
            while (parentShell.parent != null) {
                parentShell = (Shell)parentShell.parent;
                if (parentShell._getFullScreen()) break;
            }
            if (!parentShell._getFullScreen() || this.menuBar != null) {
                this.updateSystemUIMode();
            } else {
                parentShell.updateSystemUIMode();
            }
        }
    }

    @Override
    void windowDidDeminiturize(long id2, long sel, long notification) {
        this.minimized = false;
        this.sendEvent(20);
    }

    @Override
    void windowDidMiniturize(long id2, long sel, long notification) {
        this.minimized = true;
        this.sendEvent(19);
    }

    @Override
    void windowDidMove(long id2, long sel, long notification) {
        this.moved = true;
        this.sendEvent(10);
    }

    @Override
    void windowDidResize(long id2, long sel, long notification) {
        if ((this.window.collectionBehavior() & 0x80L) == 0L && this.fullScreen) {
            this.window.setFrame(this.fullScreenFrame, true);
            NSRect contentViewFrame = new NSRect();
            contentViewFrame.width = this.fullScreenFrame.width;
            contentViewFrame.height = this.fullScreenFrame.height;
            this.window.contentView().setFrame(contentViewFrame);
        }
        if (this.fixResize()) {
            NSRect rect = this.window.frame();
            rect.y = 0.0;
            rect.x = 0.0;
            this.window.contentView().setFrame(rect);
        }
        this.resized = true;
        this.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    @Override
    void windowDidResignKey(long id2, long sel, long notification) {
        if (this.display.isDisposed()) {
            return;
        }
        this.sendEvent(27);
        if (this.isDisposed()) {
            return;
        }
        this.setActiveControl(null);
        if (this.isDisposed()) {
            return;
        }
        this.saveFocus();
    }

    @Override
    void windowSendEvent(long id2, long sel, long event) {
        NSEvent nsEvent = new NSEvent(event);
        int type = (int)nsEvent.type();
        switch (type) {
            case 1: 
            case 3: 
            case 25: {
                this.display.clickCount = (int)((long)this.display.clickCountButton == nsEvent.buttonNumber() ? nsEvent.clickCount() : 1L);
                this.display.clickCountButton = (int)nsEvent.buttonNumber();
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 26: {
                NSView[] hitView = new NSView[1];
                Control control = this.display.findControl(false, hitView);
                if (!(control == null || control.isActive() && control.isEnabled())) {
                    control = null;
                }
                if (type == 5) {
                    Control trimControl = control;
                    if (trimControl != null && trimControl.isTrim(hitView[0])) {
                        trimControl = null;
                    }
                    this.display.checkEnterExit(trimControl, nsEvent, false);
                    if (trimControl != null && (trimControl.state & 0x100000) != 0) {
                        trimControl = null;
                    }
                    if (trimControl != null) {
                        trimControl.sendMouseEvent(nsEvent, type, false);
                    }
                }
                Widget target = null;
                if (control != null) {
                    NSWindow eventWindow;
                    NSPoint eventPoint = nsEvent.locationInWindow();
                    if (hitView[0] != null && (eventWindow = nsEvent.window()) != null && eventWindow != hitView[0].window()) {
                        eventPoint = eventWindow.convertBaseToScreen(eventPoint);
                        eventPoint = hitView[0].window().convertScreenToBase(eventPoint);
                    }
                    target = control.findTooltip(eventPoint);
                }
                if (this.display.tooltipControl != control || this.display.tooltipTarget != target) {
                    Shell shell;
                    Control oldControl = this.display.tooltipControl;
                    Shell oldShell = oldControl != null && !oldControl.isDisposed() ? oldControl.getShell() : null;
                    Shell shell2 = shell = control != null && !control.isDisposed() ? control.getShell() : null;
                    if (oldShell != null) {
                        oldShell.sendToolTipEvent(false);
                    }
                    if (shell != null) {
                        shell.sendToolTipEvent(true);
                    }
                }
                this.display.tooltipControl = control;
                this.display.tooltipTarget = target;
                break;
            }
            case 10: {
                NSString chars;
                if (this.display.escAsAcceleratorPresent && nsEvent.keyCode() == 53) {
                    NSMenu escNSMenu;
                    Menu parentMenu;
                    if (this.escMenuItem == null || this.escMenuItem.getAccelerator() != 27) {
                        this.updateEscMenuItem();
                    }
                    if (this.escMenuItem != null && (parentMenu = this.escMenuItem.getParent()) != null && (escNSMenu = parentMenu.nsMenu) != null) {
                        escNSMenu.performKeyEquivalent(nsEvent);
                    }
                }
                if ((nsEvent.modifierFlags() & 0x40000L) == 0L || (chars = nsEvent.characters()) == null || chars.length() != 1L) break;
                int firstChar = (int)chars.characterAtIndex(0L);
                switch (firstChar) {
                    case 9: 
                    case 25: 
                    case 63276: 
                    case 63277: {
                        this.view.window().firstResponder().keyDown(nsEvent);
                        return;
                    }
                }
            }
        }
        if (this.isDisposed()) {
            return;
        }
        super.windowSendEvent(id2, sel, event);
    }

    private void updateEscMenuItem() {
        if (this.menuBar != null && !this.menuBar.isDisposed()) {
            this.searchForEscMenuItem(this.menuBar);
        } else if (this.display.appMenuBar != null && !this.display.appMenuBar.isDisposed()) {
            this.searchForEscMenuItem(this.display.appMenuBar);
        }
    }

    private boolean searchForEscMenuItem(Menu menu) {
        if (menu == null || menu.isDisposed()) {
            return false;
        }
        MenuItem[] items = menu.getItems();
        if (items == null) {
            return false;
        }
        MenuItem[] menuItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item != null && !item.isDisposed()) {
                Menu subMenu;
                if (item.getAccelerator() == 27) {
                    this.escMenuItem = item;
                    return true;
                }
                if ((item.getStyle() & 0x40) != 0 && this.searchForEscMenuItem(subMenu = item.getMenu())) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    boolean windowShouldClose(long id2, long sel, long window) {
        if (this.isEnabled()) {
            this.closeWidget(false);
        }
        return false;
    }

    @Override
    void windowWillClose(long id2, long sel, long notification) {
        this.closeWidget(true);
    }
}

